/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import java.io.File;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.Util;

public class PathBuilder {
    public static final int EXTTYPE_PREPEND = 0;
    public static final int EXTTYPE_APPEND = 1;
    public static final int EXTTYPE_REPLACE = 2;
    private boolean useSubFolder;
    private String subFolder;
    private boolean useExt;
    private String ext;
    private int extType;
    private String prefix;
    private boolean usePrefix;
    private String suffix;
    private boolean useSuffix;
    private boolean useReplace;
    private String search;
    private String replace;

    public PathBuilder() {
        this.reset();
    }

    public void reset() {
        this.useSubFolder = false;
        this.subFolder = "";
        this.useExt = true;
        this.ext = ".${TrgLang}";
        this.extType = 0;
        this.prefix = "";
        this.suffix = "";
        this.usePrefix = false;
        this.useSuffix = false;
        this.useReplace = false;
        this.search = "";
        this.replace = "";
    }

    public void copyFrom(PathBuilder pathBuilder) {
        this.useSubFolder = pathBuilder.useSubFolder;
        this.subFolder = pathBuilder.subFolder;
        this.useExt = pathBuilder.useExt;
        this.ext = pathBuilder.ext;
        this.extType = pathBuilder.extType;
        this.prefix = pathBuilder.prefix;
        this.suffix = pathBuilder.suffix;
        this.usePrefix = pathBuilder.usePrefix;
        this.useSuffix = pathBuilder.useSuffix;
        this.useReplace = pathBuilder.useReplace;
        this.search = pathBuilder.search;
        this.replace = pathBuilder.replace;
    }

    public String getSubfolder() {
        return this.subFolder;
    }

    public void setSubfolder(String p_sValue) {
        this.subFolder = p_sValue;
    }

    public boolean useSubfolder() {
        return this.useSubFolder;
    }

    public void setUseSubfolder(boolean p_bValue) {
        this.useSubFolder = p_bValue;
    }

    public String getExtension() {
        return this.ext;
    }

    public void setExtension(String p_sValue) {
        this.ext = p_sValue;
    }

    public boolean useExtension() {
        return this.useExt;
    }

    public void setUseExtension(boolean p_bValue) {
        this.useExt = p_bValue;
    }

    public int getExtensionType() {
        return this.extType;
    }

    public void setExtensionType(int p_nValue) {
        this.extType = p_nValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String p_sValue) {
        this.prefix = p_sValue;
    }

    public boolean usePrefix() {
        return this.usePrefix;
    }

    public void setUsePrefix(boolean p_bValue) {
        this.usePrefix = p_bValue;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String p_sValue) {
        this.suffix = p_sValue;
    }

    public boolean useSuffix() {
        return this.useSuffix;
    }

    public void setUseSuffix(boolean p_bValue) {
        this.useSuffix = p_bValue;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String p_sValue) {
        this.search = p_sValue;
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String p_sValue) {
        this.replace = p_sValue;
    }

    public boolean useReplace() {
        return this.useReplace;
    }

    public void setUseReplace(boolean p_bValue) {
        this.useReplace = p_bValue;
    }

    public String toString() {
        ParametersString tmp = new ParametersString();
        tmp.setBoolean("useSubFolder", this.useSubfolder());
        tmp.setString("subFolder", this.getSubfolder());
        tmp.setBoolean("useExtension", this.useExtension());
        tmp.setInteger("extensionType", this.getExtensionType());
        tmp.setString("extension", this.getExtension());
        tmp.setBoolean("usePrefix", this.usePrefix());
        tmp.setString("prefix", this.getPrefix());
        tmp.setBoolean("useSuffix", this.useSuffix());
        tmp.setString("suffix", this.getSuffix());
        tmp.setBoolean("useReplace", this.useReplace());
        tmp.setString("search", this.getSearch());
        tmp.setString("replace", this.getReplace());
        return tmp.toString();
    }

    public String getPath(String p_sFullPath, String p_sOriginalRoot, String p_sNewRoot, String srcLang, String trgLang) {
        String relPath;
        String sSub;
        String sPath = p_sFullPath.substring(p_sOriginalRoot.length());
        Object sExt = Util.getExtension((String)sPath);
        if (this.useExtension()) {
            switch (this.getExtensionType()) {
                case 2: {
                    sExt = this.getExtension();
                    break;
                }
                case 1: {
                    sExt = (String)sExt + this.getExtension();
                    break;
                }
                case 0: {
                    sExt = this.getExtension() + (String)sExt;
                }
            }
        }
        Object sFile = Util.getFilename((String)sPath, (boolean)false);
        if (this.usePrefix()) {
            sFile = this.getPrefix() + (String)sFile;
        }
        if (this.useSuffix()) {
            sFile = (String)sFile + this.getSuffix();
        }
        Object sTmp = (p_sNewRoot == null || p_sNewRoot.length() == 0 ? p_sOriginalRoot : p_sNewRoot) + File.separatorChar;
        if (this.useSubfolder() && (sSub = this.getSubfolder()) != null && sSub.length() > 0) {
            sTmp = (String)sTmp + sSub + File.separatorChar;
        }
        if ((relPath = Util.getDirectoryName((String)sPath)).length() != 0) {
            sTmp = (String)sTmp + relPath.substring(1) + File.separatorChar;
        }
        sTmp = (String)sTmp + (String)sFile + (String)sExt;
        if (this.useReplace() && this.getSearch().length() != 0) {
            sTmp = ((String)sTmp).replace(this.getSearch(), this.getReplace());
        }
        return LocaleId.replaceVariables((String)sTmp, (String)srcLang, (String)trgLang);
    }
}

