/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.packages;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.applications.rainbow.packages.ManifestItem;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Manifest {
    private LinkedHashMap<Integer, ManifestItem> docs = new LinkedHashMap();
    private String rootFolder;
    private String packageID;
    private String packageType;
    private String projectID;
    private LocaleId sourceLoc;
    private LocaleId targetLoc;
    private String originalDir = "";
    private String sourceDir = "";
    private String targetDir = "";
    private String doneDir = "";
    private String readerClass;
    private String date;
    private boolean useApprovedOnly = false;
    private boolean updateApprovedFlag = true;

    public void setReaderClass(String readerClass) {
        this.readerClass = readerClass;
    }

    public String getReaderClass() {
        return this.readerClass;
    }

    public Map<Integer, ManifestItem> getItems() {
        return this.docs;
    }

    public ManifestItem getItem(int docID) {
        return this.docs.get(docID);
    }

    public String getPackageID() {
        return this.packageID;
    }

    public void setPackageID(String value) {
        this.packageID = value;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public void setPackageType(String value) {
        this.packageType = value;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public void setProjectID(String value) {
        this.projectID = value;
    }

    public LocaleId getSourceLanguage() {
        return this.sourceLoc;
    }

    public void setSourceLanguage(LocaleId value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.sourceLoc = value;
    }

    public LocaleId getTargetLanguage() {
        return this.targetLoc;
    }

    public void setTargetLanguage(LocaleId value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.targetLoc = value;
    }

    public String getRoot() {
        return this.rootFolder;
    }

    public void setRoot(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.rootFolder = value;
    }

    public String getSourceLocation() {
        return this.sourceDir;
    }

    public void setSourceLocation(String value) {
        this.sourceDir = value == null ? "" : value;
    }

    public String getTargetLocation() {
        return this.targetDir;
    }

    public void setTargetLocation(String value) {
        this.targetDir = value == null ? "" : value;
    }

    public String getOriginalLocation() {
        return this.originalDir;
    }

    public void setOriginalLocation(String value) {
        this.originalDir = value == null ? "" : value;
    }

    public String getDoneLocation() {
        return this.doneDir;
    }

    public void setDoneLocation(String value) {
        this.doneDir = value == null ? "" : value;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public String getDate() {
        return this.date;
    }

    public boolean useApprovedOnly() {
        return this.useApprovedOnly;
    }

    public void setUseApprovedOnly(boolean value) {
        this.useApprovedOnly = value;
    }

    public boolean updateApprovedFlag() {
        return this.updateApprovedFlag;
    }

    public void setUpdateApprovedFlag(boolean value) {
        this.updateApprovedFlag = value;
    }

    public void addDocument(int docID, String relativeWorkPath, String relativeInputPath, String relativeOutputPath, String inputEncoding, String outputEncoding, String filterID, String postProcessingType) {
        this.docs.put(docID, new ManifestItem(relativeWorkPath, relativeInputPath, relativeOutputPath, inputEncoding, outputEncoding, filterID, postProcessingType, true));
    }

    public String getFileToMergePath(int docID) {
        return this.rootFolder + File.separator + (String)(this.targetDir.length() == 0 ? "" : this.targetDir + File.separator) + this.docs.get(docID).getRelativeWorkPath();
    }

    public String getMergeInputRoot() {
        return this.rootFolder + File.separator + (String)(this.targetDir.length() == 0 ? "" : this.targetDir + File.separator);
    }

    public String getFileToGeneratePath(int docID) {
        return this.rootFolder + File.separator + (String)(this.doneDir.length() == 0 ? "" : this.doneDir + File.separator) + this.docs.get(docID).getRelativeOutputPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Save() {
        try (XMLWriter writer = null;){
            writer = new XMLWriter(this.rootFolder + File.separator + "manifest.xml");
            writer.writeStartDocument();
            writer.writeComment("=================================================================", true);
            writer.writeComment("PLEASE, DO NOT RENAME, MOVE, MODIFY OR ALTER IN ANY WAY THIS FILE", true);
            writer.writeComment("=================================================================", true);
            writer.writeStartElement("rainbowManifest");
            writer.writeAttributeString("xmlns:its", "http://www.w3.org/2005/11/its");
            writer.writeAttributeString("its:version", "1.0");
            writer.writeAttributeString("its:translate", "no");
            writer.writeAttributeString("projectID", this.projectID);
            writer.writeAttributeString("packageID", this.packageID);
            writer.writeAttributeString("sourceLang", this.sourceLoc.toBCP47());
            writer.writeAttributeString("targetLang", this.targetLoc.toBCP47());
            writer.writeAttributeString("packageType", this.packageType);
            writer.writeAttributeString("readerClass", this.readerClass);
            writer.writeAttributeString("originalDir", this.originalDir.replace('\\', '/'));
            writer.writeAttributeString("sourceDir", this.sourceDir.replace('\\', '/'));
            writer.writeAttributeString("targetDir", this.targetDir.replace('\\', '/'));
            writer.writeAttributeString("doneDir", this.doneDir.replace('\\', '/'));
            SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            writer.writeAttributeString("date", DF.format(new Date()));
            writer.writeAttributeString("useApprovedOnly", this.useApprovedOnly ? "yes" : "no");
            writer.writeAttributeString("updateApprovedFlag", this.updateApprovedFlag ? "yes" : "no");
            for (int id : this.docs.keySet()) {
                ManifestItem item = this.docs.get(id);
                writer.writeStartElement("doc");
                writer.writeAttributeString("id", String.valueOf(id));
                writer.writeAttributeString("filter", item.getFilterID());
                writer.writeAttributeString("work", item.getRelativeWorkPath().replace('\\', '/'));
                writer.writeAttributeString("input", item.getRelativeInputPath().replace('\\', '/'));
                writer.writeAttributeString("output", item.getRelativeOutputPath().replace('\\', '/'));
                writer.writeAttributeString("inputEncoding", item.getInputEncoding());
                writer.writeAttributeString("outputEncoding", item.getOutputEncoding());
                writer.writeAttributeString("postProcessing", item.getPostProcessingType());
                writer.writeEndElementLineBreak();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
    }

    public void load(String path) {
        try {
            DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
            Document doc = docFac.newDocumentBuilder().parse("file:///" + path);
            NodeList NL = doc.getElementsByTagName("rainbowManifest");
            if (NL == null) {
                throw new OkapiException("Invalid manifest file.");
            }
            Element elem = (Element)NL.item(0);
            if (elem == null) {
                throw new OkapiException("Invalid manifest file.");
            }
            String tmp = elem.getAttribute("projectID");
            if (tmp == null || tmp.length() == 0) {
                throw new OkapiException("Missing projectID attribute.");
            }
            this.setProjectID(tmp);
            tmp = elem.getAttribute("packageID");
            if (tmp == null || tmp.length() == 0) {
                throw new OkapiException("Missing packageID attribute.");
            }
            this.setPackageID(tmp);
            tmp = elem.getAttribute("packageType");
            if (tmp == null || tmp.length() == 0) {
                throw new OkapiException("Missing packageType attribute.");
            }
            this.setPackageType(tmp);
            tmp = elem.getAttribute("readerClass");
            if (tmp == null || tmp.length() == 0) {
                throw new OkapiException("Missing readerClass attribute.");
            }
            this.setReaderClass(tmp);
            tmp = elem.getAttribute("sourceLang");
            if (tmp == null || tmp.length() == 0) {
                throw new OkapiException("Missing sourceLang attribute.");
            }
            this.setSourceLanguage(LocaleId.fromString((String)tmp));
            tmp = elem.getAttribute("targetLang");
            if (tmp == null || tmp.length() == 0) {
                throw new OkapiException("Missing targetLang attribute.");
            }
            this.setTargetLanguage(LocaleId.fromString((String)tmp));
            tmp = elem.getAttribute("originalDir");
            this.setOriginalLocation(tmp.replace('/', File.separatorChar));
            tmp = elem.getAttribute("sourceDir");
            this.setSourceLocation(tmp.replace('/', File.separatorChar));
            tmp = elem.getAttribute("targetDir");
            this.setTargetLocation(tmp.replace('/', File.separatorChar));
            tmp = elem.getAttribute("doneDir");
            this.setDoneLocation(tmp.replace('/', File.separatorChar));
            tmp = elem.getAttribute("date");
            this.setDate(tmp);
            tmp = elem.getAttribute("useApprovedOnly");
            if (tmp != null) {
                this.setUseApprovedOnly(tmp.equals("yes"));
            }
            this.docs.clear();
            NL = elem.getElementsByTagName("doc");
            for (int i = 0; i < NL.getLength(); ++i) {
                elem = (Element)NL.item(i);
                tmp = elem.getAttribute("id");
                if (tmp == null || tmp.length() == 0) {
                    throw new OkapiException("Missing id attribute.");
                }
                int id = Integer.valueOf(tmp);
                tmp = elem.getAttribute("work");
                if (tmp == null || tmp.length() == 0) {
                    throw new OkapiException("Missing work attribute.");
                }
                String inPath = elem.getAttribute("input");
                if (inPath == null || inPath.length() == 0) {
                    throw new OkapiException("Missing input attribute.");
                }
                String outPath = elem.getAttribute("output");
                if (outPath == null || outPath.length() == 0) {
                    throw new OkapiException("Missing output attribute.");
                }
                String inEnc = elem.getAttribute("inputEncoding");
                if (inEnc == null || inEnc.length() == 0) {
                    throw new OkapiException("Missing inputEncoding attribute.");
                }
                String outEnc = elem.getAttribute("outputEncoding");
                if (outEnc == null || outEnc.length() == 0) {
                    throw new OkapiException("Missing outputEncoding attribute.");
                }
                String filterID = elem.getAttribute("filter");
                if (filterID == null || filterID.length() == 0) {
                    throw new OkapiException("Missing filter attribute.");
                }
                String postProcessingType = elem.getAttribute("postProcessing");
                if (filterID == null || filterID.length() == 0) {
                    postProcessingType = "default";
                }
                this.docs.put(id, new ManifestItem(tmp.replace('/', File.separatorChar), inPath.replace('/', File.separatorChar), outPath.replace('/', File.separatorChar), inEnc, outEnc, filterID, postProcessingType, true));
            }
            this.rootFolder = Util.getDirectoryName((String)path);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    public int checkPackageContent() {
        int nErrors = 0;
        for (int docId : this.docs.keySet()) {
            ManifestItem mi = this.docs.get(docId);
            File F = new File(this.getFileToMergePath(docId));
            if (F.exists()) continue;
            ++nErrors;
            mi.setExists(false);
        }
        return nErrors;
    }
}

