/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.pipeline;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import net.sf.okapi.applications.rainbow.pipeline.StepInfo;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class StepPicker {
    private Shell shell;
    private List lbUtilities;
    private Text edDescription;
    private String result = null;
    private ArrayList<StepInfo> availableSteps;
    private IHelp help;

    public StepPicker(Shell parent, Map<String, StepInfo> steps, IHelp helpParam) {
        this.shell = new Shell(parent, 65648);
        this.shell.setText("Add Step");
        UIUtil.inheritIcon((Shell)this.shell, (Shell)parent);
        this.shell.setLayout((Layout)new GridLayout());
        this.help = helpParam;
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Available steps:");
        this.lbUtilities = new List((Composite)this.shell, 2560);
        GridData gdTmp = new GridData(1808);
        gdTmp.heightHint = 350;
        this.lbUtilities.setLayoutData((Object)gdTmp);
        this.lbUtilities.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!StepPicker.this.saveData()) {
                    return;
                }
                StepPicker.this.shell.close();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.availableSteps = new ArrayList();
        for (String id : steps.keySet()) {
            StepInfo step = steps.get(id);
            this.lbUtilities.add(step.name);
            this.lbUtilities.setData(step.name, (Object)step.stepClass);
            this.availableSteps.add(step);
        }
        this.lbUtilities.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StepPicker.this.updateStepDisplay();
            }
        });
        this.edDescription = new Text((Composite)this.shell, 2624);
        gdTmp = new GridData(776);
        gdTmp.heightHint = 45;
        gdTmp.horizontalSpan = 2;
        this.edDescription.setLayoutData((Object)gdTmp);
        this.edDescription.setEditable(false);
        if (this.lbUtilities.getItemCount() > 0) {
            this.lbUtilities.select(0);
            this.updateStepDisplay();
        }
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StepPicker.this.result = null;
                if (e.widget.getData().equals("h")) {
                    StepPicker.this.showStepHelp();
                    return;
                }
                if (e.widget.getData().equals("o") && !StepPicker.this.saveData()) {
                    return;
                }
                StepPicker.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        pnlActions.btHelp.setText("Step Help");
        gdTmp = new GridData(768);
        pnlActions.setLayoutData((Object)gdTmp);
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow((Shell)this.shell, (Shell)parent);
    }

    private void showStepHelp() {
        try {
            int n = this.lbUtilities.getSelectionIndex();
            if (n == -1) {
                return;
            }
            StepInfo si = this.availableSteps.get(n);
            IPipelineStep step = si.loader == null ? (IPipelineStep)Class.forName(si.stepClass).newInstance() : (IPipelineStep)Class.forName(si.stepClass, true, si.loader).newInstance();
            String stepHelp = step.getHelpLocation();
            if (Util.isEmpty((String)stepHelp)) {
                return;
            }
            if (stepHelp.startsWith(".")) {
                Object path = Util.getClassLocation(step.getClass());
                if (Util.isEmpty((String)path)) {
                    return;
                }
                path = (String)path + File.separator + stepHelp + File.separator;
                n = si.stepClass.lastIndexOf(46);
                Util.openURL((String)((String)path + si.stepClass.substring(n + 1).toLowerCase() + ".html"));
            } else if (stepHelp.endsWith(".html")) {
                Util.openURL((String)stepHelp);
            } else {
                this.help.showWiki(stepHelp);
            }
        }
        catch (Throwable e) {
            Dialogs.showError((Shell)this.shell, (String)e.getMessage(), null);
        }
    }

    private void updateStepDisplay() {
        int n = this.lbUtilities.getSelectionIndex();
        if (n < 0) {
            this.edDescription.setText("");
            return;
        }
        StepInfo step = this.availableSteps.get(n);
        this.edDescription.setText(step.description);
    }

    public String showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private boolean saveData() {
        int n = this.lbUtilities.getSelectionIndex();
        if (n == -1) {
            return false;
        }
        this.result = (String)this.lbUtilities.getData(this.lbUtilities.getItem(n));
        return true;
    }
}

