/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.okapi.common.StringUtil;

public class GlossEntry
implements Iterable<Translation> {
    private String id;
    private String ref;
    private Term term;
    private Definition definition;
    private Set<Translation> translations = new LinkedHashSet<Translation>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public Set<Translation> getTranslations() {
        return this.translations;
    }

    public void addTranslation(Translation translation) {
        this.translations.add(translation);
    }

    @Override
    public Iterator<Translation> iterator() {
        return this.translations.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlossEntry that = (GlossEntry)o;
        return this.id.equals(that.id);
    }

    public String toString() {
        return "GlossEntry{id='" + this.id + "', ref='" + this.ref + "', term=" + this.term + ", definition=" + this.definition + ", translations=" + this.translations + "}";
    }

    public int hashCode() {
        return StringUtil.generateIntId(this.id);
    }

    private static class BaseField {
        private String text;
        private String source;

        private BaseField() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String toString() {
            return "BaseField{text='" + this.text + "', source='" + this.source + "'}";
        }
    }

    public static class Translation
    extends BaseField {
        private String id;
        private String ref;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Translation that = (Translation)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return StringUtil.generateIntId(this.id);
        }

        @Override
        public String toString() {
            return "Translation{id='" + this.id + "', ref='" + this.ref + "', text='" + this.getText() + "', source='" + this.getSource() + "'}";
        }
    }

    public static class Definition
    extends BaseField {
    }

    public static class Term
    extends BaseField {
    }
}

