/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.AbstractGroupParameters;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.filters.AbstractCompoundFilter;

public class CompoundFilterParameters
extends AbstractGroupParameters {
    private final LinkedList<IParameters> parameters = new LinkedList();
    private String parametersClass = "";
    private IParameters activeParameters = null;
    private String defParametersClass = "";
    private AbstractCompoundFilter parentFilter;

    public CompoundFilterParameters(AbstractCompoundFilter parentFilter) {
        this.parentFilter = parentFilter;
    }

    protected AbstractCompoundFilter getAbstractCompoundFilter() {
        return this.parentFilter;
    }

    public IParameters getActiveParameters() {
        return this.activeParameters;
    }

    protected void setActiveParameters(IParameters activeParameters) {
        this.activeParameters = activeParameters;
    }

    protected <T extends BaseParameters> boolean addParameters(Class<T> parametersClass) {
        IParameters params;
        boolean res;
        if (this.parameters == null) {
            return false;
        }
        try {
            BaseParameters bp;
            if (!BaseParameters.class.isAssignableFrom(parametersClass)) {
                return false;
            }
            try {
                Constructor<T> bpc = parametersClass.getConstructor(new Class[0]);
                bp = (BaseParameters)bpc.newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return false;
            }
            res = this.parameters.add(bp);
            if (!res) {
                return false;
            }
            params = this.parameters.getLast();
            if (params == null) {
                return false;
            }
        }
        catch (IllegalAccessException | InstantiationException e2) {
            return false;
        }
        if (this.activeParameters == null) {
            this.activeParameters = params;
            if (params.getClass() == null) {
                return false;
            }
            this.defParametersClass = params.getClass().getName();
        }
        return res;
    }

    public boolean setActiveParameters(String parametersClass) {
        IParameters params = this.findParameters(parametersClass);
        if (params == null) {
            return false;
        }
        if (this.activeParameters != params) {
            this.activeParameters = params;
            this.parametersClass = parametersClass;
        }
        if (this.parentFilter != null) {
            this.parentFilter.updateSiblingFilters();
        }
        return true;
    }

    private IParameters findParameters(String parametersClass) {
        if (this.parameters == null) {
            return null;
        }
        for (IParameters params : this.parameters) {
            if (params == null || params.getClass() == null || !params.getClass().getName().equalsIgnoreCase(parametersClass)) continue;
            return params;
        }
        return null;
    }

    public String getParametersClassName() {
        return this.parametersClass;
    }

    protected void setParametersClassName(String parametersClass) {
        this.parametersClass = parametersClass;
        this.setActiveParameters(parametersClass);
    }

    public Class<?> getParametersClass() {
        try {
            return Class.forName(this.parametersClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void setParametersClass(Class<?> parametersClass) {
        if (parametersClass == null) {
            return;
        }
        this.setParametersClassName(parametersClass.getName());
    }

    public LinkedList<IParameters> getParameters() {
        return this.parameters;
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.parentFilter.updateSiblingFilters();
    }

    @Override
    public <T extends AbstractGroupParameters> void loadGroup(ParametersString buffer, String groupName, List<T> group, Class<T> elementClass) {
        super.loadGroup(buffer, groupName, group, elementClass);
        CompoundFilterParameters item = (CompoundFilterParameters)ListUtil.getFirstNonNullItem(group);
        item.parentFilter.updateSiblingFilters();
    }

    @Override
    protected void load(ParametersString buffer) {
        this.setParametersClassName(buffer.getString("parametersClass", this.defParametersClass));
        this.setActiveParameters(this.getParametersClassName());
        for (IParameters params : this.parameters) {
            params.fromString(this.getData());
        }
        this.parentFilter.updateSiblingFilters();
    }

    @Override
    public void reset() {
        this.setParametersClassName(this.defParametersClass);
    }

    @Override
    protected void save(ParametersString buffer) {
        if (this.activeParameters != null) {
            buffer.fromString(this.activeParameters.toString());
        }
        this.parametersClass = this.activeParameters == null ? this.defParametersClass : this.activeParameters.getClass().getName();
        buffer.setString("parametersClass", this.parametersClass);
    }
}

