/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.Stack;

public class LocalizationDirectives {
    private boolean useLD;
    private boolean localizeOutside;
    private Stack<Context> context;

    public LocalizationDirectives() {
        this.reset();
    }

    public void reset() {
        this.context = new Stack();
        this.setOptions(true, true);
    }

    public boolean useLD() {
        return this.useLD;
    }

    public boolean localizeOutside() {
        if (!this.useLD) {
            return true;
        }
        return this.localizeOutside;
    }

    public boolean isWithinScope() {
        return !this.context.isEmpty();
    }

    public boolean isLocalizable(boolean popSingle) {
        if (!this.useLD) {
            return true;
        }
        boolean res = this.localizeOutside;
        if (!this.context.isEmpty()) {
            res = this.context.peek().extract;
            if (popSingle && !this.context.peek().isGroup) {
                this.context.pop();
            }
        }
        return res;
    }

    public void setOptions(boolean useLD, boolean localizeOutside) {
        this.useLD = useLD;
        this.localizeOutside = localizeOutside;
    }

    public void process(String content) {
        if (content == null || !this.useLD) {
            return;
        }
        if ((content = content.toLowerCase()).lastIndexOf("_skip") > -1) {
            this.push(false, false);
        } else if (content.lastIndexOf("_bskip") > -1) {
            this.push(true, false);
        } else if (content.lastIndexOf("_eskip") > -1) {
            this.popIfPossible();
        } else if (content.lastIndexOf("_text") > -1) {
            this.push(false, true);
        } else if (content.lastIndexOf("_btext") > -1) {
            this.push(true, true);
        } else if (content.lastIndexOf("_etext") > -1) {
            this.popIfPossible();
        }
    }

    private void push(boolean isGroup, boolean extract) {
        if (!this.context.isEmpty() && !this.context.peek().isGroup) {
            this.context.pop();
        }
        this.context.add(new Context(isGroup, extract));
    }

    private void popIfPossible() {
        if (!this.context.isEmpty()) {
            this.context.pop();
        }
    }

    private static class Context {
        boolean isGroup;
        boolean extract;

        Context(boolean isGroup, boolean extract) {
            this.isGroup = isGroup;
            this.extract = extract;
        }
    }
}

