/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.ISubFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;

public class SubFilterEventConverter {
    private final IdGenerator idGenerator;
    private final ISubFilter subFilter;
    private final IEncoder parentEncoder;
    private final Map<String, IResource> referents;

    public SubFilterEventConverter(ISubFilter subFilter, IEncoder parentEncoder) {
        this.subFilter = subFilter;
        this.parentEncoder = parentEncoder;
        this.idGenerator = new IdGenerator(null);
        this.referents = new HashMap<String, IResource>();
    }

    public void reset() {
        this.idGenerator.reset(null);
        this.referents.clear();
    }

    protected String convertRefIds(String str) {
        Object[] marker;
        StringBuilder in = new StringBuilder(str);
        StringBuilder out = new StringBuilder();
        while ((marker = TextFragment.getRefMarker(in)) != null) {
            String id = (String)marker[0];
            int start = (Integer)marker[1];
            int end = (Integer)marker[2];
            out.append(in.substring(0, start));
            IResource res = this.referents.get(id);
            if (res == null) {
                out.append(in.substring(start, end));
            } else {
                out.append(TextFragment.makeRefMarker(this.subFilter.buildResourceId(id, res.getClass())));
            }
            in.delete(0, end);
        }
        out.append((CharSequence)in);
        return out.toString();
    }

    private void convertTextContainer(TextContainer tc) {
        for (TextPart textPart : tc) {
            TextFragment tf = textPart.getContent();
            for (Code code : tf.getCodes()) {
                if (!code.hasReference()) continue;
                String data = code.getOuterData();
                String newData = this.convertRefIds(data);
                if (code.hasOuterData()) {
                    code.setOuterData(newData);
                    continue;
                }
                code.setData(newData);
            }
        }
    }

    private void convertRefs(Event event) {
        if (event.isMultiEvent()) {
            MultiEvent me = event.getMultiEvent();
            for (Event e : me) {
                this.convertRefs(e);
            }
        } else {
            if (event.isTextUnit()) {
                ITextUnit tu = event.getTextUnit();
                tu.getSource().setMimeType(tu.getMimeType());
                this.convertTextContainer(tu.getSource());
                for (LocaleId locId : tu.getTargetLocales()) {
                    tu.getTarget(locId).setMimeType(tu.getMimeType());
                    this.convertTextContainer(tu.getTarget(locId));
                }
            }
            ISkeleton skel = event.getResource().getSkeleton();
            this.convertRefsInSkeleton(skel);
        }
    }

    protected void convertRefsInSkeleton(ISkeleton skel) {
        if (skel != null) {
            if (skel instanceof GenericSkeleton) {
                GenericSkeleton gs = (GenericSkeleton)skel;
                for (GenericSkeletonPart part : gs.getParts()) {
                    String data = part.getData().toString();
                    if (!data.contains("[#$")) continue;
                    String newData = this.convertRefIds(data);
                    part.setData(newData);
                }
            } else {
                throw new OkapiException("Unexpected skeleton type: " + skel.getClass().getName());
            }
        }
    }

    public Event convertEvent(Event event) {
        IReferenceable r;
        IResource res = event.getResource();
        if (res instanceof IReferenceable && (r = (IReferenceable)((Object)res)).isReferent()) {
            this.referents.put(res.getId(), res);
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                EncoderManager em;
                StartDocument sd = event.getStartDocument();
                IFilterWriter filterWriter = sd.getFilterWriter();
                if (filterWriter != null && (em = filterWriter.getEncoderManager()) != null) {
                    em.setDefaultOptions(sd.getFilterParameters(), sd.getEncoding(), sd.getLineBreak());
                    em.updateEncoder(sd.getMimeType());
                }
                StartSubfilter startSubfilter = new StartSubfilter(this.subFilter.buildResourceId(null, StartSubfilter.class), sd, this.parentEncoder);
                this.subFilter.setStartSubfilter(startSubfilter);
                startSubfilter.setName(this.subFilter.buildResourceName(null, false, StartSubfilter.class));
                startSubfilter.setType(this.subFilter.getParentType());
                startSubfilter.setMimeType(this.subFilter.getMimeType());
                event = new Event(EventType.START_SUBFILTER, startSubfilter);
                break;
            }
            case END_DOCUMENT: {
                EndSubfilter endSubfilter = new EndSubfilter(this.subFilter.buildResourceId(null, EndSubfilter.class));
                this.subFilter.setEndSubfilter(endSubfilter);
                endSubfilter.setSkeleton(event.getEnding().getSkeleton());
                event = new Event(EventType.END_SUBFILTER, endSubfilter);
                break;
            }
            default: {
                res.setId(this.subFilter.buildResourceId(res.getId(), res.getClass()));
                if (event.getResource() instanceof INameable) {
                    boolean isEmpty;
                    INameable nres = (INameable)event.getResource();
                    String name = nres.getName();
                    if (Util.isEmpty(nres.getMimeType())) {
                        nres.setMimeType(this.subFilter.getMimeType());
                    }
                    if (Util.isEmpty(nres.getType())) {
                        nres.setType(this.subFilter.getParentType());
                    }
                    if (isEmpty = Util.isEmpty(name)) {
                        name = this.idGenerator.createId();
                    }
                    nres.setName(this.subFilter.buildResourceName(name, isEmpty, nres.getClass()));
                }
                this.convertRefs(event);
            }
        }
        return event;
    }
}

