/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.filters.AbstractSubFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilterEventConverter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubFilterWrapper
extends AbstractSubFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IFilter filter;

    public SubFilterWrapper(IFilter filter, IEncoder parentEncoder, int sectionIndex, String parentId, String parentName) {
        filter.close();
        this.filter = filter;
        this.setParentId(parentId);
        this.setParentName(parentName);
        this.setSectionIndex(sectionIndex);
        this.setParentEncoder(parentEncoder);
        this.setConverter(new SubFilterEventConverter(this, parentEncoder));
    }

    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public String getName() {
        return this.filter.getName();
    }

    @Override
    public String getDisplayName() {
        return this.filter.getDisplayName();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.getConverter().reset();
        this.filter.open(input, generateSkeleton);
    }

    @Override
    public void close() {
        this.filter.close();
        this.getConverter().reset();
    }

    @Override
    public boolean hasNext() {
        return this.filter.hasNext();
    }

    @Override
    public Event next() {
        return this.getConverter().convertEvent(this.filter.next());
    }

    @Override
    public void cancel() {
        this.filter.cancel();
    }

    @Override
    public IParameters getParameters() {
        return this.filter.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.filter.setParameters(params);
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return this.filter.createSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return this.filter.createFilterWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.filter.getEncoderManager();
    }

    @Override
    public String getMimeType() {
        return this.filter.getMimeType();
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        super.setFilterConfigurationMapper(fcMapper);
        this.filter.setFilterConfigurationMapper(this.getFilterConfigurationMapper());
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        return this.filter.getConfigurations();
    }
}

