/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipelinebuilder;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipeline.PipelineReturnValue;
import net.sf.okapi.common.pipelinebuilder.XBatch;
import net.sf.okapi.common.pipelinebuilder.XFilters;
import net.sf.okapi.common.pipelinebuilder.XPipelineAsStepImpl;
import net.sf.okapi.common.pipelinebuilder.XPipelineStep;
import net.sf.okapi.common.pipelinebuilder.XPipelineType;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;

public class XPipeline
extends Pipeline
implements IPipelineStep {
    private final XPipelineAsStepImpl stepImpl = new XPipelineAsStepImpl();
    private final XPipelineType type;
    private XBatch batch;
    private PipelineDriver pd;
    private FilterConfigurationMapper fcMapper;
    private IObservable delegatedObservable;

    public XPipeline(String description, IPipeline pipeline) {
        this(description, pipeline.getSteps().toArray(new IPipelineStep[0]));
        this.setId(pipeline.getId());
    }

    public XPipeline(String description, IPipelineStep ... steps) {
        this(description, XPipelineType.SEQUENTIAL, steps);
    }

    public XPipeline(String description, XPipelineType type, IPipelineStep ... steps) {
        this(description, type, true, steps);
    }

    private XPipeline(String description, XPipelineType type, boolean buildPipeline, IPipelineStep ... steps) {
        this.stepImpl.setDescription(description);
        this.type = type;
        for (IPipelineStep step : steps) {
            if (step instanceof XPipelineStep) {
                if (((XPipelineStep)step).getStep() == null) continue;
                this.addStep(step);
                continue;
            }
            if (step instanceof IPipeline) {
                IPipeline pl;
                if (step instanceof XPipeline) {
                    pl = (XPipeline)step;
                    if (((XPipeline)pl).type == XPipelineType.PARALLEL) {
                        this.addStep(step);
                        continue;
                    }
                    for (IPipelineStep s : ((Pipeline)pl).getSteps()) {
                        this.addStep(s);
                    }
                    continue;
                }
                pl = (IPipeline)((Object)step);
                for (IPipelineStep s : pl.getSteps()) {
                    this.addStep(s);
                }
                continue;
            }
            this.addStep(step);
        }
        if (buildPipeline) {
            this.recreatePipeline();
        }
    }

    public XPipeline(String description, XBatch batch, IPipelineStep ... steps) {
        this(description, batch, XPipelineType.SEQUENTIAL, steps);
    }

    public XPipeline(String description, XFilters filters, XBatch batch, IPipelineStep ... steps) {
        this(description, XPipelineType.SEQUENTIAL, false, steps);
        this.fcMapper = filters.getFcMapper();
        this.setBatch(batch);
    }

    public XPipeline(String description, XFilters filters, String rootDir, XBatch batch, IPipelineStep ... steps) {
        this(description, filters, batch, steps);
        this.pd.setRootDirectories(Util.getDirectoryName(rootDir), Util.getDirectoryName(rootDir));
    }

    public XPipeline(String description, XBatch batch, XPipelineType type, IPipelineStep ... steps) {
        this(description, type, false, steps);
        this.setBatch(batch);
    }

    private void recreatePipeline() {
        this.pd = new PipelineDriver();
        IPipeline pl = this.pd.getPipeline();
        if (pl instanceof Pipeline) {
            this.delegatedObservable = (IObservable)((Object)pl);
        }
        for (IPipelineStep step : this.getSteps()) {
            if (step instanceof XPipelineStep) {
                this.pd.addStep(((XPipelineStep)step).getStep());
                continue;
            }
            if (step == null) continue;
            this.pd.addStep(step);
        }
        if (this.fcMapper == null) {
            this.fcMapper = new FilterConfigurationMapper();
            DefaultFilters.setMappings(this.fcMapper, true, true);
        }
        this.pd.setFilterConfigurationMapper(this.fcMapper);
        if (this.batch == null) {
            return;
        }
        for (IBatchItemContext item : this.batch.getItems()) {
            this.pd.addBatchItem(item);
        }
    }

    public PipelineReturnValue execute() {
        if (this.batch == null) {
            return this.getState();
        }
        if (this.pd == null) {
            return this.getState();
        }
        this.pd.processBatch();
        PipelineReturnValue state = this.pd.getPipeline().getState();
        this.pd.getPipeline().destroy();
        return state;
    }

    public void stop() {
        this.pd.getPipeline().cancel();
    }

    @Override
    public String getHelpLocation() {
        return this.stepImpl.getHelpLocation();
    }

    @Override
    public String getName() {
        return this.stepImpl.getName();
    }

    @Override
    public IParameters getParameters() {
        return this.stepImpl.getParameters();
    }

    @Override
    public Event handleEvent(Event event) {
        if (this.type == XPipelineType.SEQUENTIAL) {
            // empty if block
        }
        return this.stepImpl.handleEvent(event);
    }

    @Override
    public boolean isDone() {
        return this.stepImpl.isDone();
    }

    @Override
    public boolean isLastOutputStep() {
        return this.stepImpl.isLastOutputStep();
    }

    @Override
    public void setLastOutputStep(boolean isLastStep) {
        this.stepImpl.setLastOutputStep(isLastStep);
    }

    @Override
    public void setParameters(IParameters params) {
        this.stepImpl.setParameters(params);
    }

    public XBatch getBatch() {
        return this.batch;
    }

    public void setBatch(XBatch batch) {
        this.batch = batch;
        this.recreatePipeline();
    }

    @Override
    public String getDescription() {
        return this.stepImpl.getDescription();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<IObserver> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

