/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource.simplifier;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.simplifier.AbstractResourceSimplifier;
import net.sf.okapi.common.resource.simplifier.IResourceSimplifier;
import net.sf.okapi.common.skeleton.GenericSkeletonSimplifier;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSimplifier
extends AbstractResourceSimplifier {
    private final Map<Class<?>, Class<? extends IResourceSimplifier>> FW_TO_RS_MAP = new LinkedHashMap<Class<?>, Class<? extends IResourceSimplifier>>(){
        private static final long serialVersionUID = 293052660643251017L;
    };
    private final Map<Class<?>, Class<? extends IResourceSimplifier>> SW_TO_RS_MAP = new LinkedHashMap<Class<?>, Class<? extends IResourceSimplifier>>(){
        private static final long serialVersionUID = 293052660643251018L;
        {
            this.put(GenericSkeletonWriter.class, GenericSkeletonSimplifier.class);
        }
    };
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Stack<IResourceSimplifier> sStack;
    private Stack<StartDocument> sdStack;
    private Map<String, MultiEvent> groups;
    private IResourceSimplifier simplifier;
    private StartDocument startDocument;
    private boolean updateLayer;

    public ResourceSimplifier(LocaleId trgLoc) {
        super.setTargetLocale(trgLoc);
        this.sStack = new Stack();
        this.sdStack = new Stack();
        this.groups = new HashMap<String, MultiEvent>();
    }

    @Override
    public void initialize() {
    }

    private void clear() {
        this.sStack.clear();
        this.sdStack.clear();
        this.groups.clear();
        this.startDocument = null;
        this.simplifier = null;
    }

    private Class<? extends IResourceSimplifier> fuzzyLookup(Map<Class<?>, Class<? extends IResourceSimplifier>> map, Class<?> classRef) {
        Class<? extends IResourceSimplifier> res = map.get(classRef);
        if (res == null) {
            LinkedList keys = new LinkedList(map.keySet());
            Iterator<Class<?>> it = keys.descendingIterator();
            while (it.hasNext()) {
                Class<?> k = it.next();
                if (!k.isAssignableFrom(classRef)) continue;
                res = map.get(k);
                break;
            }
        }
        return res;
    }

    private IResourceSimplifier createSimplifier(StartDocument startDocument) {
        IFilterWriter filterWriter;
        if (startDocument == null) {
            return null;
        }
        IFilterWriter iFilterWriter = filterWriter = this.getFilterWriter() == null ? startDocument.getFilterWriter() : this.getFilterWriter();
        if (filterWriter == null) {
            return null;
        }
        ISkeletonWriter skelWriter = this.getSkeletonWriter() == null ? filterWriter.getSkeletonWriter() : this.getSkeletonWriter();
        Class<? extends IResourceSimplifier> rsClass = this.fuzzyLookup(this.FW_TO_RS_MAP, filterWriter.getClass());
        if (rsClass == null && skelWriter != null) {
            rsClass = this.fuzzyLookup(this.SW_TO_RS_MAP, skelWriter.getClass());
        }
        if (rsClass == null) {
            filterWriter.close();
            return null;
        }
        IResourceSimplifier rs = null;
        try {
            rs = ClassUtil.instantiateClass(rsClass);
            rs.setParent(this);
            rs.setMultilingual(startDocument.isMultilingual());
            rs.setTargetLocale(this.getTargetLocale());
            rs.setOutputEncoding(this.getOutputEncoding());
            rs.setFilterWriter(filterWriter);
            rs.setSkeletonWriter(skelWriter);
            rs.initialize();
            if (filterWriter != null && skelWriter != null) {
                EncoderManager em = filterWriter.getEncoderManager();
                skelWriter.processStartDocument(this.getTargetLocale(), this.getOutputEncoding(), em, startDocument);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.error("Unable to instantiate a resource simplifier for {} (mapped to {}).", (Object)ClassUtil.getClassName(filterWriter), (Object)ClassUtil.getClassName(rsClass));
            return null;
        }
        return rs;
    }

    @Override
    public Event convert(Event event) {
        EventType eventType = event.getEventType();
        if (this.updateLayer) {
            this.simplifier = this.createSimplifier(this.startDocument);
            this.updateLayer = false;
        }
        switch (eventType) {
            case START_DOCUMENT: {
                this.clear();
                this.updateLayer = false;
                break;
            }
            case START_SUBFILTER: {
                this.sStack.push(this.simplifier);
                this.simplifier = null;
                this.sdStack.push(this.startDocument);
                this.startDocument = null;
                break;
            }
            case START_SUBDOCUMENT: {
                this.sStack.push(this.simplifier);
                this.simplifier = null;
                break;
            }
        }
        switch (eventType) {
            case START_DOCUMENT: {
                this.startDocument = event.getStartDocument();
                if (this.startDocument == null) break;
                if (this.getTargetLocale() == null) {
                    this.setTargetLocale(this.startDocument.getLocale());
                }
                if (Util.isEmpty(this.getOutputEncoding())) {
                    this.setOutputEncoding(this.startDocument.getEncoding());
                }
                this.simplifier = this.createSimplifier(this.startDocument);
                if (this.simplifier == null) break;
                event = this.simplifier.convert(event);
                break;
            }
            case START_SUBDOCUMENT: {
                StartSubDocument ssd = event.getStartSubDocument();
                if (ssd == null) break;
                if (this.startDocument == null) {
                    this.logger.error("StartDocument resource is not found for StartSubDocument id = {}.", (Object)ssd.getId());
                    break;
                }
                this.updateLayer = true;
                break;
            }
            case START_SUBFILTER: {
                StartSubfilter ssf = event.getStartSubfilter();
                if (ssf == null) break;
                this.startDocument = ssf.getStartDoc();
                if (this.startDocument == null) break;
                this.simplifier = this.createSimplifier(this.startDocument);
                if (this.simplifier == null) break;
                event = this.simplifier.convert(event);
                break;
            }
            case END_SUBFILTER: {
                break;
            }
            default: {
                if (this.simplifier == null) break;
                event = this.simplifier.convert(event);
            }
        }
        switch (eventType) {
            case END_DOCUMENT: {
                this.clear();
                break;
            }
            case END_SUBFILTER: {
                event = this.simplifier.convert(event);
                this.startDocument = this.sdStack.pop();
                this.simplifier = this.sStack.pop();
                break;
            }
            case END_SUBDOCUMENT: {
                this.simplifier = this.sStack.pop();
                break;
            }
        }
        return event;
    }

    public void mapFilterWriter(Class<? extends IFilterWriter> filterWriter, Class<? extends IResourceSimplifier> simplifier) {
        this.FW_TO_RS_MAP.put(filterWriter, simplifier);
    }

    public void mapSkeletonWriter(Class<? extends ISkeletonWriter> skeletonWriter, Class<? extends IResourceSimplifier> simplifier) {
        this.SW_TO_RS_MAP.put(skeletonWriter, simplifier);
    }

    @Override
    protected Event convertEvent(Event event) {
        return null;
    }

    @Override
    public MultiEvent getGroup(String groupId) {
        return this.groups.get(groupId);
    }

    @Override
    public void setGroup(String groupId, MultiEvent group) {
        this.groups.put(groupId, group);
    }
}

