/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.connectors.microsoft.GetTranslationsArrayRequest;
import net.sf.okapi.connectors.microsoft.MicrosoftMTAPI;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.connectors.microsoft.TranslateResponse;
import net.sf.okapi.connectors.microsoft.TranslationResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MicrosoftMTAPIv3Impl
implements MicrosoftMTAPI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int FIXED_FUZZY_SCORE = 95;
    private Parameters params;
    private HttpClient httpClient;
    private String serviceURL;
    private ObjectMapper objectMapper = new ObjectMapper();

    MicrosoftMTAPIv3Impl(Parameters params, HttpClient httpClient) {
        this.params = params;
        this.httpClient = httpClient;
        this.serviceURL = params.getBaseURL() + "/translate";
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public List<TranslationResponse> getTranslations(String text, String srcLang, String trgLang, int maxHits, int threshold) {
        GetTranslationsArrayRequest singleTextRequest = new GetTranslationsArrayRequest(Collections.singletonList(text), srcLang, trgLang, maxHits, this.params.getCategory());
        List<List<TranslationResponse>> x = this.getTranslationsArray(singleTextRequest, srcLang, trgLang, maxHits, threshold);
        return x.get(0);
    }

    @Override
    public List<List<TranslationResponse>> getTranslationsArray(GetTranslationsArrayRequest request, String srcLang, String trgLang, int maxHits, int threshold) {
        if (this.params.getAzureKey() == null || this.params.getAzureKey().isEmpty()) {
            this.logger.error("Azure Key is not configured.");
            return Collections.emptyList();
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(this.serviceURL);
            uriBuilder.addParameter("api-version", "3.0");
            uriBuilder.addParameter("from", srcLang);
            uriBuilder.addParameter("to", trgLang);
            uriBuilder.addParameter("textType", "html");
            if (this.params.getCategory() != null && !this.params.getCategory().isEmpty()) {
                uriBuilder.addParameter("category", this.params.getCategory());
            }
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("Ocp-Apim-Subscription-Key", this.params.getAzureKey());
            httpPost.addHeader("X-ClientTraceId", UUID.randomUUID().toString());
            String requestBody = request.toJSON();
            httpPost.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (Charset)StandardCharsets.UTF_8)));
            List<TranslateResponse> res = this.execute((HttpUriRequest)httpPost, new TypeReference<List<TranslateResponse>>(){}, requestBody);
            if (request.getNumRequests() != res.size()) {
                this.logger.error("{} pieces of text requested but {} pieces of translation returned.", (Object)request.getNumRequests(), (Object)res.size());
            }
            ArrayList<List<TranslationResponse>> lltr = new ArrayList<List<TranslationResponse>>(res.size());
            int i = 0;
            for (TranslateResponse tr : res) {
                lltr.add(Collections.singletonList(new TranslationResponse(request.getText(i++), tr.translations.get((int)0).text, QueryResult.QUALITY_UNDEFINED, 95)));
            }
            return lltr;
        }
        catch (IOException | URISyntaxException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.logger.error("translation from {} to {} failed with exception: {}", new Object[]{srcLang, trgLang, sw.toString()});
            return Collections.emptyList();
        }
    }

    private <T> T execute(HttpUriRequest request, TypeReference<T> responseType, String requestBody) throws IOException {
        HttpResponse response = this.httpClient.execute(request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        if (response.getStatusLine().getStatusCode() != 200) {
            String message = String.format("Call to %s \"%s\" failed with code \"%d\", reason \"%s\", and response body:\n%s \nfor request body:\n%s", request.getMethod(), request.getURI().toString(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), responseBody, requestBody);
            throw new IOException(message);
        }
        try {
            return (T)this.objectMapper.readValue(responseBody, responseType);
        }
        catch (IOException e) {
            this.logger.error("Unable to deserialize response: {}\n", (Object)responseBody);
            throw e;
        }
    }

    @Override
    public String getBaseURL() {
        return this.params.getBaseURL();
    }

    @Override
    public int maxCharCount() {
        return 5000;
    }

    @Override
    public int maxTextCount() {
        return 100;
    }
}

