/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.dtd;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDOutput;
import com.wutka.dtd.DTDParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.encoder.DTDEncoder;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.dtd.Parameters;

@UsingParameters(value=Parameters.class)
public class DTDFilter
implements IFilter {
    private Parameters params = new Parameters();
    private String encoding;
    private boolean canceled;
    private int parseState;
    private boolean hasUTF8BOM;
    private String docName;
    private Enumeration<?> items;
    private String lineBreak;
    private LocaleId srcLang;
    private int tuId;
    private int otherId;
    private PrintWriter writer;
    private StringWriter strWriter;
    private GenericSkeleton skel;
    private final Pattern pattern;
    private Hashtable<String, Character> charEntities;
    private final DTDEncoder encoder;
    private EncoderManager encoderManager;
    private RawDocument input;

    public DTDFilter() {
        String tmp = "&#([0-9]*?);|&#[xX]([0-9a-f]*?);|(&\\w*?;)|(%\\w*?;)";
        this.pattern = Pattern.compile(tmp, 2);
        this.createCharEntitiesTable();
        this.encoder = new DTDEncoder();
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        this.parseState = 0;
        if (this.strWriter != null) {
            this.strWriter = null;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return "okf_dtd";
    }

    @Override
    public String getDisplayName() {
        return "DTD Filter";
    }

    @Override
    public String getMimeType() {
        return "application/xml+dtd";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.parseState > 0;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.parseState = 0;
            return new Event(EventType.CANCELED);
        }
        if (this.parseState == 1) {
            return this.start();
        }
        Event event = this.parse();
        if (event.getEventType() == EventType.END_DOCUMENT) {
            this.parseState = 0;
        }
        return event;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration("okf_dtd", "application/xml+dtd", this.getClass().getName(), "DTD (Document Type Definition)", "Configuration for XML DTD documents (entities content)", null, ".dtd;.ent;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/xml+dtd", "net.sf.okapi.common.encoder.DTDEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        this.parseState = 1;
        this.canceled = false;
        this.tuId = 0;
        this.otherId = 0;
        this.strWriter = new StringWriter();
        this.writer = new PrintWriter(this.strWriter);
        if (this.params.getUseCodeFinder()) {
            this.params.codeFinder.compile();
        }
        Reader rdr = null;
        try {
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            input.setEncoding(detector.getEncoding());
            this.encoding = detector.getEncoding();
            DTDParser parser = new DTDParser(input.getReader());
            this.srcLang = input.getSourceLocale();
            this.hasUTF8BOM = detector.hasUtf8Bom();
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            DTD dtd = parser.parse();
            this.items = dtd.items.elements();
            this.encoder.setOptions(null, this.encoding, this.lineBreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error parsing the DTD", e);
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error when closing the DTD reader.", e);
                }
            }
        }
    }

    private Event start() {
        StartDocument startDoc = new StartDocument(String.valueOf(++this.otherId));
        startDoc.setFilterId(this.getName());
        startDoc.setFilterParameters(this.params);
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setLocale(this.srcLang);
        startDoc.setMimeType("application/xml+dtd");
        startDoc.setName(this.docName);
        this.parseState = 2;
        return new Event(EventType.START_DOCUMENT, startDoc);
    }

    private Event parse() {
        StringBuilder note = null;
        this.skel = null;
        while (this.items.hasMoreElements()) {
            Object obj = this.items.nextElement();
            if (obj instanceof DTDEntity) {
                DTDEntity tmp = (DTDEntity)obj;
                if (tmp.isParsed || tmp.value == null) {
                    this.addToSkeleton(tmp, null);
                    continue;
                }
                TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
                tu.setMimeType("application/xml+dtd");
                tu.setName(tmp.name);
                TextFragment tf = this.process(tmp.value);
                if (this.params.getUseCodeFinder()) {
                    this.params.codeFinder.process(tf);
                    List<Code> codes = tf.getCodes();
                    for (Code code : codes) {
                        if (!code.getType().equals("regxph")) continue;
                        code.setData(this.encoder.encode(code.getData(), EncoderContext.TEXT));
                    }
                }
                tu.setSourceContent(tf);
                if (note != null) {
                    NoteAnnotation notes = new NoteAnnotation();
                    Note n = new Note(note.toString());
                    notes.add(n);
                    tu.setAnnotation(notes);
                }
                if (this.skel == null) {
                    this.skel = new GenericSkeleton();
                }
                this.addToSkeleton(tmp, tu);
                tu.setSkeleton(this.skel);
                return new Event(EventType.TEXT_UNIT, tu);
            }
            if (obj instanceof DTDComment) {
                if (note == null) {
                    note = new StringBuilder();
                } else {
                    note.append("\n");
                }
                note.append(((DTDComment)obj).text);
                this.addToSkeleton((DTDOutput)obj);
                continue;
            }
            this.addToSkeleton((DTDOutput)obj);
        }
        Ending ending = new Ending(String.valueOf(++this.otherId));
        if (this.skel != null) {
            ending.setSkeleton(this.skel);
        }
        return new Event(EventType.END_DOCUMENT, ending);
    }

    private void addToSkeleton(DTDEntity entity, ITextUnit tu) {
        this.skel.append("<!ENTITY ");
        if (entity.isParsed) {
            this.skel.append(" % ");
        }
        this.skel.append(entity.name);
        this.skel.append(" ");
        if (entity.value == null) {
            StringWriter sr = new StringWriter();
            PrintWriter pr = new PrintWriter(sr);
            try {
                entity.externalID.write(pr);
            }
            catch (IOException e) {
                throw new OkapiIOException("Error writing externalID of entity.", e);
            }
            this.skel.append(sr.toString());
            if (entity.ndata != null) {
                this.skel.append(" NDATA ");
                this.skel.append(entity.ndata);
            }
        } else {
            this.skel.append("\"");
            if (tu == null) {
                this.skel.append(entity.value);
            } else {
                this.skel.addContentPlaceholder(tu);
            }
            this.skel.append("\"");
        }
        this.skel.append(">" + this.lineBreak);
    }

    private void addToSkeleton(DTDOutput obj) {
        try {
            this.strWriter.getBuffer().setLength(0);
            obj.write(this.writer);
            if (this.skel == null) {
                this.skel = new GenericSkeleton(this.strWriter.toString());
            } else {
                this.skel.append(this.strWriter.toString());
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing skeleton.", e);
        }
    }

    private TextFragment process(String text) {
        int len = text.length();
        Matcher m = this.pattern.matcher(text);
        int pos = 0;
        String seq = null;
        TextFragment tf = new TextFragment();
        while (m.find(pos)) {
            if (m.start() > pos) {
                tf.append(text.substring(pos, m.start()));
            }
            pos = m.end();
            seq = m.group();
            int value = -1;
            value = seq.indexOf(120) == 2 ? Integer.parseInt(seq.substring(3, seq.length() - 1), 16) : (seq.indexOf(35) == 1 ? Integer.parseInt(seq.substring(2, seq.length() - 1)) : (this.charEntities.containsKey(seq = seq.substring(1, seq.length() - 1)) ? (int)this.charEntities.get(seq).charValue() : -1));
            if (value > -1) {
                tf.append((char)value);
                continue;
            }
            tf.append(TextFragment.TagType.PLACEHOLDER, "x-ref", m.group());
        }
        if (seq == null) {
            tf.append(text);
        } else if (pos < len) {
            tf.append(text.substring(pos, len));
        }
        return tf;
    }

    private void createCharEntitiesTable() {
        this.charEntities = new Hashtable();
        this.charEntities.put("amp", Character.valueOf('&'));
        this.charEntities.put("lt", Character.valueOf('<'));
        this.charEntities.put("gt", Character.valueOf('>'));
        this.charEntities.put("quot", Character.valueOf('\"'));
        this.charEntities.put("apos", Character.valueOf('\''));
    }
}

