/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.html;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupFilter;
import net.sf.okapi.filters.abstractmarkup.ExtractionRuleState;
import net.sf.okapi.filters.abstractmarkup.config.TaggedFilterConfiguration;
import net.sf.okapi.filters.html.HtmlSkeletonWriter;
import net.sf.okapi.filters.html.Parameters;
import net.sf.okapi.filters.html.StreamedSourceCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class HtmlFilter
extends AbstractMarkupFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Parameters parameters;
    private RawDocument tempSourceInput;
    private File tempSourceFile;

    public HtmlFilter() {
        this.setMimeType("text/html");
        this.setParameters(new Parameters());
        this.setName("okf_html");
        this.setDisplayName("HTML/XHTML Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), "text/html", this.getClass().getName(), "HTML", "HTML or XHTML documents", "nonwellformedConfiguration.yml", ".html;.htm;"));
        this.addConfiguration(new FilterConfiguration(this.getName() + "-wellFormed", "text/xhtml", this.getClass().getName(), "HTML (Well-Formed)", "XHTML and well-formed HTML documents", "wellformedConfiguration.yml", ".xhtml"));
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new HtmlSkeletonWriter();
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        String encoding = this.detectEncoding(input);
        this.setCurrentDocName(input.getInputURI() == null ? "" : input.getInputURI().getPath());
        if (this.getConfig().shouldCleanupHtml()) {
            try {
                this.tempSourceInput = StreamedSourceCopy.htmlTidiedRewrite(input, this.isDocumentEncoding(), encoding, this.isBOM());
                this.tempSourceFile = new File(this.tempSourceInput.getInputURI());
            }
            catch (IOException e) {
                throw new OkapiIOException("Error generating tidied source temp file", e);
            }
            super.open(this.tempSourceInput, generateSkeleton);
        } else {
            super.open(input, generateSkeleton);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.tempSourceFile != null) {
            this.tempSourceFile.delete();
        }
    }

    @Override
    protected void startFilter() {
        super.startFilter();
        if (!this.getConfig().isGlobalPreserveWhitespace()) {
            this.LOGGER.debug("By default the HTML filter will collapse whitespace unless overridden in the configuration");
        }
        this.getEventBuilder().initializeCodeFinder(this.getConfig().isUseCodeFinder(), this.getConfig().getCodeFinderRules());
    }

    @Override
    protected void endFilter() {
        super.endFilter();
        if (this.tempSourceInput != null) {
            this.tempSourceInput.close();
            boolean success = new File(this.tempSourceInput.getInputURI()).delete();
            if (!success) {
                this.LOGGER.warn("Couldn't delete HTML Filter tidied temp file");
            }
        }
    }

    @Override
    protected void preProcess(Segment segment) {
        super.preProcess(segment);
        if (this.getConfig().isWellformed()) {
            return;
        }
        boolean inline = this.isInline(segment);
        if (this.getEventBuilder().isCurrentTextUnit() && !inline) {
            ExtractionRuleState.ExtractionRule r = new ExtractionRuleState.ExtractionRule("", TaggedFilterConfiguration.RULE_TYPE.RULE_NOT_FOUND, true);
            if (segment instanceof Tag) {
                r = this.getMainElementRule((Tag)segment);
            }
            if ((r.ruleType == TaggedFilterConfiguration.RULE_TYPE.TEXT_UNIT_ELEMENT || r.ruleType == TaggedFilterConfiguration.RULE_TYPE.GROUP_ELEMENT) && segment instanceof StartTag) {
                this.getEventBuilder().endTextUnit();
            }
        }
    }

    @Override
    protected void updateStartTagRuleState(StartTag startTag, ExtractionRuleState.ExtractionRule rule) {
        if (rule.ruleType == TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT) {
            if (!this.getRuleState().isInlineExcludedState() || startTag.getAttributeValue("translate") != null && startTag.getAttributeValue("translate").equalsIgnoreCase("yes")) {
                ExtractionRuleState.ExtractionRule inlineIncludedRule = new ExtractionRuleState.ExtractionRule(startTag.getName(), TaggedFilterConfiguration.RULE_TYPE.INLINE_INCLUDED_ELEMENT, true);
                this.getRuleState().pushInlineExcludedIncludedRule(inlineIncludedRule);
            } else {
                ExtractionRuleState.ExtractionRule inlineExcludedRule = new ExtractionRuleState.ExtractionRule(startTag.getName(), TaggedFilterConfiguration.RULE_TYPE.INLINE_EXCLUDED_ELEMENT, true);
                this.getRuleState().pushInlineExcludedIncludedRule(inlineExcludedRule);
            }
        }
        super.updateStartTagRuleState(startTag, rule);
    }

    @Override
    public ExtractionRuleState.ExtractionRule getRuleTypeFromStartTag(EndTag endTag, EnumSet<TaggedFilterConfiguration.RULE_TYPE> ruleTypes) {
        ExtractionRuleState.ExtractionRule rule = super.getRuleTypeFromStartTag(endTag, ruleTypes);
        if (!this.getConfig().isWellformed() && rule == null) {
            rule = ruleTypes.contains((Object)TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT) ? new ExtractionRuleState.ExtractionRule(endTag.toString().toLowerCase(), TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT, true) : new ExtractionRuleState.ExtractionRule(endTag.toString().toLowerCase(), TaggedFilterConfiguration.RULE_TYPE.RULE_NOT_FOUND, true);
        }
        return rule;
    }

    @Override
    protected void updateEndTagRuleState(EndTag endTag, ExtractionRuleState.ExtractionRule rule) {
        if (rule != null && rule.ruleType == TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT) {
            if (this.getRuleState().isInlineExcludedState()) {
                rule = this.getRuleState().peekExcludedIncludedInlineRule();
            } else if (this.getRuleState().peekExcludedIncludedInlineRule() != null) {
                this.getRuleState().popInlineExcludedIncludedRule();
            }
            if (this.getRuleState().peekInlineRule() != null) {
                this.getRuleState().popInlineRule();
            }
        }
        super.updateEndTagRuleState(endTag, rule);
    }

    @Override
    protected void handleEndTag(EndTag endTag) {
        ExtractionRuleState.ExtractionRule rule = this.getMainElementRule((Tag)endTag);
        if (this.getRuleState().isExcludedState()) {
            this.addToDocumentPart(endTag.toString());
            this.updateEndTagRuleState(endTag, rule);
            return;
        }
        if (this.getRuleState().isInlineExcludedState()) {
            this.updateEndTagRuleState(endTag, rule);
            this.getEventBuilder().appendCodeInlineExcludedData(endTag.toString());
            return;
        }
        switch (rule != null && rule.ruleApplies ? rule.ruleType : TaggedFilterConfiguration.RULE_TYPE.RULE_NOT_FOUND) {
            case INLINE_ELEMENT: 
            case INLINE_INCLUDED_ELEMENT: {
                this.handleInlineElement(endTag);
                break;
            }
            case GROUP_ELEMENT: {
                this.handleGroupElement(endTag);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                this.handleTextUnitElement(endTag);
                break;
            }
            default: {
                this.addToDocumentPart(endTag.toString());
            }
        }
        this.updateEndTagRuleState(endTag, rule);
    }

    private void handleTextUnitElement(EndTag endTag) {
        if (!this.isInsideTextRun()) {
            this.endTextUnit(new GenericSkeleton(endTag.toString()));
            return;
        }
        ITextUnit tempTu = this.peekTempEvent().getTextUnit();
        if (!tempTu.getSource().hasCode() && !tempTu.getSource().hasText(this.isPreserveWhitespace())) {
            this.getEventBuilder().convertTempTextUnitToDocumentPart();
            this.addToDocumentPart(endTag.toString());
        } else {
            this.endTextUnit(new GenericSkeleton(endTag.toString()));
        }
    }

    private void handleGroupElement(EndTag endTag) {
        if (this.isInsideTextRun()) {
            this.getEventBuilder().endTextUnit();
        }
        if (this.getEventBuilder().isCurrentGroup()) {
            this.endGroup(new GenericSkeleton(endTag.toString()));
        } else {
            this.addToDocumentPart(endTag.toString());
        }
    }

    private void handleInlineElement(EndTag endTag) {
        if (this.canStartNewTextUnit()) {
            this.startTextUnit();
        }
        this.addCodeToCurrentTextUnit((Tag)endTag);
    }

    @Override
    protected PropertyTextUnitPlaceholder createPropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType type, String name, String value, Tag tag, Attribute attribute) {
        String normalizeAttributeName = this.normalizeAttributeName(name, value, tag);
        if (this.isMetaCharset(name, value, tag) && value.toLowerCase().contains("charset=")) {
            int mainStartPos = attribute.getBegin() - tag.getBegin();
            int mainEndPos = attribute.getEnd() - tag.getBegin();
            int charsetValueOffset = value.toLowerCase().lastIndexOf("charset=") + "charset=".length();
            int valueStartPos = attribute.getValueSegment().getBegin() + charsetValueOffset - tag.getBegin();
            int valueEndPos = attribute.getValueSegment().getEnd() - tag.getBegin();
            String v = tag.toString().substring(valueStartPos, valueEndPos);
            return new PropertyTextUnitPlaceholder(type, normalizeAttributeName, v, mainStartPos, mainEndPos, valueStartPos, valueEndPos);
        }
        return super.createPropertyTextUnitPlaceholder(type, name, this.getEventBuilder().normalizeHtmlText(value, true, this.isPreserveWhitespace()), tag, attribute);
    }

    @Override
    protected String normalizeAttributeName(String attrName, String attrValue, Tag tag) {
        StartTag st;
        String normalizedName = attrName;
        if (this.isMetaCharset(attrName, attrValue, tag)) {
            normalizedName = "encoding";
            return normalizedName;
        }
        if (tag.getName().equalsIgnoreCase("meta") && attrName.equalsIgnoreCase("charset")) {
            normalizedName = "encoding";
            return normalizedName;
        }
        if (tag.getName().equalsIgnoreCase("meta") && attrName.equalsIgnoreCase("content") && (st = (StartTag)tag).getAttributeValue("http-equiv") != null && st.getAttributeValue("http-equiv").equalsIgnoreCase("Content-Language")) {
            normalizedName = "language";
            return normalizedName;
        }
        if (attrName.equalsIgnoreCase("lang") || attrName.equalsIgnoreCase("xml:lang")) {
            normalizedName = "language";
            return normalizedName;
        }
        return normalizedName;
    }

    private boolean isMetaCharset(String attrName, String attrValue, Tag tag) {
        StartTag st;
        return tag.getName().equalsIgnoreCase("meta") && attrName.equalsIgnoreCase("content") && (st = (StartTag)tag).getAttributeValue("http-equiv") != null && st.getAttributeValue("content") != null && st.getAttributeValue("http-equiv").equalsIgnoreCase("Content-Type") && st.getAttributeValue("content").toLowerCase().contains("charset=");
    }

    @Override
    protected TaggedFilterConfiguration getConfig() {
        return this.parameters.getTaggedConfig();
    }

    @Override
    public void setParameters(IParameters params) {
        this.parameters = (Parameters)params;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParametersFromURL(URL config) {
        this.parameters = new Parameters(config);
    }

    public void setParametersFromFile(File config) {
        this.parameters = new Parameters(config);
    }

    public void setParametersFromString(String config) {
        this.parameters = new Parameters(config);
    }

    @Override
    protected TextFragment.TagType determineTagType(Tag tag) {
        StartTag startTag;
        TextFragment.TagType codeType = tag.getTagType() == StartTagType.NORMAL || tag.getTagType() == StartTagType.UNREGISTERED ? ((startTag = (StartTag)tag).isSyntacticalEmptyElementTag() ? TextFragment.TagType.PLACEHOLDER : (startTag.isEndTagRequired() ? (this.getRuleState().isInlineExcludedState() ? TextFragment.TagType.PLACEHOLDER : TextFragment.TagType.OPENING) : (this.getConfig().isWellformed() ? TextFragment.TagType.OPENING : TextFragment.TagType.PLACEHOLDER))) : (tag.getTagType() == EndTagType.NORMAL || tag.getTagType() == EndTagType.UNREGISTERED ? TextFragment.TagType.CLOSING : TextFragment.TagType.PLACEHOLDER);
        return codeType;
    }
}

