/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.stream.events.Attribute;
import net.sf.okapi.common.resource.CodeTypeBuilder;
import net.sf.okapi.common.resource.ExtendedCodeType;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.SpecialCharacter;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleRange;
import net.sf.okapi.filters.idml.StyleRanges;

class CodeTypes {
    private static final String SKEW_ATTRIBUTE_NAME = "Skew";
    private static final String STRIKE_THROUGH_ATTRIBUTE_NAME = "StrikeThru";
    private static final String UNDERLINE_ATTRIBUTE_NAME = "Underline";
    private static final String FONT_STYLE_ATTRIBUTE_NAME = "FontStyle";
    private static final String POSITION_ATTRIBUTE_NAME = "Position";
    private static final String FONT_STYLE_BOLD_VALUE = "Bold";
    private static final String POSITION_SUPERSCRIPT_VALUE = "Superscript";
    private static final String POSITION_SUBSCRIPT_VALUE = "Subscript";
    private static final String EMPTY_VALUE = "";
    private static final boolean ADD_EXTENDED_CODE_TYPE_PREFIX = true;

    CodeTypes() {
    }

    static String createCodeType(MarkupRange markupRange) {
        return CodeTypes.createCodeType(markupRange, true);
    }

    private static String createCodeType(MarkupRange markupRange, boolean addExtendedCodeTypePrefix) {
        CodeTypeBuilder codeTypeBuilder = new CodeTypeBuilder(addExtendedCodeTypePrefix);
        if (markupRange instanceof StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource) {
            codeTypeBuilder.addType("link");
        } else if (markupRange instanceof StoryChildElement.StyledTextReferenceElement.Table) {
            codeTypeBuilder.addType(ExtendedCodeType.TABLE_REFERENCE.getValue());
        } else if (markupRange instanceof StoryChildElement.StyledTextReferenceElement.Footnote) {
            codeTypeBuilder.addType(ExtendedCodeType.FOOTNOTE_REFERENCE.getValue());
        } else if (markupRange instanceof StoryChildElement.StyledTextReferenceElement.Note) {
            codeTypeBuilder.addType(ExtendedCodeType.NOTE_REFERENCE.getValue());
        } else if (markupRange instanceof SpecialCharacter) {
            codeTypeBuilder.addType(CodeTypes.fromSpecialCharacter((SpecialCharacter)markupRange));
        }
        return codeTypeBuilder.build();
    }

    private static String fromSpecialCharacter(SpecialCharacter specialCharacter) {
        switch (specialCharacter.type()) {
            case GENERAL: {
                return ExtendedCodeType.GENERAL.getValue();
            }
            case ALIGNMENT: {
                return ExtendedCodeType.ALIGNMENT.getValue();
            }
            case END_NESTED_STYLE: {
                return ExtendedCodeType.END_NESTED_STYLE.getValue();
            }
            case FOOTNOTE_MARKER: {
                return ExtendedCodeType.FOOTNOTE_MARKER.getValue();
            }
            case INDENT_HERE_TAB: {
                return ExtendedCodeType.INDENT_HERE_TAB.getValue();
            }
            case RIGHT_INDENT_TAB: {
                return ExtendedCodeType.RIGHT_INDENT_TAB.getValue();
            }
            case AUTO_PAGE_NUMBER: {
                return ExtendedCodeType.AUTO_PAGE_NUMBER.getValue();
            }
            case SECTION_MARKER: {
                return ExtendedCodeType.SECTION_MARKER.getValue();
            }
            case FIXED_WIDTH_NON_BREAKING_SPACE: {
                return ExtendedCodeType.FIXED_WIDTH_NON_BREAKING_SPACE.getValue();
            }
            case HAIR_SPACE: {
                return ExtendedCodeType.HAIR_SPACE.getValue();
            }
            case THIN_SPACE: {
                return ExtendedCodeType.THIN_SPACE.getValue();
            }
            case PUNCTUATION_SPACE: {
                return ExtendedCodeType.PUNCTUATION_SPACE.getValue();
            }
            case FIGURE_SPACE: {
                return ExtendedCodeType.FIGURE_SPACE.getValue();
            }
            case SIXTH_SPACE: {
                return ExtendedCodeType.SIXTH_SPACE.getValue();
            }
            case QUARTER_SPACE: {
                return ExtendedCodeType.QUARTER_SPACE.getValue();
            }
            case THIRD_SPACE: {
                return ExtendedCodeType.THIRD_SPACE.getValue();
            }
            case FLUSH_SPACE: {
                return ExtendedCodeType.FLUSH_SPACE.getValue();
            }
            case FORCED_LINE_BREAK: {
                return ExtendedCodeType.FORCED_LINE_BREAK.getValue();
            }
            case DISCRETIONARY_LINE_BRAKE: {
                return ExtendedCodeType.DISCRETIONARY_LINE_BRAKE.getValue();
            }
            case ZERO_WIDTH_NON_JOINER: {
                return ExtendedCodeType.ZERO_WIDTH_NON_JOINER.getValue();
            }
            case DISCRETIONARY_HYPHEN: {
                return ExtendedCodeType.DISCRETIONARY_HYPHEN.getValue();
            }
            case NON_BREAKING_HYPHEN: {
                return ExtendedCodeType.NON_BREAKING_HYPHEN.getValue();
            }
            case ZERO_WIDTH_NO_BREAK_SPACE: {
                return ExtendedCodeType.ZERO_WIDTH_NO_BREAK_SPACE.getValue();
            }
        }
        return EMPTY_VALUE;
    }

    static String createCodeType(StyleRanges styleRanges) {
        return CodeTypes.createCodeType(styleRanges, true);
    }

    private static String createCodeType(StyleRanges styleRanges, boolean addExtendedCodeTypePrefix) {
        CodeTypeBuilder codeTypeBuilder = new CodeTypeBuilder(addExtendedCodeTypePrefix);
        StyleRange combinedStyleRange = styleRanges.combinedStyleRange();
        block8: for (Attribute attribute : combinedStyleRange.attributes()) {
            if (SKEW_ATTRIBUTE_NAME.equals(attribute.getName().getLocalPart())) {
                codeTypeBuilder.addType("italic");
                continue;
            }
            if (STRIKE_THROUGH_ATTRIBUTE_NAME.equals(attribute.getName().getLocalPart())) {
                codeTypeBuilder.addType(ExtendedCodeType.STRIKE_THROUGH.getValue());
                continue;
            }
            if (UNDERLINE_ATTRIBUTE_NAME.equals(attribute.getName().getLocalPart())) {
                codeTypeBuilder.addType(ExtendedCodeType.UNDERLINE.getValue());
                continue;
            }
            if (FONT_STYLE_ATTRIBUTE_NAME.equals(attribute.getName().getLocalPart()) && FONT_STYLE_BOLD_VALUE.equals(attribute.getValue())) {
                codeTypeBuilder.addType("bold");
                continue;
            }
            if (!POSITION_ATTRIBUTE_NAME.equals(attribute.getName().getLocalPart())) continue;
            switch (attribute.getValue()) {
                case "Superscript": {
                    codeTypeBuilder.addType(ExtendedCodeType.SUPERSCRIPT.getValue());
                    continue block8;
                }
                case "Subscript": {
                    codeTypeBuilder.addType(ExtendedCodeType.SUBSCRIPT.getValue());
                    continue block8;
                }
            }
        }
        return codeTypeBuilder.build();
    }
}

