/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.XMLEventsReader;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.ElementParser;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.MarkupSkeleton;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.SubDocument;
import net.sf.okapi.filters.idml.TextAttributeMapping;
import net.sf.okapi.filters.idml.TextElementMapping;

final class DesignMapSubDocument
implements SubDocument {
    private static final String TEXT_XML = "text/xml";
    private static final String CUSTOM_TEXT_VARIABLE_PREFERENCE = "CustomTextVariablePreference";
    private static final String PROPERTIES = "Properties";
    private static final String CONTENTS = "Contents";
    private static final String INDEX = "Index";
    private static final String TOPIC = "Topic";
    private static final String HYPERLINK_URL_DESTINATION = "HyperlinkURLDestination";
    private static final QName NAME = new QName("Name");
    private static final QName DESTINATION_URL = new QName("DestinationURL");
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final ZipFile zipFile;
    private final ZipEntry zipEntry;
    private final String parentId;
    private final String id;
    private final List<XMLEvent> events;
    private final List<Event> filterEvents;
    private IdGenerator documentPartIds;
    private IdGenerator textUnitIds;
    private List<XMLEvent> documentPartEvents;
    private Iterator<Event> filterEventsIterator;

    DesignMapSubDocument(Parameters parameters, XMLEventFactory eventFactory, ZipFile zipFile, ZipEntry zipEntry, String parentId, String id, List<XMLEvent> events) {
        this(parameters, eventFactory, zipFile, zipEntry, parentId, id, events, new LinkedList<Event>());
    }

    DesignMapSubDocument(Parameters parameters, XMLEventFactory eventFactory, ZipFile zipFile, ZipEntry zipEntry, String parentId, String id, List<XMLEvent> events, List<Event> filterEvents) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
        this.parentId = parentId;
        this.id = id;
        this.events = events;
        this.filterEvents = filterEvents;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.documentPartIds = new IdGenerator(this.zipEntry.getName(), "dp");
        this.textUnitIds = new IdGenerator(this.zipEntry.getName(), "tu");
        this.documentPartEvents = new LinkedList<XMLEvent>();
        this.readFilterEventsWith(new XMLEventsReader(this.events));
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.id)));
        this.filterEventsIterator = this.filterEvents.iterator();
        return this.startSubDocumentEvent();
    }

    private void readFilterEventsWith(XMLEventsReader reader) throws XMLStreamException {
        TextElementMapping tem = new TextElementMapping(this.parameters, this.eventFactory, this.textUnitIds);
        TextAttributeMapping tam = new TextAttributeMapping(this.textUnitIds);
        boolean inCustomTextVariablePreference = false;
        boolean inProperties = false;
        boolean inIndex = false;
        while (reader.hasNext()) {
            XMLEvent e = reader.nextEvent();
            if (e.isStartElement()) {
                if (this.parameters.getExtractCustomTextVariables() && inCustomTextVariablePreference && inProperties && CONTENTS.equals(e.asStartElement().getName().getLocalPart())) {
                    this.flushDocumentPart();
                    Element contents = new ElementParser(e.asStartElement(), reader, this.eventFactory).parse(new Element.Builder());
                    this.filterEvents.add(new Event(EventType.TEXT_UNIT, tem.textUnitFor(contents)));
                    continue;
                }
                if (this.parameters.getExtractIndexTopics() && inIndex && TOPIC.equals(e.asStartElement().getName().getLocalPart())) {
                    this.flushDocumentPart();
                    Element topic = new ElementParser(e.asStartElement(), reader, this.eventFactory).parse(new Element.Builder());
                    this.filterEvents.add(new Event(EventType.TEXT_UNIT, tam.textUnitFor(topic, NAME)));
                    continue;
                }
                if (this.parameters.getExtractExternalHyperlinks() && HYPERLINK_URL_DESTINATION.equals(e.asStartElement().getName().getLocalPart())) {
                    this.flushDocumentPart();
                    Element hyperlinkUrlDestination = new ElementParser(e.asStartElement(), reader, this.eventFactory).parse(new Element.Builder());
                    this.filterEvents.add(new Event(EventType.TEXT_UNIT, tam.textUnitFor(hyperlinkUrlDestination, DESTINATION_URL)));
                    continue;
                }
                if (CUSTOM_TEXT_VARIABLE_PREFERENCE.equals(e.asStartElement().getName().getLocalPart())) {
                    inCustomTextVariablePreference = true;
                }
                if (PROPERTIES.equals(e.asStartElement().getName().getLocalPart())) {
                    inProperties = true;
                }
                if (INDEX.equals(e.asStartElement().getName().getLocalPart())) {
                    inIndex = true;
                }
            } else if (e.isEndElement()) {
                if (PROPERTIES.equals(e.asEndElement().getName().getLocalPart())) {
                    inProperties = false;
                }
                if (CUSTOM_TEXT_VARIABLE_PREFERENCE.equals(e.asEndElement().getName().getLocalPart())) {
                    inCustomTextVariablePreference = false;
                }
                if (INDEX.equals(e.asEndElement().getName().getLocalPart())) {
                    inIndex = false;
                }
            }
            this.documentPartEvents.add(e);
        }
        this.flushDocumentPart();
    }

    void flushDocumentPart() {
        this.filterEvents.add(new Event(EventType.DOCUMENT_PART, new DocumentPart(this.documentPartIds.createId(), false, new MarkupSkeleton(new Markup.Default(Collections.singletonList(new MarkupRange.Default(this.documentPartEvents)))))));
        this.documentPartEvents = new LinkedList<XMLEvent>();
    }

    private Event startSubDocumentEvent() {
        StartSubDocument sd = new StartSubDocument(this.parentId, this.id);
        sd.setName(this.zipEntry.getName());
        sd.setMimeType(TEXT_XML);
        ZipSkeleton zs = new ZipSkeleton(this.zipFile, this.zipEntry);
        sd.setSkeleton(zs);
        sd.setFilterId("okf_idml");
        sd.setFilterParameters(this.parameters);
        return new Event(EventType.START_SUBDOCUMENT, sd);
    }

    @Override
    public boolean hasNextEvent() {
        return this.filterEventsIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.filterEventsIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

