/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.ElementParser;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.PropertiesParser;

interface StyleDefinition
extends MarkupRange {
    public void from(XMLEventReader var1) throws XMLStreamException;

    public static interface Group
    extends StyleDefinition {
        public Iterator<Style> styles();

        public Iterator<Group> styleGroups();

        public static class Default
        implements Group {
            private final StartElement startElement;
            private final String styleName;
            private final String styleGroupName;
            private final List<Style> styles;
            private final List<Group> styleGroups;
            private final XMLEventFactory eventFactory;
            private Properties properties;
            private EndElement endElement;

            Default(StartElement startElement, String styleName, String styleGroupName, List<Style> styles, List<Group> styleGroups, XMLEventFactory eventFactory) {
                this.startElement = startElement;
                this.properties = new Properties.Empty(eventFactory);
                this.styleName = styleName;
                this.styleGroupName = styleGroupName;
                this.styles = styles;
                this.styleGroups = styleGroups;
                this.eventFactory = eventFactory;
            }

            @Override
            public Iterator<Style> styles() {
                return this.styles.iterator();
            }

            @Override
            public Iterator<Group> styleGroups() {
                return this.styleGroups.iterator();
            }

            @Override
            public void from(XMLEventReader eventReader) throws XMLStreamException {
                while (eventReader.hasNext()) {
                    XMLEvent event = eventReader.nextEvent();
                    if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                        this.endElement = event.asEndElement();
                        return;
                    }
                    if (event.isStartElement() && Properties.NAME.equals(event.asStartElement().getName())) {
                        this.properties = new PropertiesParser(event.asStartElement(), eventReader, this.eventFactory).parse();
                        continue;
                    }
                    if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(this.styleName)) {
                        Style.Default style = new Style.Default(event.asStartElement(), new LinkedList<Element>(), this.eventFactory);
                        style.from(eventReader);
                        this.styles.add(style);
                        continue;
                    }
                    if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals(this.styleGroupName)) continue;
                    Default group = new Default(event.asStartElement(), this.styleName, this.styleGroupName, new LinkedList<Style>(), new LinkedList<Group>(), this.eventFactory);
                    group.from(eventReader);
                    this.styleGroups.add(group);
                }
            }

            @Override
            public void apply(FontMappings fontMappings) {
                this.properties.apply(fontMappings);
                this.styles.forEach(s -> s.apply(fontMappings));
                this.styleGroups.forEach(sg -> sg.apply(fontMappings));
            }

            @Override
            public List<XMLEvent> getEvents() {
                LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
                events.add(this.startElement);
                events.addAll(this.properties.getEvents());
                this.styles.forEach(s -> events.addAll(s.getEvents()));
                this.styleGroups.forEach(sg -> events.addAll(sg.getEvents()));
                events.add(this.endElement);
                return events;
            }
        }
    }

    public static interface Style
    extends StyleDefinition {
        public Iterator<Element> innerElements();

        public static class Default
        implements Style {
            private final StartElement startElement;
            private final List<Element> innerElements;
            private final XMLEventFactory eventFactory;
            private Properties properties;
            private EndElement endElement;

            Default(StartElement startElement, List<Element> innerElements, XMLEventFactory eventFactory) {
                this.startElement = startElement;
                this.properties = new Properties.Empty(eventFactory);
                this.innerElements = innerElements;
                this.eventFactory = eventFactory;
            }

            @Override
            public Iterator<Element> innerElements() {
                return this.innerElements.iterator();
            }

            @Override
            public void from(XMLEventReader eventReader) throws XMLStreamException {
                while (eventReader.hasNext()) {
                    XMLEvent event = eventReader.nextEvent();
                    if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                        this.endElement = event.asEndElement();
                        return;
                    }
                    if (event.isStartElement() && Properties.NAME.equals(event.asStartElement().getName())) {
                        this.properties = new PropertiesParser(event.asStartElement(), eventReader, this.eventFactory).parse();
                        continue;
                    }
                    if (!event.isStartElement()) continue;
                    this.innerElements.add(new ElementParser(event.asStartElement(), eventReader, this.eventFactory).parse(new Element.Builder()));
                }
            }

            @Override
            public void apply(FontMappings fontMappings) {
                this.properties.apply(fontMappings);
                this.innerElements.forEach(e -> e.apply(fontMappings));
            }

            @Override
            public List<XMLEvent> getEvents() {
                ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
                events.add(this.startElement);
                events.addAll(this.properties.getEvents());
                this.innerElements.forEach(e -> events.addAll(e.getEvents()));
                events.add(this.endElement);
                return events;
            }
        }
    }
}

