/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.Property;

class StyleRange {
    static final QName APPLIED_PARAGRAPH_STYLE = Namespaces.getDefaultNamespace().getQName("AppliedParagraphStyle");
    static final String PARAGRAPH_STYLE_DEFAULT_VALUE = "ParagraphStyle/$ID/NormalParagraphStyle";
    static final QName APPLIED_CHARACTER_STYLE = Namespaces.getDefaultNamespace().getQName("AppliedCharacterStyle");
    static final String CHARACTER_STYLE_DEFAULT_VALUE = "CharacterStyle/$ID/[No character style]";
    static final String STYLE_NONE_VALUE = "n";
    static final QName PARAGRAPH_STYLE_RANGE = Namespaces.getDefaultNamespace().getQName("ParagraphStyleRange");
    static final QName CHARACTER_STYLE_RANGE = Namespaces.getDefaultNamespace().getQName("CharacterStyleRange");
    private final XMLEventFactory eventFactory;
    private final QName name;
    private final List<Attribute> attributes;
    private final Properties properties;

    StyleRange(XMLEventFactory eventFactory, QName name, List<Attribute> attributes, Properties properties) {
        this.eventFactory = eventFactory;
        this.name = name;
        this.attributes = attributes;
        this.properties = properties;
    }

    static StyleRange defaultParagraphStyleRange(XMLEventFactory eventFactory) {
        List<Attribute> attributes = Collections.singletonList(eventFactory.createAttribute(APPLIED_PARAGRAPH_STYLE, PARAGRAPH_STYLE_DEFAULT_VALUE));
        Properties.Empty properties = new Properties.Empty(eventFactory);
        return new StyleRange(eventFactory, PARAGRAPH_STYLE_RANGE, attributes, properties);
    }

    static StyleRange defaultCharacterStyleRange(XMLEventFactory eventFactory) {
        List<Attribute> attributes = Collections.singletonList(eventFactory.createAttribute(APPLIED_CHARACTER_STYLE, CHARACTER_STYLE_DEFAULT_VALUE));
        Properties.Empty properties = new Properties.Empty(eventFactory);
        return new StyleRange(eventFactory, CHARACTER_STYLE_RANGE, attributes, properties);
    }

    XMLEventFactory eventFactory() {
        return this.eventFactory;
    }

    QName name() {
        return this.name;
    }

    List<Attribute> attributes() {
        return this.attributes;
    }

    Properties properties() {
        return this.properties;
    }

    boolean isSubsetOf(StyleRange other) {
        if (this.attributes().isEmpty() && !other.attributes().isEmpty() || this.properties().properties().isEmpty() && !other.properties().properties().isEmpty()) {
            return false;
        }
        block0: for (Attribute attribute : this.attributes()) {
            for (Attribute otherAttribute : other.attributes()) {
                if (!otherAttribute.equals(attribute)) continue;
                continue block0;
            }
            return false;
        }
        block2: for (Property property : this.properties().properties()) {
            for (Property otherProperty : other.properties().properties()) {
                if (!otherProperty.equals(property)) continue;
                continue block2;
            }
            return false;
        }
        return true;
    }

    void apply(FontMappings fontMappings) {
        this.properties.apply(fontMappings);
    }

    StyleRange mergedWith(StyleRange styleRange) {
        StyleRange sr = this.equals(styleRange) ? styleRange : new StyleRange(styleRange.eventFactory(), styleRange.name(), this.mergedAttributesWith(styleRange.attributes()), this.properties.mergedWith(styleRange.properties()));
        return sr;
    }

    private List<Attribute> mergedAttributesWith(List<Attribute> attributes) {
        if (this.areAttributesEqual(this.attributes, attributes)) {
            return attributes;
        }
        Set intersection = this.attributes.stream().filter(a -> attributes.contains(a)).collect(Collectors.toSet());
        Set theseAttributes = this.attributes.stream().filter(a -> !intersection.contains(a)).collect(Collectors.toSet());
        Set otherAttributes = attributes.stream().filter(a -> !intersection.contains(a)).collect(Collectors.toSet());
        ArrayList<Attribute> merged = new ArrayList<Attribute>(intersection);
        Iterator theseAttributesIterator = theseAttributes.iterator();
        block0: while (theseAttributesIterator.hasNext()) {
            Attribute ta = (Attribute)theseAttributesIterator.next();
            Iterator otherAttributesIterator = otherAttributes.iterator();
            while (otherAttributesIterator.hasNext()) {
                Attribute oa = (Attribute)otherAttributesIterator.next();
                if (!ta.getName().equals(oa.getName())) continue;
                merged.add(oa);
                theseAttributesIterator.remove();
                otherAttributesIterator.remove();
                continue block0;
            }
        }
        merged.addAll(theseAttributes);
        merged.addAll(otherAttributes);
        merged.sort(new AttributesComparator());
        return merged;
    }

    List<XMLEvent> asStyleRangeStart() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.eventFactory.createStartElement(this.name, this.attributes.iterator(), null));
        events.addAll(this.properties.getEvents());
        return events;
    }

    List<XMLEvent> asStyleRangeEnd() {
        return Collections.singletonList(this.eventFactory.createEndElement(this.name, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        StyleRange that = (StyleRange)o;
        return this.areAttributesEqual(this.attributes(), that.attributes()) && Objects.equals(this.properties(), that.properties());
    }

    private boolean areAttributesEqual(List<Attribute> thisAttributes, List<Attribute> thatAttributes) {
        if (thisAttributes == thatAttributes) {
            return true;
        }
        if (null == thisAttributes || null == thatAttributes) {
            return false;
        }
        if (thisAttributes.size() != thatAttributes.size()) {
            return false;
        }
        Iterator<Attribute> thisAttributesIterator = thisAttributes.iterator();
        Iterator<Attribute> thatAttributesIterator = thatAttributes.iterator();
        while (thisAttributesIterator.hasNext() && thatAttributesIterator.hasNext()) {
            Attribute thisAttribute = thisAttributesIterator.next();
            Attribute thatAttribute = thatAttributesIterator.next();
            if (thisAttribute.getName().equals(thatAttribute.getName()) && thisAttribute.getValue().equals(thatAttribute.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.attributes(), this.properties());
    }

    static class StyleRangeBuilder
    implements Builder<StyleRange> {
        private final XMLEventFactory eventFactory;
        private final AttributesComparator attributesComparator;
        private QName name;
        private List<Attribute> attributes;
        private Properties properties;

        StyleRangeBuilder(XMLEventFactory eventFactory, AttributesComparator attributesComparator) {
            this.eventFactory = eventFactory;
            this.attributesComparator = attributesComparator;
        }

        StyleRangeBuilder setName(QName name) {
            this.name = name;
            return this;
        }

        StyleRangeBuilder setAttributes(List<Attribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        StyleRangeBuilder setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public StyleRange build() {
            this.attributes.sort(this.attributesComparator);
            return new StyleRange(this.eventFactory, this.name, this.attributes, this.properties);
        }
    }

    static class AttributesComparator
    implements Comparator<Attribute> {
        AttributesComparator() {
        }

        @Override
        public int compare(Attribute a1, Attribute a2) {
            return a1.getName().getLocalPart().compareTo(a2.getName().getLocalPart());
        }
    }
}

