/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.PropertiesParser;
import net.sf.okapi.filters.idml.StyleRange;

class StyleRangeParser {
    private final StartElement startElement;
    private final XMLEventReader eventReader;
    private final XMLEventFactory eventFactory;

    StyleRangeParser(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory) {
        this.startElement = startElement;
        this.eventReader = eventReader;
        this.eventFactory = eventFactory;
    }

    StyleRange parse() throws XMLStreamException {
        StyleRange.StyleRangeBuilder styleRangeBuilder = new StyleRange.StyleRangeBuilder(this.eventFactory, new StyleRange.AttributesComparator());
        styleRangeBuilder.setName(this.startElement.getName());
        styleRangeBuilder.setAttributes(ParsingIdioms.getStartElementAttributes(this.startElement));
        XMLEvent nextEvent = this.eventReader.peek();
        if (nextEvent.isEndElement()) {
            if (!nextEvent.asEndElement().getName().equals(this.startElement.getName())) {
                throw new IllegalStateException("Unexpected structure");
            }
            styleRangeBuilder.setProperties(new Properties.Empty(this.eventFactory));
            return styleRangeBuilder.build();
        }
        XMLEvent nextTag = this.peekNextTagInStyleRange();
        if (nextTag.isEndElement() || nextTag.isStartElement() && !Properties.NAME.equals(nextTag.asStartElement().getName())) {
            styleRangeBuilder.setProperties(new Properties.Empty(this.eventFactory));
            return styleRangeBuilder.build();
        }
        styleRangeBuilder.setProperties(new PropertiesParser(this.eventReader.nextTag().asStartElement(), this.eventReader, this.eventFactory).parse());
        return styleRangeBuilder.build();
    }

    private XMLEvent peekNextTagInStyleRange() throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.peek();
            if (event.isStartElement() || event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                return event;
            }
            this.eventReader.nextEvent();
        }
        throw new IllegalStateException("Unexpected structure");
    }
}

