/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class MarkdownFilterWriter
extends GenericFilterWriter {
    public MarkdownFilterWriter() {
    }

    public MarkdownFilterWriter(ISkeletonWriter skelWriter, EncoderManager encoderManager) {
        super(skelWriter, encoderManager);
    }

    @Override
    protected void processStartDocument(LocaleId outputLocale, String outputEncoding, StartDocument resource) throws IOException {
        super.processStartDocument(outputLocale, outputEncoding, resource);
        this.writer.flush();
        this.writer = new LineTrimingWriter(this.writer);
    }

    private static class LineTrimingWriter
    extends OutputStreamWriter {
        OutputStreamWriter baseWriter;
        StringBuilder sb = new StringBuilder();
        private final int lastChar = -1;
        private boolean isCarriageReturn = false;

        public LineTrimingWriter(OutputStreamWriter baseWriter) throws UnsupportedEncodingException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, baseWriter.getEncoding());
            this.baseWriter = baseWriter;
        }

        private boolean isNewlineCharacter(int c) {
            return c == 10 || c == 13;
        }

        @Override
        public void write(int c) throws IOException {
            if (this.isNewlineCharacter(c)) {
                this.trimNonEssentialTrailingSpaces();
                if (c == 13) {
                    if (!this.isCarriageReturn) {
                        this.baseWriter.write(this.sb.toString());
                        this.sb.setLength(0);
                        this.isCarriageReturn = true;
                    } else {
                        this.sb.append((char)c);
                        this.isCarriageReturn = false;
                    }
                } else if (c == 10) {
                    if (!this.isCarriageReturn) {
                        this.baseWriter.write(this.sb.toString());
                        this.sb.setLength(0);
                    }
                    this.isCarriageReturn = false;
                    this.sb.append((char)c);
                }
            } else {
                if (this.isCarriageReturn) {
                    this.baseWriter.write(13);
                    this.isCarriageReturn = false;
                }
                this.sb.append((char)c);
            }
        }

        private void trimNonEssentialTrailingSpaces() {
            if (this.sb.length() == 0) {
                return;
            }
            int i = this.sb.length() - 1;
            while (this.sb.charAt(i) == ' ') {
                if (--i != -1) continue;
                this.sb.setLength(0);
                return;
            }
            if (i == this.sb.length() - 2) {
                this.sb.setLength(this.sb.length() - 1);
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int i = off;
            while (len-- > 0) {
                this.write(cbuf[i++]);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), 0, str.length());
        }

        @Override
        public void flush() throws IOException {
            if (this.sb.length() > 0) {
                this.trimNonEssentialTrailingSpaces();
                this.baseWriter.write(this.sb.toString());
            }
            this.baseWriter.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.baseWriter.close();
            super.close();
        }
    }
}

