/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown;

import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Parameters
extends StringParameters {
    private static final String HTML_SUBFILTER_CONFIG_PATH = "htmlSubfilter";
    private static final String YAML_SUBFILTER_CONFIG_PATH = "yamlSubfilter";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String TRANSLATE_URLS = "translateUrls";
    private static final String TRANSLATE_FENCED_CODE_BLOCKS = "translateCodeBlocks";
    private static final String TRANSLATE_INDENTED_CODE_BLOCKS = "translateIndentedCodeBlocks";
    private static final String TRANSLATE_INLINE_CODE_BLOCKS = "translateInlineCodeBlocks";
    private static final String TRANSLATE_HEADER_METADATA = "translateHeaderMetadata";
    private static final String TRANSLATE_IMAGE_ALTTEXT = "translateImageAltText";
    private static final String URL_TO_TRANSLATE_PATTERN = "urlToTranslatePattern";
    private static final String HTML_ENTITIES_TO_ESCAPE = "htmlEntitiesToEscape";
    private static final String NON_TRANSLATE_BLOCKS = "nonTranslateBlocks";
    private static final String UNESCAPE_BACKSLASH_CHARACTERS = "unescapeBackslashCharacters";
    private static final String CHARACTERS_TO_ESCAPE = "charactersToEscape";
    private static final String GENERATE_HEADER_ANCHORS = "generateHeaderAnchors";
    private static final String PARSE_MDX = "parseMdx";
    private InlineCodeFinder codeFinder;

    public Parameters() {
        this.reset();
    }

    public String getHtmlSubfilter() {
        return this.getString(HTML_SUBFILTER_CONFIG_PATH);
    }

    public void setHtmlSubfilter(String htmlSubfilter) {
        this.setString(HTML_SUBFILTER_CONFIG_PATH, htmlSubfilter);
    }

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public boolean getTranslateUrls() {
        return this.getBoolean(TRANSLATE_URLS);
    }

    public void setTranslateUrls(boolean translateUrls) {
        this.setBoolean(TRANSLATE_URLS, translateUrls);
    }

    public String getUrlToTranslatePattern() {
        return this.getString(URL_TO_TRANSLATE_PATTERN);
    }

    public void setUrlToTranslatePattern(String urlToTranslatePattern) {
        this.setString(URL_TO_TRANSLATE_PATTERN, urlToTranslatePattern);
    }

    public boolean getTranslateFencedCodeBlocks() {
        return this.getBoolean(TRANSLATE_FENCED_CODE_BLOCKS);
    }

    public void setTranslateFencedCodeBlocks(boolean translateCodeBlocks) {
        this.setBoolean(TRANSLATE_FENCED_CODE_BLOCKS, translateCodeBlocks);
    }

    public boolean getTranslateIndentedCodeBlocks() {
        return this.getBoolean(TRANSLATE_INDENTED_CODE_BLOCKS);
    }

    public void setTranslateIndentedCodeBlocks(boolean translateIndentedCodeBlocks) {
        this.setBoolean(TRANSLATE_INDENTED_CODE_BLOCKS, translateIndentedCodeBlocks);
    }

    public boolean getTranslateInlineCodeBlocks() {
        return this.getBoolean(TRANSLATE_INLINE_CODE_BLOCKS);
    }

    public void setTranslateInlineCodeBlocks(boolean translateInlineCodeBlocks) {
        this.setBoolean(TRANSLATE_INLINE_CODE_BLOCKS, translateInlineCodeBlocks);
    }

    public boolean getTranslateHeaderMetadata() {
        return this.getBoolean(TRANSLATE_HEADER_METADATA);
    }

    public void setTranslateHeaderMetadata(boolean translateHeaderMetadata) {
        this.setBoolean(TRANSLATE_HEADER_METADATA, translateHeaderMetadata);
    }

    public boolean getTranslateImageAltText() {
        return this.getBoolean(TRANSLATE_IMAGE_ALTTEXT);
    }

    public void setTranslateImageAltText(boolean translateImageAltText) {
        this.setBoolean(TRANSLATE_IMAGE_ALTTEXT, translateImageAltText);
    }

    public String getHtmlEntitiesToEscape() {
        return this.getString(HTML_ENTITIES_TO_ESCAPE);
    }

    public void setHtmlEntitiesToEscape(String htmlEntitiesToEscape) {
        this.setString(HTML_ENTITIES_TO_ESCAPE, htmlEntitiesToEscape);
    }

    public boolean getUnescapeBackslashCharacters() {
        return this.getBoolean(UNESCAPE_BACKSLASH_CHARACTERS);
    }

    public void setUnescapeBackslashCharacters(boolean unescapeBackslashCharacters) {
        this.setBoolean(UNESCAPE_BACKSLASH_CHARACTERS, unescapeBackslashCharacters);
    }

    public String getCharactersToEscape() {
        return this.getString(CHARACTERS_TO_ESCAPE);
    }

    public void setCharactersToEscape(String charactersToEscape) {
        this.setString(CHARACTERS_TO_ESCAPE, charactersToEscape);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getNonTranslateBlocks() {
        return this.getString(NON_TRANSLATE_BLOCKS);
    }

    public void setNonTranslateBlocks(String nonTranslatableBlocks) {
        this.setString(NON_TRANSLATE_BLOCKS, nonTranslatableBlocks);
    }

    public String getYamlSubfilter() {
        return this.getString(YAML_SUBFILTER_CONFIG_PATH);
    }

    public void setYamlSubfilter(String yamlSubfilter) {
        this.setString(YAML_SUBFILTER_CONFIG_PATH, yamlSubfilter);
    }

    public boolean getGenerateHeaderAnchors() {
        return this.getBoolean(GENERATE_HEADER_ANCHORS);
    }

    public void setGenerateHeaderAnchors(boolean generateHeaderAnchors) {
        this.setBoolean(GENERATE_HEADER_ANCHORS, generateHeaderAnchors);
    }

    public boolean getParseMdx() {
        return this.getBoolean(PARSE_MDX);
    }

    public void setParseMdx(boolean parseMdx) {
        this.setBoolean(PARSE_MDX, parseMdx);
    }

    @Override
    public void reset() {
        super.reset();
        this.setHtmlSubfilter(null);
        this.setUseCodeFinder(false);
        this.setTranslateUrls(false);
        this.setUrlToTranslatePattern(".+");
        this.setTranslateFencedCodeBlocks(true);
        this.setTranslateIndentedCodeBlocks(true);
        this.setTranslateInlineCodeBlocks(true);
        this.setTranslateHeaderMetadata(false);
        this.setTranslateImageAltText(true);
        this.setHtmlEntitiesToEscape("");
        this.setUnescapeBackslashCharacters(false);
        this.setCharactersToEscape("*_`{}[]<>()#+\\-.!|");
        this.setYamlSubfilter(null);
        this.setGenerateHeaderAnchors(false);
        this.setParseMdx(false);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("{{#test}} handle bar test {{/test}}\n{{stand-alone handle bar}}\n");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("\\{\\{[^}]+\\}\\}");
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

