/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.ListIterator;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockPropertiesFactory;
import net.sf.okapi.filters.openxml.ClarificationContext;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentClarification;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.StyleDefinitions;

interface BlockPropertiesClarification {
    public void performWith(ListIterator<MarkupComponent> var1);

    public static final class Paragraph
    implements BlockPropertiesClarification {
        private final Default defaultBlockPropertiesClarification;

        Paragraph(Default defaultBlockPropertiesClarification) {
            this.defaultBlockPropertiesClarification = defaultBlockPropertiesClarification;
        }

        @Override
        public void performWith(ListIterator<MarkupComponent> markupComponentIterator) {
            MarkupComponent markupComponent = markupComponentIterator.previous();
            if (markupComponent instanceof MarkupComponent.StyledStart) {
                this.defaultBlockPropertiesClarification.clarificationContext.adjust(((MarkupComponent.StyledStart)markupComponent).styleDefinitions());
            } else {
                this.defaultBlockPropertiesClarification.clarificationContext.adjust(new StyleDefinitions.Empty());
            }
            markupComponentIterator.next();
            this.defaultBlockPropertiesClarification.performWith(markupComponentIterator);
        }
    }

    public static final class Default
    implements BlockPropertiesClarification {
        private final ClarificationContext clarificationContext;
        private final String blockPropertiesName;
        private final MarkupComponentClarification markupComponentClarification;

        Default(ClarificationContext clarificationContext, String blockPropertiesName, MarkupComponentClarification markupComponentClarification) {
            this.clarificationContext = clarificationContext;
            this.blockPropertiesName = blockPropertiesName;
            this.markupComponentClarification = markupComponentClarification;
        }

        @Override
        public void performWith(ListIterator<MarkupComponent> markupComponentIterator) {
            MarkupComponent markupComponent;
            if (!markupComponentIterator.hasNext()) {
                markupComponent = this.blockProperties();
                markupComponentIterator.add(markupComponent);
            } else {
                markupComponent = markupComponentIterator.next();
                if (markupComponent instanceof MarkupComponent.General && ((MarkupComponent.General)markupComponent).eventsAreWhitespaces()) {
                    if (!markupComponentIterator.hasNext()) {
                        markupComponent = this.blockProperties();
                        markupComponentIterator.add(markupComponent);
                    } else {
                        markupComponent = markupComponentIterator.next();
                    }
                }
                if (!(markupComponent instanceof BlockProperties) || !this.blockPropertiesName.equals(markupComponent.getName().getLocalPart())) {
                    markupComponentIterator.previous();
                    markupComponent = this.blockProperties();
                    markupComponentIterator.add(markupComponent);
                }
            }
            if (markupComponent instanceof ParagraphBlockProperties) {
                this.clarificationContext.adjustCombinedParagraphPropertiesAndParagraphStyleFor((ParagraphBlockProperties)markupComponent);
            }
            this.markupComponentClarification.performFor(markupComponent);
        }

        private BlockProperties blockProperties() {
            return BlockPropertiesFactory.createBlockProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters(), this.clarificationContext.presetColorValues(), this.clarificationContext.highlightColorValues(), this.clarificationContext.systemColorValues(), this.clarificationContext.indexedColors(), this.clarificationContext.theme(), this.blockPropertiesName, new ArrayList<Attribute>(), new ArrayList<Property>());
        }
    }
}

