/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.CodeTypeFactory;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunCode;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunPropertiesPairWithDetectedRunFonts;
import net.sf.okapi.filters.openxml.TextUnitMapper;
import net.sf.okapi.filters.openxml.TextUnitProperties;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.TranslatableAttributeText;
import net.sf.okapi.filters.openxml.XMLEvents;

class BlockTextUnitMapper
extends TextUnitMapper {
    private static final String NESTED_ID_GENERATOR_PREFIX = "sub";
    private final Block block;

    BlockTextUnitMapper(IdGenerator idGenerator, XMLEventFactory eventFactory, Block block) {
        super(idGenerator, eventFactory);
        this.block = block;
    }

    @Override
    public List<ITextUnit> map() {
        if (this.block.getChunks().size() <= 2) {
            for (XMLEvents xMLEvents : this.block.getChunks()) {
                if (!(xMLEvents instanceof Run)) continue;
                throw new IllegalStateException("Unexpected structure");
            }
            return Collections.emptyList();
        }
        TextUnit textUnit = new TextUnit(this.idGenerator.createId());
        textUnit.setPreserveWhitespaces(true);
        TextFragment textFragment = new TextFragment();
        textUnit.setSource(new TextContainer(textFragment));
        List<Chunk> chunks = this.block.getChunks().subList(1, this.block.getChunks().size() - 1);
        this.baseRunPropertiesPairWithDetectedRunFonts(chunks, this.block.name());
        boolean runHasText = false;
        for (Chunk chunk : chunks) {
            if (chunk instanceof Run) {
                runHasText |= this.processRun(textUnit, (Run)chunk);
                continue;
            }
            if (chunk instanceof RunContainer) {
                RunContainer rc = (RunContainer)chunk;
                if (rc.getChunks().isEmpty()) {
                    this.addIsolatedCode(textFragment, chunk);
                    continue;
                }
                Code openCode = this.addOpeningCode(textFragment, rc);
                int savedFormattingCodeDepth = this.runCodeStack.size();
                for (int nestedRunPosition = 0; nestedRunPosition < rc.getChunks().size(); ++nestedRunPosition) {
                    if (rc.getChunks().get(nestedRunPosition) instanceof Run) {
                        runHasText |= this.processNestedRun(textFragment, rc.getChunks(), textUnit, nestedRunPosition, savedFormattingCodeDepth);
                        continue;
                    }
                    if (rc.getChunks().get(nestedRunPosition) instanceof RunContainer) {
                        RunContainer nestedRunContainer = (RunContainer)rc.getChunks().get(nestedRunPosition);
                        runHasText |= this.processNestedRunContainer(textFragment, nestedRunContainer, textUnit);
                        continue;
                    }
                    throw new OkapiException("Wrong type of node");
                }
                this.popRunCodesToDepth(textFragment, savedFormattingCodeDepth);
                this.addClosingCode(textFragment, rc, openCode);
                continue;
            }
            this.addIsolatedCode(textFragment, chunk);
        }
        this.popAllRunCodes(textFragment);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>(this.referentTus.size() + 1);
        if (runHasText || !this.referentTus.isEmpty()) {
            BlockSkeleton skel = new BlockSkeleton(this.block, this.baseRunPropertiesPairWithDetectedRunFonts, this.hiddenCodes, this.visibleCodes);
            skel.setParent(textUnit);
            textUnit.setSkeleton(skel);
            tus.add(textUnit);
        }
        tus.addAll(this.referentTus);
        return tus;
    }

    private boolean processNestedRunContainer(TextFragment tf, RunContainer rc, ITextUnit textUnit) {
        boolean runHasText = false;
        Code openNestedCode = this.addOpeningCode(tf, rc);
        int savedFormattingNestedCodeDepth = this.runCodeStack.size();
        for (int i = 0; i < rc.getChunks().size(); ++i) {
            Chunk chunk = rc.getChunks().get(i);
            if (chunk instanceof Run) {
                runHasText |= this.processNestedRun(tf, rc.getChunks(), textUnit, i, savedFormattingNestedCodeDepth);
                continue;
            }
            if (!(chunk instanceof RunContainer)) continue;
            runHasText |= this.processNestedRunContainer(tf, (RunContainer)chunk, textUnit);
        }
        this.popRunCodesToDepth(tf, savedFormattingNestedCodeDepth);
        this.addClosingCode(tf, rc, openNestedCode);
        return runHasText;
    }

    private boolean processNestedRun(TextFragment tf, List<Chunk> chunks, ITextUnit textUnit, int runPosition, int codeStackPopsLimit) {
        List<ITextUnit> nestedTus = this.processNestedBlocks((Run)chunks.get(runPosition), textUnit.getId());
        TextUnitProperties.addInteger(textUnit, "references", this.countDirectReferences(nestedTus));
        this.referentTus.addAll(nestedTus);
        Run run = (Run)chunks.get(runPosition);
        int nextRunPosition = runPosition + 1;
        Run nextRun = nextRunPosition < chunks.size() && chunks.get(nextRunPosition) instanceof Run ? (Run)chunks.get(nextRunPosition) : null;
        return this.addRun(tf, codeStackPopsLimit, runPosition, run, nextRun);
    }

    @Override
    protected List<ITextUnit> processNestedBlocks(Run run, String parentId) {
        IdGenerator nestedIdsGenerator = this.getNestedIdsGenerator(parentId);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>();
        for (Textual textual : run.getNestedTextualItems()) {
            if (textual instanceof Block) {
                BlockTextUnitMapper nestedMapper = new BlockTextUnitMapper(nestedIdsGenerator, this.eventFactory, (Block)textual);
                List<ITextUnit> nestedTus = nestedMapper.map();
                for (ITextUnit tu : nestedTus) {
                    tu.setIsReferent(true);
                }
                tus.addAll(nestedTus);
                continue;
            }
            if (!(textual instanceof TranslatableAttributeText)) continue;
            TextUnit tu = new TextUnit(nestedIdsGenerator.createId(), ((TranslatableAttributeText)textual).getText());
            tu.setPreserveWhitespaces(true);
            tu.setIsReferent(true);
            tus.add(tu);
        }
        return tus;
    }

    private IdGenerator getNestedIdsGenerator(String parentId) {
        if (this.nestedIdsGenerator == null) {
            this.nestedIdsGenerator = new IdGenerator(parentId, NESTED_ID_GENERATOR_PREFIX);
        }
        return this.nestedIdsGenerator;
    }

    private void popRunCodesToDepth(TextFragment tf, int desiredDepth) {
        while (this.runCodeStack.size() > desiredDepth) {
            this.addClosingCode(tf, (RunCode)this.runCodeStack.pop());
        }
    }

    private Code addOpeningCode(TextFragment tf, RunContainer rc) {
        Code code = new Code(TextFragment.TagType.OPENING, CodeTypeFactory.createCodeType(rc));
        code.setData("<" + rc.type().value() + this.nextCodeId + ">");
        code.setId(this.nextCodeId);
        tf.append(code);
        this.visibleCodes.put(this.nextCodeId, rc);
        RunPropertiesPairWithDetectedRunFonts rpp = rc.defaultRunPropertiesPairWithDetectedRunFonts();
        this.runCodeStack.push(new RunCode(this.nextCodeId++, CodeTypeFactory.createCodeType(rpp.combined()), rpp));
        return code;
    }

    private void addClosingCode(TextFragment tf, RunContainer rc, Code openCode) {
        Code code = new Code(TextFragment.TagType.CLOSING, openCode.getType());
        code.setData("</" + rc.type().value() + openCode.getId() + ">");
        code.setId(openCode.getId());
        this.runCodeStack.pop();
        tf.append(code);
    }
}

