/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellReference;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.CellType;
import net.sf.okapi.filters.openxml.CellValue;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DifferentialFormat;
import net.sf.okapi.filters.openxml.Formula;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MetadataContext;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.SharedStringsFragments;
import net.sf.okapi.filters.openxml.StyleDefinitions;

interface Cell {
    public static final String NAME = "c";

    public CellType type();

    public String worksheetName();

    public CellReferencesRange cellReferencesRange();

    public boolean valuePresent();

    public CellValue value();

    public List<XMLEvent> inlineStringEvents();

    public boolean excluded();

    public void refineExcluded();

    public MetadataContext metadataContext();

    public Attribute styleAttribute();

    public Cell copiedWithAdjusted(String var1, Attribute var2);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static class Default
    implements Cell {
        private static final String INLINE_STRING = "is";
        private static final QName CELL_LOCATION_REFERENCE = new QName("r");
        private static final QName CELL_TYPE = new QName("t");
        private static final QName CELL_STYLE = new QName("s");
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final SharedStringsFragments sharedStringsFragments;
        private final boolean date1904;
        private final StyleDefinitions styleDefinitions;
        private final Set<Integer> excludedRows;
        private final Set<String> excludedColumns;
        private final Set<Integer> metadataRows;
        private final Set<String> metadataColumns;
        private final List<CellReferencesRange> cellReferencesRanges;
        private final String worksheetName;
        private final StartElement origStartElement;
        private StartElement startElement;
        private CellType type;
        private CellReferencesRange cellReferencesRange;
        private Formula formula;
        private CellValue value;
        private List<XMLEvent> inlineStringEvents;
        private boolean excluded;
        private MetadataContext metadataContext;
        private EndElement endElement;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, SharedStringsFragments sharedStringsFragments, boolean date1904, StyleDefinitions styleDefinitions, Set<Integer> excludedRows, Set<String> excludedColumns, Set<Integer> metadataRows, Set<String> metadataColumns, List<CellReferencesRange> cellReferencesRanges, String worksheetName, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.sharedStringsFragments = sharedStringsFragments;
            this.date1904 = date1904;
            this.styleDefinitions = styleDefinitions;
            this.excludedRows = excludedRows;
            this.excludedColumns = excludedColumns;
            this.metadataRows = metadataRows;
            this.metadataColumns = metadataColumns;
            this.cellReferencesRanges = cellReferencesRanges;
            this.worksheetName = worksheetName;
            this.origStartElement = startElement;
        }

        @Override
        public CellType type() {
            return this.type;
        }

        @Override
        public String worksheetName() {
            return this.worksheetName;
        }

        @Override
        public CellReferencesRange cellReferencesRange() {
            return this.cellReferencesRange;
        }

        @Override
        public boolean valuePresent() {
            return null != this.value;
        }

        @Override
        public CellValue value() {
            return this.value;
        }

        @Override
        public List<XMLEvent> inlineStringEvents() {
            return this.inlineStringEvents;
        }

        @Override
        public boolean excluded() {
            return this.excluded;
        }

        @Override
        public void refineExcluded() {
            if (!this.excluded) {
                this.excluded = this.excludedFor(this.combinedDifferentialFormatFor(this.startElement));
            }
        }

        @Override
        public MetadataContext metadataContext() {
            if (null == this.metadataContext) {
                boolean metadataRow = false;
                if (!this.metadataRows.isEmpty()) {
                    for (Integer r : this.cellReferencesRange.rows()) {
                        if (!this.metadataRows.contains(r)) continue;
                        metadataRow = true;
                        break;
                    }
                }
                boolean metadataColumn = false;
                if (!this.metadataColumns.isEmpty()) {
                    for (String c : this.cellReferencesRange.columns()) {
                        if (!this.metadataColumns.contains(c)) continue;
                        metadataColumn = true;
                        break;
                    }
                }
                this.metadataContext = metadataRow && metadataColumn ? MetadataContext.ROW_AND_COLUMN : (metadataRow ? MetadataContext.ROW : (metadataColumn ? MetadataContext.COLUMN : MetadataContext.NONE));
            }
            return this.metadataContext;
        }

        @Override
        public Attribute styleAttribute() {
            return this.startElement.getAttributeByName(CELL_STYLE);
        }

        @Override
        public Cell copiedWithAdjusted(String column, Attribute attribute) {
            Attribute referenceAttr = this.startElement.getAttributeByName(CELL_LOCATION_REFERENCE);
            CellReference cellReference = new CellReference(this.cellReferencesRange.first().row(), column);
            CellReferencesRange cellReferencesRange = this.cellReferencesRangeFor(cellReference);
            ArrayList<Attribute> attributes = Objects.isNull(attribute) ? new ArrayList<Attribute>(List.of(this.eventFactory.createAttribute(referenceAttr.getName(), cellReference.toString()))) : new ArrayList<Attribute>(List.of(this.eventFactory.createAttribute(referenceAttr.getName(), cellReference.toString()), attribute));
            StartElement startElement = this.newStartElementOf(this.startElement, attributes);
            Default c = new Default(this.conditionalParameters, this.eventFactory, this.sharedStringsFragments, this.date1904, this.styleDefinitions, this.excludedRows, this.excludedColumns, this.metadataRows, this.metadataColumns, this.cellReferencesRanges, this.worksheetName, this.origStartElement);
            c.startElement = startElement;
            c.type = this.type;
            c.cellReferencesRange = cellReferencesRange;
            c.formula = this.formula;
            DifferentialFormat.Combined format = this.combinedDifferentialFormatFor(startElement);
            if (this.valuePresent()) {
                c.value = this.value.copiedWithAdjusted(format);
            }
            c.inlineStringEvents = this.inlineStringEvents;
            c.excluded = !cellReferencesRange.partialMatch(this.excludedRows, this.excludedColumns) || this.excludedFor(format);
            c.metadataContext = this.metadataContext;
            c.endElement = this.endElement;
            return c;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            Attribute typeAttr = this.origStartElement.getAttributeByName(CELL_TYPE);
            this.type = CellType.from(typeAttr);
            this.startElement = CellType.INLINE_STRING == this.type ? this.newStartElementOf(this.origStartElement, new ArrayList<Attribute>(List.of(this.eventFactory.createAttribute(typeAttr.getName(), CellType.SHARED_STRING.toString())))) : this.origStartElement;
            this.cellReferencesRange = this.cellReferencesRangeFor(new CellReference(this.startElement.getAttributeByName(CELL_LOCATION_REFERENCE).getValue()));
            DifferentialFormat.Combined format = this.combinedDifferentialFormatFor(this.startElement);
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if ("f".equals(se.getName().getLocalPart())) {
                    this.formula = new Formula.Default(se, new MarkupComponent.Context.Default(this.worksheetName));
                    this.formula.readWith(reader);
                    continue;
                }
                if ("v".equals(se.getName().getLocalPart())) {
                    if (!this.formulaPresent() && CellType.STRING.equals((Object)this.type)) {
                        this.type = CellType.INLINE_STRING;
                        this.startElement = this.newStartElementOf(this.startElement, new ArrayList<Attribute>(List.of(this.eventFactory.createAttribute(typeAttr.getName(), CellType.SHARED_STRING.toString()))));
                        this.inlineStringEvents = this.convertedEventsFor(se, reader);
                        this.value = new CellValue.Default(this.eventFactory, this.date1904, CellType.SHARED_STRING, format, se);
                        continue;
                    }
                    this.value = new CellValue.Default(this.eventFactory, this.date1904, this.type, format, se);
                    this.value.readWith(reader);
                    continue;
                }
                if (!INLINE_STRING.equals(se.getName().getLocalPart())) continue;
                this.inlineStringEvents = Default.innerEventsFor(se, reader);
                this.value = new CellValue.Default(this.eventFactory, this.date1904, CellType.SHARED_STRING, format, this.eventFactory.createStartElement(se.getName().getPrefix(), se.getName().getNamespaceURI(), "v"));
            }
            boolean bl = this.excluded = !this.cellReferencesRange.partialMatch(this.excludedRows, this.excludedColumns);
            if (CellType.INLINE_STRING != this.type && !this.excluded) {
                this.excluded = this.excludedFor(format);
            }
        }

        private StartElement newStartElementOf(StartElement startElement, List<Attribute> newAttributes) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute a = iterator.next();
                boolean added = false;
                if (!newAttributes.isEmpty()) {
                    Iterator<Attribute> newAttributesIterator = newAttributes.iterator();
                    while (newAttributesIterator.hasNext()) {
                        Attribute na = newAttributesIterator.next();
                        if (!na.getName().equals(a.getName())) continue;
                        attributes.add(na);
                        newAttributesIterator.remove();
                        added = true;
                        break;
                    }
                }
                if (added) continue;
                attributes.add(a);
            }
            return this.eventFactory.createStartElement(startElement.getName(), attributes.iterator(), startElement.getNamespaces());
        }

        private CellReferencesRange cellReferencesRangeFor(CellReference cellReference) {
            for (CellReferencesRange r : this.cellReferencesRanges) {
                if (!r.first().equals(cellReference)) continue;
                return r;
            }
            return new CellReferencesRange(cellReference);
        }

        private DifferentialFormat.Combined combinedDifferentialFormatFor(StartElement startElement) {
            Attribute styleAttr = startElement.getAttributeByName(CELL_STYLE);
            if (styleAttr == null) {
                return this.styleDefinitions.combinedDifferentialFormatFor(0);
            }
            int styleIndex = Integer.parseUnsignedInt(styleAttr.getValue());
            return this.styleDefinitions.combinedDifferentialFormatFor(styleIndex);
        }

        private boolean excludedFor(DifferentialFormat format) {
            for (String c : this.conditionalParameters.tsExcelExcludedColors) {
                RunProperty.ColorRunProperty crp;
                if (format.fill().pattern().backgroundColor().value().matches(c) || format.fill().pattern().foregroundColor().value().matches(c)) {
                    return true;
                }
                if (!this.valuePresent() || this.sharedStringsFragments.stringItemFormattedInlineAt(this.value.asInteger()) || null == (crp = format.font().asRunProperties().getColorRunProperty()) || !crp.asColorValue().matches(c)) continue;
                return true;
            }
            return false;
        }

        private boolean formulaPresent() {
            return null != this.formula;
        }

        private List<XMLEvent> convertedEventsFor(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), "t"));
            events.addAll(Default.innerEventsFor(startElement, reader));
            events.add(this.eventFactory.createEndElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), "t"));
            return events;
        }

        private static List<XMLEvent> innerEventsFor(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            XMLEvent e;
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            while (!(!reader.hasNext() || (e = reader.nextEvent()).isEndElement() && e.asEndElement().getName().equals(startElement.getName()))) {
                events.add(e);
            }
            return events;
        }

        @Override
        public Markup asMarkup() {
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(4)), new ArrayList<XMLEvent>(2));
            mb.add(this.startElement);
            if (this.formulaPresent()) {
                mb.add(this.formula);
            }
            if (this.valuePresent()) {
                mb.add(this.value.asMarkup());
            }
            mb.add(this.endElement);
            return mb.build();
        }
    }
}

