/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.sf.okapi.filters.openxml.CellReference;

final class CellReferencesRange {
    private static final char COLUMN_INDEX_PART_MINIMUM = 'A';
    private static final char COLUMN_INDEX_PART_MAXIMUM = 'Z';
    private static final String DELIMITER = ":";
    private final String string;
    private CellReference first;
    private CellReference last;
    private boolean split;
    private Set<Integer> rows;
    private Set<String> columns;

    CellReferencesRange(CellReference cellReference) {
        this(cellReference, cellReference);
    }

    CellReferencesRange(CellReference first, CellReference last) {
        this(first.toString() + DELIMITER + last.toString());
        this.first = first;
        this.last = last;
        this.split = true;
    }

    CellReferencesRange(String string) {
        this.string = string;
    }

    CellReference first() {
        if (!this.split) {
            this.split();
        }
        return this.first;
    }

    CellReference last() {
        if (!this.split) {
            this.split();
        }
        return this.last;
    }

    private void split() {
        String[] references = this.string.split(DELIMITER);
        if (2 < references.length) {
            throw new IllegalStateException("Unexpected merged cell range: ".concat(this.string));
        }
        if (1 == references.length) {
            this.first = new CellReference(this.string);
            this.last = new CellReference(this.string);
        } else {
            this.first = new CellReference(references[0]);
            this.last = new CellReference(references[1]);
        }
        this.split = true;
    }

    Set<Integer> rows() {
        if (null == this.rows) {
            int lastRow;
            int firstRow = this.first().row();
            this.rows = firstRow == (lastRow = this.last().row()) ? Set.of(Integer.valueOf(firstRow)) : IntStream.rangeClosed(firstRow, lastRow).boxed().collect(Collectors.toSet());
        }
        return this.rows;
    }

    Set<String> columns() {
        if (null == this.columns) {
            String lastColumnIndex;
            String firstColumnIndex = this.first().column();
            if (firstColumnIndex.equals(lastColumnIndex = this.last().column())) {
                this.columns = Set.of(firstColumnIndex);
            } else {
                this.columns = new LinkedHashSet<String>();
                String columnIndex = firstColumnIndex;
                this.columns.add(columnIndex);
                while (!columnIndex.equals(this.last().column())) {
                    columnIndex = CellReferencesRange.incrementColumnIndex(columnIndex);
                    this.columns.add(columnIndex);
                }
            }
        }
        return this.columns;
    }

    private static String incrementColumnIndex(String columnIndex) {
        return CellReferencesRange.incrementColumnIndexPart(columnIndex.toCharArray(), columnIndex.length() - 1);
    }

    private static String incrementColumnIndexPart(char[] columnIndexParts, int partPosition) {
        if (0 > partPosition) {
            return "A" + new String(columnIndexParts);
        }
        char part = columnIndexParts[partPosition];
        if ('Z' == part) {
            columnIndexParts[partPosition] = 65;
            return CellReferencesRange.incrementColumnIndexPart(columnIndexParts, --partPosition);
        }
        columnIndexParts[partPosition] = part = (char)(part + '\u0001');
        return new String(columnIndexParts);
    }

    boolean partialMatch(Set<Integer> rows, Set<String> columns) {
        if (rows.isEmpty() && columns.isEmpty()) {
            return true;
        }
        long rowMatchesCount = this.rowMatchesCount(rows);
        long columnMatchesCount = this.columnMatchesCount(columns);
        int rowsSize = this.rows().size();
        int columnsSize = this.columns().size();
        if ((long)rowsSize == rowMatchesCount || (long)columnsSize == columnMatchesCount) {
            return false;
        }
        return (long)rowsSize > rowMatchesCount || (long)columnsSize > columnMatchesCount;
    }

    boolean anyMatch(Set<Integer> rows, Set<String> columns) {
        boolean rowsMatched = this.rows().stream().anyMatch(rows::contains);
        boolean columnsMatched = this.columns().stream().anyMatch(columns::contains);
        return rowsMatched || columnsMatched;
    }

    boolean anyMatch(CellReferencesRange cellReferencesRange) {
        return this.anyMatch(cellReferencesRange.rows(), cellReferencesRange.columns());
    }

    Set<Integer> rowMatches(Set<Integer> rows) {
        LinkedHashSet<Integer> matches = new LinkedHashSet<Integer>(rows.size());
        if (rows.isEmpty()) {
            return matches;
        }
        for (Integer i : this.rows()) {
            if (!rows.contains(i)) continue;
            matches.add(i);
        }
        return matches;
    }

    private long rowMatchesCount(Set<Integer> rows) {
        if (rows.isEmpty()) {
            return 0L;
        }
        long i = 0L;
        for (Integer r : this.rows()) {
            if (!rows.contains(r)) continue;
            ++i;
        }
        return i;
    }

    Set<String> columnMatches(Set<String> columns) {
        LinkedHashSet<String> matches = new LinkedHashSet<String>(columns.size());
        if (columns.isEmpty()) {
            return matches;
        }
        for (String s : this.columns()) {
            if (!columns.contains(s)) continue;
            matches.add(s);
        }
        return matches;
    }

    private long columnMatchesCount(Set<String> columns) {
        if (columns.isEmpty()) {
            return 0L;
        }
        long i = 0L;
        for (String c : this.columns()) {
            if (!columns.contains(c)) continue;
            ++i;
        }
        return i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellReferencesRange that = (CellReferencesRange)o;
        return this.string.equals(that.string);
    }

    public int hashCode() {
        return Objects.hash(this.string);
    }

    public String toString() {
        return this.string;
    }
}

