/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.openxml.Cell;
import net.sf.okapi.filters.openxml.CellType;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.SharedStringsFragments;
import net.sf.okapi.filters.openxml.SourceAndTargetColumns;
import net.sf.okapi.filters.openxml.StringsComparator;

interface Cells {
    public void add(Cell var1);

    public void add(Cells var1);

    public Cells of(CellType var1);

    public ListIterator<Cell> iterator();

    public boolean worksheetStartsAt(ListIterator<Cell> var1);

    public boolean rowStartsAt(ListIterator<Cell> var1);

    public Markup asMarkup();

    public int size();

    public void clear();

    public static class Sorted
    implements Cells {
        private final ConditionalParameters conditionalParameters;
        private final SourceAndTargetColumns sourceAndTargetColumns;
        private final Set<Integer> excludedRows;
        private final SortedMap<String, Cell> items;

        Sorted(ConditionalParameters conditionalParameters, SourceAndTargetColumns sourceAndTargetColumns, Set<Integer> excludedRows) {
            this(conditionalParameters, sourceAndTargetColumns, excludedRows, new TreeMap<String, Cell>(new StringsComparator()));
        }

        Sorted(ConditionalParameters conditionalParameters, SourceAndTargetColumns sourceAndTargetColumns, Set<Integer> excludedRows, SortedMap<String, Cell> items) {
            this.conditionalParameters = conditionalParameters;
            this.sourceAndTargetColumns = sourceAndTargetColumns;
            this.excludedRows = excludedRows;
            this.items = items;
        }

        @Override
        public void add(Cell cell) {
            String column = cell.cellReferencesRange().first().column();
            this.items.put(column, cell);
        }

        @Override
        public void add(Cells cells) {
            ListIterator<Cell> iterator = cells.iterator();
            while (iterator.hasNext()) {
                this.add((Cell)iterator.next());
            }
        }

        @Override
        public Cells of(CellType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<Cell> iterator() {
            this.alignWithSourceAndTargetColumns();
            return new ArrayList<Cell>(this.items.values()).listIterator();
        }

        private void alignWithSourceAndTargetColumns() {
            this.sourceAndTargetColumns.source().forEach(sc -> {
                String tc = this.sourceAndTargetColumns.targetFor((String)sc);
                if (!this.cellExcludedIn(tc)) {
                    if (this.items.containsKey(sc)) {
                        this.items.put(tc, ((Cell)this.items.get(sc)).copiedWithAdjusted(tc, this.cellStyleAttributeIn(tc)));
                    } else if (!this.conditionalParameters.getPreserveExcelStylesInTargetColumns()) {
                        this.items.remove(tc);
                    }
                }
            });
        }

        private Attribute cellStyleAttributeIn(String column) {
            Attribute sa = this.conditionalParameters.getPreserveExcelStylesInTargetColumns() ? (this.items.containsKey(column) ? ((Cell)this.items.get(column)).styleAttribute() : null) : null;
            return sa;
        }

        private boolean cellExcludedIn(String column) {
            boolean excluded = this.items.containsKey(column) ? ((Cell)this.items.get(column)).excluded() : this.items.values().stream().findFirst().map(c -> c.cellReferencesRange().anyMatch(this.excludedRows, Collections.emptySet())).orElse(false).booleanValue();
            return excluded;
        }

        @Override
        public boolean worksheetStartsAt(ListIterator<Cell> iterator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean rowStartsAt(ListIterator<Cell> iterator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Markup asMarkup() {
            Markup.General m = new Markup.General(new ArrayList<MarkupComponent>(this.items.size()));
            this.items.values().forEach(cell -> m.add(cell.asMarkup()));
            return m;
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public void clear() {
            this.items.clear();
        }
    }

    public static class Default
    implements Cells {
        private final boolean extractCopied;
        private final XMLEventFactory eventFactory;
        private final SharedStringsFragments sharedStringsFragments;
        private final ArrayList<Cell> items;
        private final Map<String, Integer> formerValues;
        private int sharedStringIndex;

        Default(boolean extractCopied, XMLEventFactory eventFactory, SharedStringsFragments sharedStringsFragments) {
            this(extractCopied, eventFactory, sharedStringsFragments, new ArrayList<Cell>(), new HashMap<String, Integer>());
        }

        Default(boolean extractCopied, XMLEventFactory eventFactory, SharedStringsFragments sharedStringsFragments, ArrayList<Cell> items, Map<String, Integer> formerValues) {
            this.extractCopied = extractCopied;
            this.eventFactory = eventFactory;
            this.sharedStringsFragments = sharedStringsFragments;
            this.items = items;
            this.formerValues = formerValues;
        }

        @Override
        public void add(Cell cell) {
            if (this.extractCopied || CellType.SHARED_STRING != cell.type() || cell.excluded() || !cell.valuePresent()) {
                this.addAndUpdate(cell);
            } else {
                String fs = cell.value().asFormattedString();
                int sharedIndex = this.formerValues.getOrDefault(fs, -1);
                if (sharedIndex != -1) {
                    cell.value().update(this.eventFactory.createCharacters(String.valueOf(sharedIndex)));
                } else {
                    this.formerValues.put(fs, this.sharedStringIndex);
                    this.addAndUpdate(cell);
                }
            }
        }

        private void addAndUpdate(Cell cell) {
            this.items.add(cell);
            if (CellType.SHARED_STRING == cell.type() || CellType.INLINE_STRING == cell.type()) {
                cell.value().update(this.eventFactory.createCharacters(String.valueOf(this.sharedStringIndex)));
                if (CellType.INLINE_STRING == cell.type()) {
                    this.sharedStringsFragments.addStringItemFormattedInlineAt(this.sharedStringIndex);
                    cell.refineExcluded();
                }
                ++this.sharedStringIndex;
            }
        }

        @Override
        public void add(Cells cells) {
            this.items.ensureCapacity(this.items.size() + cells.size());
            ListIterator<Cell> iterator = cells.iterator();
            while (iterator.hasNext()) {
                this.add((Cell)iterator.next());
            }
        }

        @Override
        public Cells of(CellType type) {
            return new Default(this.extractCopied, this.eventFactory, this.sharedStringsFragments, this.items.stream().filter(c -> c.type() == type).collect(Collectors.toCollection(ArrayList::new)), new HashMap<String, Integer>(this.formerValues));
        }

        @Override
        public ListIterator<Cell> iterator() {
            return this.items.listIterator();
        }

        @Override
        public boolean worksheetStartsAt(ListIterator<Cell> iterator) {
            if (!iterator.hasPrevious()) {
                return true;
            }
            Cell current = iterator.previous();
            if (!iterator.hasPrevious()) {
                iterator.next();
                return true;
            }
            Cell previous = iterator.previous();
            iterator.next();
            iterator.next();
            return !previous.worksheetName().equals(current.worksheetName());
        }

        @Override
        public boolean rowStartsAt(ListIterator<Cell> iterator) {
            if (!iterator.hasPrevious()) {
                return true;
            }
            Cell current = iterator.previous();
            if (!iterator.hasPrevious()) {
                iterator.next();
                return true;
            }
            Cell previous = iterator.previous();
            iterator.next();
            iterator.next();
            return previous.cellReferencesRange().first().row() != current.cellReferencesRange().first().row();
        }

        @Override
        public Markup asMarkup() {
            Markup.General m = new Markup.General(new ArrayList<MarkupComponent>(this.items.size()));
            this.items.forEach(cell -> m.add(cell.asMarkup()));
            return m;
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public void clear() {
            this.items.clear();
            this.formerValues.clear();
        }
    }
}

