/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.NamedColor;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface ColorScheme {
    public static final String NAME = "clrScheme";

    public String colorValueFor(int var1);

    public String colorValueFor(String var1);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements ColorScheme {
        private static final String EXTENSION_LIST = "extLst";
        private final PresetColorValues presetColorValues;
        private final StartElement startElement;
        private final List<NamedColor> namedColors;
        private List<XMLEvent> extensionListEvents;
        private EndElement endElement;

        Default(PresetColorValues presetColorValues, StartElement startElement) {
            this(presetColorValues, startElement, new ArrayList<NamedColor>());
        }

        Default(PresetColorValues presetColorValues, StartElement startElement, List<NamedColor> namedColors) {
            this.presetColorValues = presetColorValues;
            this.startElement = startElement;
            this.namedColors = namedColors;
        }

        @Override
        public String colorValueFor(int index) {
            return this.namedColors.get(index).color().value().asRgb();
        }

        @Override
        public String colorValueFor(String name) {
            List ncs = this.namedColors.stream().filter(nc -> nc.name().equals(name)).collect(Collectors.toList());
            if (1 != ncs.size()) {
                throw new IllegalStateException("Unsupported number of named colors found: ".concat(String.valueOf(ncs.size())));
            }
            return ((NamedColor)ncs.get(0)).color().value().asRgb();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if (NamedColor.NAMES.contains(se.getName().getLocalPart())) {
                    NamedColor.Default nc = new NamedColor.Default(this.presetColorValues, this, se);
                    nc.readWith(reader);
                    this.namedColors.add(nc);
                    continue;
                }
                if (!EXTENSION_LIST.equals(se.getName().getLocalPart())) continue;
                this.extensionListEvents = XMLEventHelpers.eventsFor(se, reader);
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            int initialMarkupComponentsCapacity = 2 + this.namedColors.size();
            int initialEventsCapacity = null == this.extensionListEvents ? 2 : 1 + this.extensionListEvents.size();
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(initialMarkupComponentsCapacity)), new ArrayList<XMLEvent>(initialEventsCapacity));
            mb.add(this.startElement);
            if (null != this.extensionListEvents) {
                mb.addAll(this.extensionListEvents);
            }
            this.namedColors.forEach(nc -> mb.add(nc.asMarkup()));
            mb.add(this.endElement);
            return mb.build();
        }
    }

    public static final class Empty
    implements ColorScheme {
        private static final String EMPTY = "";

        @Override
        public String colorValueFor(int index) {
            return EMPTY;
        }

        @Override
        public String colorValueFor(String name) {
            return EMPTY;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

