/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;

interface ContentType {
    public String id();

    public String value();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static class Override
    implements ContentType {
        static String NAME = "Override";
        static final QName PART_NAME = new QName("PartName");
        private final Default defaultType;

        Override(Default defaultType) {
            this.defaultType = defaultType;
        }

        @java.lang.Override
        public String id() {
            return this.defaultType.startElement.getAttributeByName(PART_NAME).getValue();
        }

        @java.lang.Override
        public String value() {
            return this.defaultType.value();
        }

        @java.lang.Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            this.defaultType.readWith(eventReader);
        }

        @java.lang.Override
        public Markup asMarkup() {
            return this.defaultType.asMarkup();
        }
    }

    public static class Default
    implements ContentType {
        static final String NAME = "Default";
        static final QName EXTENSION = new QName("Extension");
        static final QName CONTENT_TYPE = new QName("ContentType");
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private EndElement endElement;

        Default(XMLEventFactory eventFactory, StartElement startElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @java.lang.Override
        public String id() {
            return this.startElement.getAttributeByName(EXTENSION).getValue();
        }

        @java.lang.Override
        public String value() {
            return this.startElement.getAttributeByName(CONTENT_TYPE).getValue();
        }

        @java.lang.Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (!e.isEndElement() || !e.asEndElement().getName().equals(this.startElement.getName())) continue;
                this.endElement = e.asEndElement();
                break;
            }
        }

        @java.lang.Override
        public Markup asMarkup() {
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(1)), new ArrayList<XMLEvent>(2));
            mb.add(this.startElement);
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }
}

