/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ContentType;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;

interface ContentTypes {
    public static final String PART_NAME = "[Content_Types].xml";

    public Iterator<ContentType> iterator();

    public ContentTypes with(String var1);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public void addFrom(String var1, String var2);

    public Markup asMarkup();

    public static class Values {
        private static final String APPLICATION_PREFIX = "application/vnd.";
        private static final String DOCUMENT_PREFIX = "application/vnd.openxmlformats-officedocument.";

        static class Visio {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.ms-visio.drawing.main+xml";
            static final String MACRO_ENABLED_MAIN_DOCUMENT_TYPE = "application/vnd.ms-visio.drawing.macroEnabled.main+xml";
            static final String MASTER_TYPE = "application/vnd.ms-visio.master+xml";
            static final String PAGE_TYPE = "application/vnd.ms-visio.page+xml";

            Visio() {
            }
        }

        static class Excel {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
            static final String MACRO_ENABLED_MAIN_DOCUMENT_TYPE = "application/vnd.ms-excel.sheet.macroEnabled.main+xml";
            static final String TEMPLATE_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml";
            static final String MACRO_ENABLED_TEMPLATE_DOCUMENT_TYPE = "application/vnd.ms-excel.template.macroEnabled.main+xml";
            static final String SHARED_STRINGS_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
            static final String WORKSHEET_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml";
            static final String COMMENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml";
            static final String TABLE_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml";
            static final String PIVOT_TABLE_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml";
            static final String PIVOT_CACHE_DEFINITION_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml";
            static final String STYLES_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml";
            static final String DRAWINGS_TYPE = "application/vnd.openxmlformats-officedocument.drawing+xml";

            Excel() {
            }
        }

        static class Powerpoint {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml";
            static final String MACRO_ENABLED_MAIN_DOCUMENT_TYPE = "application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml";
            static final String SLIDE_SHOW_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml";
            static final String MACRO_ENABLED_SLIDE_SHOW_DOCUMENT_TYPE = "application/vnd.ms-powerpoint.slideshow.macroEnabled.main+xml";
            static final String TEMPLATE_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml";
            static final String MACRO_ENABLED_TEMPLATE_DOCUMENT_TYPE = "application/vnd.ms-powerpoint.template.macroEnabled.main+xml";
            static final String SLIDE_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slide+xml";
            static final String SLIDE_LAYOUT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml";
            static final String SLIDE_MASTER_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml";
            static final String COMMENTS_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.comments+xml";
            static final String NOTES_SLIDE_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml";
            static final String NOTES_MASTER_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml";

            Powerpoint() {
            }
        }

        static class Drawing {
            static final String CHART_TYPE = "application/vnd.openxmlformats-officedocument.drawingml.chart+xml";
            static final String DIAGRAM_DATA_TYPE = "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml";
            static final String THEME_TYPE = "application/vnd.openxmlformats-officedocument.theme+xml";
            static final String THEME_OVERRIDE_TYPE = "application/vnd.openxmlformats-officedocument.themeOverride+xml";

            Drawing() {
            }
        }

        static class Word {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml";
            static final String MACRO_ENABLED_MAIN_DOCUMENT_TYPE = "application/vnd.ms-word.document.macroEnabled.main+xml";
            static final String TEMPLATE_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml";
            static final String MACRO_ENABLED_TEMPLATE_DOCUMENT_TYPE = "application/vnd.ms-word.template.macroEnabledTemplate.main+xml";
            static final String SETTINGS_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml";
            static final String STYLES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml";
            static final String FOOTER_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml";
            static final String ENDNOTES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml";
            static final String HEADER_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml";
            static final String FOOTNOTES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml";
            static final String COMMENTS_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml";
            static final String GLOSSARY_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml";
            static final String NUMBERING_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml";

            Word() {
            }
        }

        static class Common {
            static final String CORE_PROPERTIES_TYPE = "application/vnd.openxmlformats-package.core-properties+xml";
            static final String PACKAGE_RELATIONSHIPS = "application/vnd.openxmlformats-package.relationships+xml";

            Common() {
            }
        }
    }

    public static class Default
    implements ContentTypes {
        private static final String NAME = "Types";
        private final XMLEventFactory eventFactory;
        private final List<ContentType> contentTypes;
        private StartDocument startDocument;
        private StartElement startElement;
        private EndElement endElement;
        private EndDocument endDocument;

        Default(XMLEventFactory eventFactory) {
            this(eventFactory, new LinkedList<ContentType>());
        }

        Default(XMLEventFactory eventFactory, List<ContentType> contentTypes) {
            this.eventFactory = eventFactory;
            this.contentTypes = contentTypes;
        }

        @Override
        public Iterator<ContentType> iterator() {
            return this.contentTypes.iterator();
        }

        @Override
        public ContentTypes with(String partPath) {
            String wellformedPath = Default.wellformedPath(partPath);
            List<ContentType> types = this.contentTypes.stream().filter(ct -> ct.id().equals(wellformedPath)).collect(Collectors.toList());
            if (types.isEmpty()) {
                types = this.contentTypes.stream().filter(ct -> ct.id().equals(Default.extensionOf(wellformedPath))).collect(Collectors.toList());
            }
            if (types.isEmpty()) {
                List<Attribute> attributes = Arrays.asList(this.eventFactory.createAttribute(ContentType.Default.EXTENSION, ""), this.eventFactory.createAttribute(ContentType.Default.CONTENT_TYPE, "application/octet-stream"));
                types = new LinkedList<ContentType.Default>(Arrays.asList(new ContentType.Default(this.eventFactory, this.eventFactory.createStartElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "Default", attributes.iterator(), null))));
            }
            Default contentTypes = new Default(this.eventFactory, types);
            contentTypes.startDocument = this.startDocument;
            contentTypes.startElement = this.startElement;
            contentTypes.endElement = this.endElement;
            contentTypes.endDocument = this.endDocument;
            return contentTypes;
        }

        private static String wellformedPath(String p) {
            return p.startsWith("/") ? p : "/" + p;
        }

        private static String extensionOf(String partName) {
            int i = partName.lastIndexOf(46);
            String extension = i != -1 ? partName.substring(i + 1) : partName;
            return extension;
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            while (eventReader.hasNext()) {
                ContentType ct;
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndDocument()) {
                    this.endDocument = (EndDocument)e;
                    break;
                }
                if (e.isStartDocument()) {
                    this.startDocument = (StartDocument)e;
                    continue;
                }
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    continue;
                }
                if (e.isStartElement() && NAME.equals(e.asStartElement().getName().getLocalPart())) {
                    this.startElement = e.asStartElement();
                    continue;
                }
                if (e.isStartElement() && "Default".equals(e.asStartElement().getName().getLocalPart())) {
                    ct = new ContentType.Default(this.eventFactory, e.asStartElement());
                    ct.readWith(eventReader);
                    this.contentTypes.add(ct);
                    continue;
                }
                if (!e.isStartElement() || !ContentType.Override.NAME.equals(e.asStartElement().getName().getLocalPart())) continue;
                ct = new ContentType.Override(new ContentType.Default(this.eventFactory, e.asStartElement()));
                ct.readWith(eventReader);
                this.contentTypes.add(ct);
            }
        }

        @Override
        public void addFrom(String partPath, String type) {
            List<Attribute> attributes = Arrays.asList(this.eventFactory.createAttribute(ContentType.Override.PART_NAME, partPath), this.eventFactory.createAttribute(ContentType.Default.CONTENT_TYPE, type));
            this.contentTypes.add(new ContentType.Override(new ContentType.Default(this.eventFactory, this.eventFactory.createStartElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), ContentType.Override.NAME, attributes.iterator(), null))));
        }

        @Override
        public Markup asMarkup() {
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(2 + this.contentTypes.size())), new ArrayList<XMLEvent>(2));
            mb.add(this.startDocument);
            mb.add(this.startElement);
            this.contentTypes.forEach(ct -> mb.add(ct.asMarkup()));
            mb.add(this.endElement);
            mb.add(this.endDocument);
            return mb.build();
        }
    }
}

