/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.CorruptDocumentException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiEncryptedDataException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentTypes;
import net.sf.okapi.filters.openxml.DispersedTranslations;
import net.sf.okapi.filters.openxml.ExcelDocument;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.Namespaces2;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.PartPath;
import net.sf.okapi.filters.openxml.PowerpointDocument;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.RelationshipIdGeneration;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;
import net.sf.okapi.filters.openxml.VisioDocument;
import net.sf.okapi.filters.openxml.WordDocument;

interface Document {
    public Event open() throws IOException, XMLStreamException;

    public PresetColorValues highlightColorValues();

    public SystemColorValues systemColorValues();

    public IndexedColors indexedColors();

    public boolean isStyledTextPart(ZipEntry var1);

    public StyleDefinitions styleDefinitionsFor(ZipEntry var1);

    public boolean hasNextPart();

    public Part nextPart() throws IOException, XMLStreamException;

    public void close() throws IOException;

    public static class General
    implements Document {
        private static final String UNSUPPORTED_MAIN_DOCUMENT_PART = "Unsupported main document part";
        private static final String UNSUPPORTED_NUMBER_OF_THEMES = "Unsupported number of themes";
        private static final String EMPTY = "";
        private static final String OFFICE_DOCUMENT = "/officeDocument";
        private static final String DOCUMENT = "/document";
        private static final String THEME = "/theme";
        private final ConditionalParameters conditionalParameters;
        private final XMLInputFactory inputFactory;
        private final XMLOutputFactory outputFactory;
        private final XMLEventFactory eventFactory;
        private final DispersedTranslations dispersedTranslations;
        private final String startDocumentId;
        private final URI uri;
        private final LocaleId sourceLocale;
        private final String encoding;
        private final EncoderManager encoderManager;
        private final IFilter subfilter;
        private final IFilterWriter filterWriter;
        private ZipFile zipFile;
        private int currentSubDocumentId;
        private RelationshipIdGeneration relationshipIdGeneration;
        private Relationships rootRelationships;
        private ContentTypes contentTypes;
        private PartPath mainPartBasePath;
        private String mainPartPath;
        private Namespaces2 mainPartNamespaces;
        private Namespace mainPartRelationshipsNamespace;
        private Relationships mainPartRelationships;
        private PresetColorValues presetColorValues;
        private Theme mainPartTheme;
        private Document categorisedDocument;

        General(ConditionalParameters conditionalParameters, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, DispersedTranslations dispersedTranslations, String startDocumentId, URI uri, LocaleId sourceLocale, String encoding, EncoderManager encoderManager, IFilter subfilter, IFilterWriter filterWriter) {
            this.conditionalParameters = conditionalParameters;
            this.inputFactory = inputFactory;
            this.outputFactory = outputFactory;
            this.eventFactory = eventFactory;
            this.dispersedTranslations = dispersedTranslations;
            this.startDocumentId = startDocumentId;
            this.uri = uri;
            this.sourceLocale = sourceLocale;
            this.encoding = encoding;
            this.encoderManager = encoderManager;
            this.subfilter = subfilter;
            this.filterWriter = filterWriter;
        }

        @Override
        public Event open() throws IOException, XMLStreamException {
            File fZip = new File(this.uri.getPath());
            if (this.isEncrypted(fZip)) {
                throw new OkapiEncryptedDataException();
            }
            this.zipFile = new ZipFile(new File(this.uri.getPath()), 1);
            this.currentSubDocumentId = 0;
            this.relationshipIdGeneration = new RelationshipIdGeneration.Default();
            this.rootRelationships = this.relationshipsFor(EMPTY);
            this.initializeContentTypes();
            this.initializeMainPartPathAndRelationshipsNamespace();
            this.mainPartNamespaces = this.mainPartNamespaces();
            this.mainPartBasePath = this.basePathFor(this.mainPartPath);
            this.mainPartRelationships = this.relationshipsFor(this.mainPartPath);
            this.presetColorValues = new PresetColorValues.Default();
            this.initializeCategorisedDocument();
            return this.categorisedDocument.open();
        }

        private boolean isEncrypted(File file) throws IOException {
            boolean bl;
            FileImageInputStream is = new FileImageInputStream(file);
            try {
                is.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                new CompoundDocument((ImageInputStream)is);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (CorruptDocumentException e) {
                    return false;
                }
            }
            is.close();
            return bl;
        }

        private void initializeContentTypes() throws XMLStreamException, IOException {
            this.contentTypes = new ContentTypes.Default(this.eventFactory);
            try (Reader reader = this.getPartReader("[Content_Types].xml");){
                this.contentTypes.readWith(this.inputFactory.createXMLEventReader(reader));
            }
        }

        private void initializeMainPartPathAndRelationshipsNamespace() throws IOException, XMLStreamException {
            Iterator<Relationship> relationshipsOfOfficeDocumentSourceTypeIterator = this.rootRelationships.of("http://schemas.openxmlformats.org/officeDocument/2006/relationships".concat(OFFICE_DOCUMENT)).iterator();
            Iterator<Relationship> relationshipsOfStrictOfficeDocumentSourceTypeIterator = this.rootRelationships.of("http://purl.oclc.org/ooxml/officeDocument/relationships".concat(OFFICE_DOCUMENT)).iterator();
            Iterator<Relationship> relationshipsVisioDocumentSourceTypeIterator = this.rootRelationships.of("http://schemas.microsoft.com/visio/2010/relationships".concat(DOCUMENT)).iterator();
            if (relationshipsOfOfficeDocumentSourceTypeIterator.hasNext()) {
                this.mainPartPath = relationshipsOfOfficeDocumentSourceTypeIterator.next().target();
                this.mainPartRelationshipsNamespace = new Namespace.Default("http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            } else if (relationshipsOfStrictOfficeDocumentSourceTypeIterator.hasNext()) {
                this.mainPartPath = relationshipsOfStrictOfficeDocumentSourceTypeIterator.next().target();
                this.mainPartRelationshipsNamespace = new Namespace.Default("http://purl.oclc.org/ooxml/officeDocument/relationships");
            } else if (relationshipsVisioDocumentSourceTypeIterator.hasNext()) {
                this.mainPartPath = relationshipsVisioDocumentSourceTypeIterator.next().target();
                this.mainPartRelationshipsNamespace = new Namespace.Default("http://schemas.microsoft.com/visio/2010/relationships");
            } else {
                throw new OkapiBadFilterInputException(UNSUPPORTED_MAIN_DOCUMENT_PART);
            }
        }

        private void initializeCategorisedDocument() {
            switch (this.contentTypes.with(this.mainPartPath).iterator().next().value()) {
                case "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml": 
                case "application/vnd.ms-word.document.macroEnabled.main+xml": 
                case "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml": 
                case "application/vnd.ms-word.template.macroEnabledTemplate.main+xml": {
                    this.categorisedDocument = new WordDocument(this);
                    break;
                }
                case "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml": 
                case "application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml": 
                case "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml": 
                case "application/vnd.ms-powerpoint.slideshow.macroEnabled.main+xml": 
                case "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml": 
                case "application/vnd.ms-powerpoint.template.macroEnabled.main+xml": {
                    this.categorisedDocument = new PowerpointDocument(this);
                    break;
                }
                case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": 
                case "application/vnd.ms-excel.sheet.macroEnabled.main+xml": 
                case "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml": 
                case "application/vnd.ms-excel.template.macroEnabled.main+xml": {
                    this.categorisedDocument = new ExcelDocument(this, this.encoderManager, this.subfilter);
                    break;
                }
                case "application/vnd.ms-visio.drawing.main+xml": 
                case "application/vnd.ms-visio.drawing.macroEnabled.main+xml": {
                    this.categorisedDocument = new VisioDocument(this);
                    break;
                }
                default: {
                    throw new OkapiBadFilterInputException(String.format("%s: %s", UNSUPPORTED_MAIN_DOCUMENT_PART, this.mainPartPath));
                }
            }
        }

        Event startDocumentEvent() {
            StartDocument startDoc = new StartDocument(this.startDocumentId);
            startDoc.setName(this.uri.getPath());
            startDoc.setLocale(this.sourceLocale);
            startDoc.setMimeType("text/xml");
            startDoc.setLineBreak("\n");
            startDoc.setEncoding(this.encoding, false);
            startDoc.setFilterWriter(this.filterWriter);
            startDoc.setFilterId("okf_openxml");
            startDoc.setFilterParameters(this.conditionalParameters);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, null);
            return new Event(EventType.START_DOCUMENT, startDoc, skel);
        }

        @Override
        public boolean isStyledTextPart(ZipEntry entry) {
            return this.categorisedDocument.isStyledTextPart(entry);
        }

        @Override
        public StyleDefinitions styleDefinitionsFor(ZipEntry entry) {
            return this.categorisedDocument.styleDefinitionsFor(entry);
        }

        @Override
        public boolean hasNextPart() {
            return this.categorisedDocument.hasNextPart();
        }

        @Override
        public Part nextPart() throws IOException, XMLStreamException {
            return this.categorisedDocument.nextPart();
        }

        @Override
        public void close() throws IOException {
            if (null != this.categorisedDocument) {
                this.categorisedDocument.close();
            }
            if (null != this.categorisedDocument) {
                this.zipFile.close();
            }
        }

        ConditionalParameters conditionalParameters() {
            return this.conditionalParameters;
        }

        XMLInputFactory inputFactory() {
            return this.inputFactory;
        }

        XMLOutputFactory outputFactory() {
            return this.outputFactory;
        }

        XMLEventFactory eventFactory() {
            return this.eventFactory;
        }

        DispersedTranslations dispersedTranslations() {
            return this.dispersedTranslations;
        }

        String documentId() {
            return this.startDocumentId;
        }

        String nextSubDocumentId() {
            return String.valueOf(++this.currentSubDocumentId);
        }

        LocaleId sourceLocale() {
            return this.sourceLocale;
        }

        String encoding() {
            return this.encoding;
        }

        ZipFile zipFile() {
            return this.zipFile;
        }

        InputStream inputStreamFor(ZipEntry entry) throws IOException {
            return this.zipFile.getInputStream(entry);
        }

        Enumeration<? extends ZipEntry> entries() {
            return this.zipFile.entries();
        }

        RelationshipIdGeneration relationshipIdGeneration() {
            return this.relationshipIdGeneration;
        }

        Relationships rootRelationships() {
            return this.rootRelationships;
        }

        ContentTypes contentTypes() {
            return this.contentTypes;
        }

        String contentTypeFor(ZipEntry entry) {
            return this.contentTypes.with(entry.getName()).iterator().next().value();
        }

        PartPath mainPartBasePath() {
            return this.mainPartBasePath;
        }

        String mainPartPath() {
            return this.mainPartPath;
        }

        Namespace mainPartRelationshipsNamespace() {
            return this.mainPartRelationshipsNamespace;
        }

        Relationships mainPartRelationships() {
            return this.mainPartRelationships;
        }

        Namespaces2 mainPartNamespaces() throws XMLStreamException, IOException {
            if (null == this.mainPartNamespaces) {
                this.mainPartNamespaces = this.namespacesOf(this.zipFile.getEntry(this.mainPartPath));
            }
            return this.mainPartNamespaces;
        }

        Namespaces2 namespacesOf(ZipEntry entry) throws IOException, XMLStreamException {
            Namespaces2.Default namespaces = new Namespaces2.Default();
            try (Reader reader = this.getPartReader(entry.getName());){
                namespaces.readWith(this.inputFactory.createXMLEventReader(reader));
            }
            return namespaces;
        }

        PresetColorValues presetColorValues() {
            return this.presetColorValues;
        }

        @Override
        public PresetColorValues highlightColorValues() {
            return this.categorisedDocument.highlightColorValues();
        }

        @Override
        public SystemColorValues systemColorValues() {
            return this.categorisedDocument.systemColorValues();
        }

        @Override
        public IndexedColors indexedColors() {
            return this.categorisedDocument.indexedColors();
        }

        Theme mainPartTheme() throws IOException, XMLStreamException {
            if (null == this.mainPartTheme) {
                Set<String> themes = this.targetsOf(this.mainPartRelationships.of(this.mainPartRelationshipsNamespace.uri().concat(THEME)));
                if (0 == themes.size()) {
                    this.mainPartTheme = new Theme.Empty();
                } else {
                    this.mainPartTheme = new Theme.Default(this.presetColorValues);
                    Iterator<String> iterator = themes.iterator();
                    if (iterator.hasNext()) {
                        try (Reader reader = this.getPartReader(iterator.next());){
                            this.mainPartTheme.readWith(this.inputFactory.createXMLEventReader(reader));
                        }
                    }
                }
            }
            return this.mainPartTheme;
        }

        Reader getPartReader(String partName) throws IOException {
            ZipEntry entry = this.zipFile.getEntry(partName);
            if (entry == null) {
                throw new OkapiBadFilterInputException("File is missing " + partName);
            }
            return new InputStreamReader(this.zipFile.getInputStream(entry), this.encoding);
        }

        Relationships relationshipsFor(String partPath) throws IOException, XMLStreamException {
            Relationships.Default relationships = new Relationships.Default(this.eventFactory, this.relationshipIdGeneration, this.basePathFor(partPath));
            PartPath relationshipsPartPath = this.relationshipsPartPathFor(partPath);
            if (this.available(relationshipsPartPath.asString())) {
                try (Reader reader = this.getPartReader(relationshipsPartPath.asString());){
                    relationships.readWith(this.inputFactory.createXMLEventReader(reader));
                }
            }
            return relationships;
        }

        private PartPath basePathFor(String partPath) {
            PartPath.Default p = new PartPath.Default(partPath, new String[0]);
            PartPath basePath = 1 < p.numberOfParts() ? p.subpath(0, p.numberOfParts() - 1) : new PartPath.Default(EMPTY, new String[0]);
            return basePath;
        }

        PartPath relationshipsPartPathFor(String partPath) {
            return this.basePathFor(partPath).resolve("_rels/").resolve(this.partNameFrom(partPath).concat(".rels"));
        }

        private String partNameFrom(String partPath) {
            PartPath.Default p = new PartPath.Default(partPath, new String[0]);
            return p.partFor(p.numberOfParts() - 1).asString();
        }

        PartPath mainPartPathFor(String relationshipsPartPath) {
            PartPath basePath = this.baseRelationshipsPartPathFor(relationshipsPartPath);
            String name = this.partNameFrom(relationshipsPartPath);
            return basePath.resolve(name.substring(0, name.indexOf(".rels")));
        }

        Relationships relationshipsFrom(String relationshipsPartPath) throws IOException, XMLStreamException {
            Relationships.Default relationships = new Relationships.Default(this.eventFactory(), this.relationshipIdGeneration(), this.baseRelationshipsPartPathFor(relationshipsPartPath));
            try (Reader reader = this.getPartReader(relationshipsPartPath);){
                relationships.readWith(this.inputFactory().createXMLEventReader(reader));
            }
            return relationships;
        }

        private PartPath baseRelationshipsPartPathFor(String relationshipsPartPath) {
            PartPath.Default p = new PartPath.Default(relationshipsPartPath, new String[0]);
            PartPath basePath = 2 < p.numberOfParts() ? p.subpath(0, p.numberOfParts() - 2) : p.subpath(0, p.numberOfParts() - 1);
            return basePath;
        }

        private boolean available(String partName) {
            return this.zipFile.getEntry(partName) != null;
        }

        Map<String, String> partsByRelatedPart(List<String> partPaths, String relationshipType) throws IOException, XMLStreamException {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String partPath : partPaths) {
                for (String target : this.relationshipTargetsFor(partPath, relationshipType)) {
                    result.put(target, partPath);
                }
            }
            return result;
        }

        String targetFor(String name) {
            String partPathType = this.mainPartRelationshipsNamespace.uri().concat(name);
            Iterator<Relationship> ri = this.mainPartRelationships.of(partPathType).iterator();
            String target = ri.hasNext() ? ri.next().target() : EMPTY;
            return target;
        }

        Set<String> targetsOf(Relationships relationships) {
            Iterator<Relationship> ri = relationships.iterator();
            LinkedHashSet<String> targets = new LinkedHashSet<String>();
            while (ri.hasNext()) {
                targets.add(ri.next().target());
            }
            return targets;
        }

        Set<String> relationshipTargetsFor(String name, String type) throws IOException, XMLStreamException {
            return this.targetsOf(this.relationshipsFor(name).of(type));
        }
    }
}

