/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.ClarificationContext;
import net.sf.okapi.filters.openxml.ContentCategoriesDetection;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;

interface ElementsClarification {
    public void performFor(List<Property> var1);

    public static final class RunPropertyBoldItalicsFontSize
    implements ElementsClarification {
        private final ElementsClarification otherElementsClarification;
        private final ClarificationContext clarificationContext;
        private final ContentCategoriesDetection contentCategoriesDetection;
        private final String boldName;
        private final String complexScriptBoldName;
        private final String italicsName;
        private final String complexScriptItalicsName;
        private final String fontSizeName;
        private final String complexScriptFontSizeName;

        RunPropertyBoldItalicsFontSize(ElementsClarification otherElementsClarification, ContentCategoriesDetection contentCategoriesDetection, ClarificationContext clarificationContext, String boldName, String complexScriptBoldName, String italicsName, String complexScriptItalicsName, String fontSizeName, String complexScriptFontSizeName) {
            this.otherElementsClarification = otherElementsClarification;
            this.contentCategoriesDetection = contentCategoriesDetection;
            this.clarificationContext = clarificationContext;
            this.boldName = boldName;
            this.complexScriptBoldName = complexScriptBoldName;
            this.italicsName = italicsName;
            this.complexScriptItalicsName = complexScriptItalicsName;
            this.fontSizeName = fontSizeName;
            this.complexScriptFontSizeName = complexScriptFontSizeName;
        }

        @Override
        public void performFor(List<Property> properties) {
            this.otherElementsClarification.performFor(properties);
            if ("w".equals(this.clarificationContext.creationalParameters().getPrefix()) && !this.clarificationContext.runText().isEmpty()) {
                RunProperties combinedRunProperties = this.clarificationContext.combinedRunProperties();
                AvailableRunProperties combined = this.availableRunPropertiesFrom(combinedRunProperties.properties());
                RunFonts sourceRunFonts = this.clarificationContext.detectedRunFonts();
                RunFonts targetRunFonts = this.newRunFonts();
                this.contentCategoriesDetection.performFor(targetRunFonts, this.clarificationContext.runText());
                if (sourceRunFonts.containsDetectedComplexScriptContentCategories() && !sourceRunFonts.containsDetectedNonComplexScriptContentCategories() && targetRunFonts.containsDetectedNonComplexScriptContentCategories()) {
                    this.addNonComplexScriptProperties(properties, combined);
                }
                if (sourceRunFonts.containsDetectedNonComplexScriptContentCategories() && !sourceRunFonts.containsDetectedComplexScriptContentCategories() && targetRunFonts.containsDetectedComplexScriptContentCategories()) {
                    this.addComplexScriptProperties(properties, combined);
                }
            }
        }

        private AvailableRunProperties availableRunPropertiesFrom(List<Property> properties) {
            AvailableRunProperties ap = new AvailableRunProperties();
            properties.forEach(p -> {
                if (this.boldName.equals(p.getName().getLocalPart())) {
                    ap.boldProperty = (RunProperty)p;
                } else if (this.complexScriptBoldName.equals(p.getName().getLocalPart())) {
                    ap.complexScriptBoldProperty = (RunProperty)p;
                } else if (this.italicsName.equals(p.getName().getLocalPart())) {
                    ap.italicsProperty = (RunProperty)p;
                } else if (this.complexScriptItalicsName.equals(p.getName().getLocalPart())) {
                    ap.complexScriptItalicsProperty = (RunProperty)p;
                } else if (this.fontSizeName.equals(p.getName().getLocalPart())) {
                    ap.fontSizeProperty = (RunProperty)p;
                } else if (this.complexScriptFontSizeName.equals(p.getName().getLocalPart())) {
                    ap.complexScriptFontSizeProperty = (RunProperty)p;
                }
            });
            return ap;
        }

        private RunFonts newRunFonts() {
            return new RunFonts(this.clarificationContext.creationalParameters().getEventFactory(), this.startElementWith("rFonts", Collections.emptyIterator()), new EnumMap<RunFonts.ContentCategory, String>(RunFonts.ContentCategory.class), EnumSet.noneOf(RunFonts.ContentCategory.class));
        }

        private void addNonComplexScriptProperties(List<Property> properties, AvailableRunProperties combined) {
            if (combined.complexScriptBoldPresent() && !combined.boldPresent()) {
                properties.add(this.wpmlToggleRunPropertyWith(this.boldName, combined.complexScriptBoldProperty.getEvents().get(0).asStartElement().getAttributes()));
            }
            if (combined.complexScriptItalicsPresent() && !combined.italicsPresent()) {
                properties.add(this.wpmlToggleRunPropertyWith(this.italicsName, combined.complexScriptItalicsProperty.getEvents().get(0).asStartElement().getAttributes()));
            }
            if (combined.complexScriptFontSizePresent() && !combined.fontSizePresent()) {
                properties.add(this.genericRunPropertyWith(this.fontSizeName, combined.complexScriptFontSizeProperty.getEvents().get(0).asStartElement().getAttributes()));
            }
        }

        private void addComplexScriptProperties(List<Property> properties, AvailableRunProperties combined) {
            if (combined.boldPresent() && !combined.complexScriptBoldPresent()) {
                properties.add(this.wpmlToggleRunPropertyWith(this.complexScriptBoldName, combined.boldProperty.getEvents().get(0).asStartElement().getAttributes()));
            }
            if (combined.italicsPresent() && !combined.complexScriptItalicsPresent()) {
                properties.add(this.wpmlToggleRunPropertyWith(this.complexScriptItalicsName, combined.italicsProperty.getEvents().get(0).asStartElement().getAttributes()));
            }
            if (combined.fontSizePresent() && !combined.complexScriptFontSizePresent()) {
                properties.add(this.genericRunPropertyWith(this.complexScriptFontSizeName, combined.fontSizeProperty.getEvents().get(0).asStartElement().getAttributes()));
            }
        }

        private RunProperty wpmlToggleRunPropertyWith(String name, Iterator<Attribute> attributes) {
            return new RunProperty.WpmlToggleRunProperty(Arrays.asList(this.startElementWith(name, attributes), this.endElementWith(name)));
        }

        private RunProperty genericRunPropertyWith(String name, Iterator<Attribute> attributes) {
            return new RunProperty.GenericRunProperty(Arrays.asList(this.startElementWith(name, attributes), this.endElementWith(name)));
        }

        private StartElement startElementWith(String name, Iterator<Attribute> attributes) {
            return this.clarificationContext.creationalParameters().getEventFactory().createStartElement(this.clarificationContext.creationalParameters().getPrefix(), this.clarificationContext.creationalParameters().getNamespaceUri(), name, attributes, null);
        }

        private EndElement endElementWith(String name) {
            return this.clarificationContext.creationalParameters().getEventFactory().createEndElement(this.clarificationContext.creationalParameters().getPrefix(), this.clarificationContext.creationalParameters().getNamespaceUri(), name);
        }

        private static final class AvailableRunProperties {
            private RunProperty boldProperty;
            private RunProperty complexScriptBoldProperty;
            private RunProperty italicsProperty;
            private RunProperty complexScriptItalicsProperty;
            private RunProperty fontSizeProperty;
            private RunProperty complexScriptFontSizeProperty;

            private AvailableRunProperties() {
            }

            boolean boldPresent() {
                return null != this.boldProperty;
            }

            boolean complexScriptBoldPresent() {
                return null != this.complexScriptBoldProperty;
            }

            boolean italicsPresent() {
                return null != this.italicsProperty;
            }

            boolean complexScriptItalicsPresent() {
                return null != this.complexScriptItalicsProperty;
            }

            boolean fontSizePresent() {
                return null != this.fontSizeProperty;
            }

            boolean complexScriptFontSizePresent() {
                return null != this.complexScriptFontSizeProperty;
            }
        }
    }

    public static final class RunPropertyLang
    implements ElementsClarification {
        private final ElementsClarification otherElementsClarification;
        private final ClarificationContext clarificationContext;
        private final String elementName;
        private final String attributeName;

        RunPropertyLang(ElementsClarification otherElementsClarification, ClarificationContext clarificationContext, String elementName, String attributeName) {
            this.otherElementsClarification = otherElementsClarification;
            this.clarificationContext = clarificationContext;
            this.elementName = elementName;
            this.attributeName = attributeName;
        }

        @Override
        public void performFor(List<Property> properties) {
            this.otherElementsClarification.performFor(properties);
            if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetLtr() || this.clarificationContext.sourceRtl() && this.clarificationContext.targetRtl() && !this.elementName.isEmpty()) {
                return;
            }
            if (this.elementName.isEmpty()) {
                properties.add(RunPropertyFactory.createRunProperty(new QName(this.clarificationContext.creationalParameters().getNamespaceUri(), this.attributeName), this.clarificationContext.targetLocale().toString()));
            } else if (this.clarificationContext.targetHasCharactersAsNumeralSeparators()) {
                properties.add(RunPropertyFactory.createRunProperty(this.clarificationContext.creationalParameters(), this.elementName, Collections.singletonMap(this.attributeName, this.clarificationContext.targetLocale().toString())));
            }
        }
    }

    public static final class RunPropertyDefault
    implements ElementsClarification {
        private final ClarificationContext clarificationContext;
        private final String elementName;
        private final String defaultValue;
        private final String defaultValueWhenAbsent;
        private final Set<String> falseValues;
        private final Set<String> trueValues;

        RunPropertyDefault(ClarificationContext clarificationContext, String elementName, String defaultValue, String defaultValueWhenAbsent, Set<String> falseValues, Set<String> trueValues) {
            this.clarificationContext = clarificationContext;
            this.elementName = elementName;
            this.defaultValue = defaultValue;
            this.defaultValueWhenAbsent = defaultValueWhenAbsent;
            this.falseValues = falseValues;
            this.trueValues = trueValues;
        }

        @Override
        public void performFor(List<Property> properties) {
            if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetLtr() || this.clarificationContext.sourceRtl() && this.clarificationContext.targetRtl()) {
                return;
            }
            String combinedValue = this.clarificationContext.combinedRunProperties().properties().stream().filter(p -> p.getName().getLocalPart().equals(this.elementName)).map(p -> {
                String value = p.value();
                return null == value ? this.defaultValue : value;
            }).findFirst().orElse(this.defaultValueWhenAbsent);
            if (this.falseValues.contains(combinedValue)) {
                if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetRtl()) {
                    this.adjustPropertyValueToTrue(properties);
                }
            } else if (this.trueValues.contains(combinedValue) && this.clarificationContext.sourceRtl() && this.clarificationContext.targetLtr()) {
                this.adjustPropertyValueToFalse(properties);
            }
        }

        private void adjustPropertyValueToFalse(List<Property> properties) {
            Iterator<Property> iterator = properties.iterator();
            while (iterator.hasNext()) {
                Property runProperty = iterator.next();
                if (!this.elementName.equals(runProperty.getName().getLocalPart())) continue;
                iterator.remove();
                return;
            }
            properties.add(RunPropertyFactory.createRunProperty(this.clarificationContext.creationalParameters(), this.elementName, this.values((String)this.falseValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("False values are empty")))));
        }

        void adjustPropertyValueToTrue(List<Property> properties) {
            String trueValue = (String)this.trueValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("True values are empty"));
            ListIterator<Property> iterator = properties.listIterator();
            while (iterator.hasNext()) {
                Property runProperty = iterator.next();
                if (!this.elementName.equals(runProperty.getName().getLocalPart())) continue;
                iterator.set(RunPropertyFactory.createRunProperty(this.clarificationContext.creationalParameters(), this.elementName, this.values(trueValue)));
                return;
            }
            properties.add(RunPropertyFactory.createRunProperty(this.clarificationContext.creationalParameters(), this.elementName, this.values(trueValue)));
        }

        private Map<String, String> values(String trueValue) {
            Map<String, String> values = this.defaultValue.contains(trueValue) ? Collections.emptyMap() : Collections.singletonMap("val", trueValue);
            return values;
        }
    }

    public static final class ParagraphBlockPropertyDefault
    implements ElementsClarification {
        private final ClarificationContext clarificationContext;
        private final String elementName;
        private final String defaultValue;
        private final String defaultValueWhenAbsent;
        private final Set<String> falseValues;
        private final Set<String> trueValues;

        ParagraphBlockPropertyDefault(ClarificationContext clarificationContext, String elementName, String defaultValue, String defaultValueWhenAbsent, Set<String> falseValues, Set<String> trueValues) {
            this.clarificationContext = clarificationContext;
            this.elementName = elementName;
            this.defaultValue = defaultValue;
            this.defaultValueWhenAbsent = defaultValueWhenAbsent;
            this.falseValues = falseValues;
            this.trueValues = trueValues;
        }

        @Override
        public void performFor(List<Property> properties) {
            if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetLtr() || this.clarificationContext.sourceRtl() && this.clarificationContext.targetRtl()) {
                return;
            }
            String combinedValue = this.clarificationContext.combinedParagraphProperties().properties().stream().filter(p -> p.getName().getLocalPart().equals(this.elementName)).map(p -> {
                String value = p.value();
                return null == value ? this.defaultValue : value;
            }).findFirst().orElse(this.defaultValueWhenAbsent);
            if (this.falseValues.contains(combinedValue)) {
                if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetRtl()) {
                    this.adjustPropertyValueToTrue(properties);
                }
            } else if (this.trueValues.contains(combinedValue) && this.clarificationContext.sourceRtl() && this.clarificationContext.targetLtr()) {
                this.adjustPropertyValueToFalse(properties);
            }
        }

        private void adjustPropertyValueToFalse(List<Property> properties) {
            Iterator<Property> iterator = properties.iterator();
            while (iterator.hasNext()) {
                Property property = iterator.next();
                if (!this.elementName.equals(property.getName().getLocalPart())) continue;
                iterator.remove();
                return;
            }
            String falseValue = (String)this.falseValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("True values are empty"));
            properties.add(new BlockProperty(this.elementName, this.values(falseValue), this.clarificationContext.creationalParameters(), this.clarificationContext.conditionalParameters(), this.clarificationContext.presetColorValues(), this.clarificationContext.highlightColorValues(), this.clarificationContext.systemColorValues(), this.clarificationContext.indexedColors(), this.clarificationContext.theme(), new StrippableAttributes.DrawingRunProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters().getEventFactory())));
        }

        void adjustPropertyValueToTrue(List<Property> properties) {
            String trueValue = (String)this.trueValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("True values are empty"));
            ListIterator<Property> iterator = properties.listIterator();
            while (iterator.hasNext()) {
                Property runProperty = iterator.next();
                if (!this.elementName.equals(runProperty.getName().getLocalPart())) continue;
                iterator.set(new BlockProperty(this.elementName, this.values(trueValue), this.clarificationContext.creationalParameters(), this.clarificationContext.conditionalParameters(), this.clarificationContext.presetColorValues(), this.clarificationContext.highlightColorValues(), this.clarificationContext.systemColorValues(), this.clarificationContext.indexedColors(), this.clarificationContext.theme(), new StrippableAttributes.DrawingRunProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters().getEventFactory())));
                return;
            }
            properties.add(new BlockProperty(this.elementName, this.values(trueValue), this.clarificationContext.creationalParameters(), this.clarificationContext.conditionalParameters(), this.clarificationContext.presetColorValues(), this.clarificationContext.highlightColorValues(), this.clarificationContext.systemColorValues(), this.clarificationContext.indexedColors(), this.clarificationContext.theme(), new StrippableAttributes.DrawingRunProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters().getEventFactory())));
        }

        private Map<String, String> values(String trueValue) {
            Map<String, String> values = this.defaultValue.contains(trueValue) ? Collections.emptyMap() : Collections.singletonMap("val", trueValue);
            return values;
        }
    }

    public static final class TableBlockPropertyDefault
    implements ElementsClarification {
        private final ClarificationContext clarificationContext;
        private final String elementName;

        TableBlockPropertyDefault(ClarificationContext clarificationContext, String elementName) {
            this.clarificationContext = clarificationContext;
            this.elementName = elementName;
        }

        @Override
        public void performFor(List<Property> properties) {
            ListIterator<Property> iterator = properties.listIterator();
            while (iterator.hasNext()) {
                Property blockProperty = iterator.next();
                if (!this.elementName.equals(blockProperty.getName().getLocalPart())) continue;
                if (!this.clarificationContext.targetRtl()) {
                    iterator.remove();
                    return;
                }
                return;
            }
            if (this.clarificationContext.targetRtl()) {
                iterator.add(new BlockProperty(this.elementName, Collections.emptyMap(), this.clarificationContext.creationalParameters(), this.clarificationContext.conditionalParameters(), this.clarificationContext.presetColorValues(), this.clarificationContext.highlightColorValues(), this.clarificationContext.systemColorValues(), this.clarificationContext.indexedColors(), this.clarificationContext.theme(), new StrippableAttributes.DrawingRunProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters().getEventFactory())));
            }
        }
    }

    public static final class Bypass
    implements ElementsClarification {
        @Override
        public void performFor(List<Property> properties) {
        }
    }
}

