/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PatternFill;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface Fill {
    public static final String NAME = "fill";

    public PatternFill pattern();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements Fill {
        private static final String GRADIENT_FILL = "gradientFill";
        private final PresetColorValues presetColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexColors;
        private final Theme theme;
        private final StartElement startElement;
        private List<XMLEvent> gradientFillEvents;
        private PatternFill patternFill;
        private EndElement endElement;

        Default(PresetColorValues presetColorValues, SystemColorValues systemColorValues, IndexedColors indexColors, Theme theme, StartElement startElement) {
            this.presetColorValues = presetColorValues;
            this.systemColorValues = systemColorValues;
            this.indexColors = indexColors;
            this.theme = theme;
            this.startElement = startElement;
        }

        @Override
        public PatternFill pattern() {
            if (null == this.patternFill) {
                this.patternFill = new PatternFill.Empty();
            }
            return this.patternFill;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if (GRADIENT_FILL.equals(se.getName().getLocalPart())) {
                    this.gradientFillEvents = XMLEventHelpers.eventsFor(se, reader);
                    continue;
                }
                if ("patternFill".equals(se.getName().getLocalPart())) {
                    this.patternFill = new PatternFill.Default(this.presetColorValues, this.systemColorValues, this.indexColors, this.theme, se);
                    this.patternFill.readWith(reader);
                    continue;
                }
                throw new IllegalStateException("Unsupported element found: ".concat(se.getName().getLocalPart()));
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            int initialEventsCapacity = this.gradientFillEvents == null ? 0 : this.gradientFillEvents.size();
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(3)), new ArrayList<XMLEvent>(1 + initialEventsCapacity));
            mb.add(this.startElement);
            if (null != this.gradientFillEvents) {
                mb.addAll(this.gradientFillEvents);
            }
            mb.add(this.pattern().asMarkup());
            mb.add(this.endElement);
            return mb.build();
        }
    }

    public static final class Empty
    implements Fill {
        @Override
        public PatternFill pattern() {
            return new PatternFill.Empty();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

