/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupZipSkeleton;
import net.sf.okapi.filters.openxml.NonTranslatablePart;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitions;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModifiablePart
extends NonTranslatablePart {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Document.General generalDocument;
    private final ZipEntry entry;
    private final InputStream inputStream;
    private StrippableAttributes drawingDirectionStrippableAttributes;
    private XMLEventReader eventReader;

    ModifiablePart(Document.General generalDocument, ZipEntry entry, InputStream inputStream) {
        this.generalDocument = generalDocument;
        this.entry = entry;
        this.inputStream = inputStream;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.drawingDirectionStrippableAttributes = new StrippableAttributes.DrawingDirection(this.generalDocument.eventFactory());
        this.eventReader = this.generalDocument.inputFactory().createXMLEventReader(this.inputStream, this.generalDocument.encoding());
        try {
            Event event = new Event(EventType.DOCUMENT_PART, this.read());
            return event;
        }
        finally {
            if (null != this.eventReader) {
                this.eventReader.close();
            }
        }
    }

    private DocumentPart read() throws XMLStreamException, IOException {
        MarkupBuilder markupBuilder = new MarkupBuilder(new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>())));
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (XMLEventHelpers.isPresentationStartEvent(event)) {
                markupBuilder.add(new MarkupComponent.Start(this.generalDocument.eventFactory(), this.drawingDirectionStrippableAttributes.strip(event.asStartElement())));
                continue;
            }
            if (XMLEventHelpers.isPresentationEndEvent(event)) {
                markupBuilder.add(MarkupComponentFactory.createEndMarkupComponent(event.asEndElement()));
                continue;
            }
            if (event.isStartElement() && PowerpointStyleDefinitions.NAMES.contains(event.asStartElement().getName().getLocalPart())) {
                PowerpointStyleDefinitionsReader reader = new PowerpointStyleDefinitionsReader(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.eventReader, event.asStartElement(), event.asStartElement().getName().getLocalPart());
                PowerpointStyleDefinitions powerpointStyleDefinitions = new PowerpointStyleDefinitions(this.generalDocument.eventFactory());
                powerpointStyleDefinitions.readWith(reader);
                markupBuilder.add(powerpointStyleDefinitions.asMarkup());
                continue;
            }
            if (event.isStartElement() && ("rPr".equals(event.asStartElement().getName().getLocalPart()) || "endParaRPr".equals(event.asStartElement().getName().getLocalPart()))) {
                markupBuilder.add(this.runProperties(event.asStartElement()));
                continue;
            }
            markupBuilder.add(event);
        }
        DocumentPart documentPart = new DocumentPart(this.entry.getName(), false);
        documentPart.setSkeleton(new MarkupZipSkeleton(this.generalDocument.zipFile(), this.entry, this.generalDocument.outputFactory(), markupBuilder.build()));
        return documentPart;
    }

    private RunProperties runProperties(StartElement startElement) throws XMLStreamException, IOException {
        StartElementContext startElementContext = new StartElementContext(startElement, this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters());
        return new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
    }

    @Override
    public void logEvent(Event e) {
        this.LOGGER.trace("[[ {}: {} ]]", (Object)this.getClass().getSimpleName(), (Object)this.entry.getName());
    }
}

