/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.regex.Pattern;

interface RelationshipIdGeneration {
    public void refineLastIndexWith(String var1);

    public String nextId();

    public static final class Default
    implements RelationshipIdGeneration {
        private static final String R_ID = "rId";
        private final Pattern nonDigits = Pattern.compile("\\D");
        private final String nonDigitReplacement;
        private long lastIndex;

        Default() {
            this.nonDigitReplacement = "";
        }

        @Override
        public void refineLastIndexWith(String currentId) {
            String digits = this.nonDigits.matcher(currentId).replaceAll(this.nonDigitReplacement);
            long number = !digits.isEmpty() ? Long.parseUnsignedLong(digits) : 0L;
            if (number > this.lastIndex) {
                this.lastIndex = number;
            }
        }

        @Override
        public String nextId() {
            return R_ID.concat(String.valueOf(++this.lastIndex));
        }
    }
}

