/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import javax.xml.namespace.QName;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesPairWithDetectedRunFonts;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunBuilder {
    private static final String RUN_TEXT_IS_ABSENT = "The run text is absent";
    private StartElementContext startElementContext;
    private EndElement endEvent;
    private RunProperties runProperties;
    private RunProperties combinedRunProperties;
    private RunFonts detectedRunFonts;
    private List<Chunk> runBodyChunks = new ArrayList<Chunk>();
    private List<Textual> nestedTextualItems = new ArrayList<Textual>();
    private boolean isHidden = false;
    private QName textName;
    private String runStyle;
    private boolean containsNestedItems = false;
    private boolean containsComplexFields = false;
    private StyleDefinitions styleDefinitions;
    private boolean isTextPreservingWhitespace = false;
    private MarkupBuilder markupBuilder = new MarkupBuilder(new Run.Markup(new Markup.General(new ArrayList<MarkupComponent>())));
    private Queue<XMLEvent> deferredEvents = new LinkedList<XMLEvent>();
    private boolean nonWhitespaceTextPresent;
    private StringBuilder textContent = new StringBuilder();

    RunBuilder(StartElementContext startElementContext, StyleDefinitions styleDefinitions) {
        this.startElementContext = startElementContext;
        this.styleDefinitions = styleDefinitions;
    }

    StartElementContext getStartElementContext() {
        return this.startElementContext;
    }

    void setEndEvent(EndElement endEvent) {
        this.endEvent = endEvent;
    }

    List<Chunk> getRunBodyChunks() {
        return this.runBodyChunks;
    }

    void setRunBodyChunks(List<Chunk> chunks) {
        this.runBodyChunks.clear();
        this.runBodyChunks.addAll(chunks);
    }

    RunProperties getRunProperties() {
        if (null == this.runProperties) {
            this.runProperties = new RunProperties.Default(this.startElementContext.getEventFactory(), this.startElementContext.getStartElement().getName().getPrefix(), this.startElementContext.getStartElement().getName().getNamespaceURI(), "rPr");
        }
        return this.runProperties;
    }

    void setRunProperties(RunProperties runProperties) {
        this.runProperties = runProperties;
    }

    RunProperties combinedRunProperties() {
        return this.combinedRunProperties;
    }

    void refineCombinedRunProperties(String paragraphStyle, RunFonts runFonts) {
        this.combinedRunProperties = this.styleDefinitions.combinedRunProperties(paragraphStyle, this.runStyle, this.getRunProperties());
        this.combinedRunProperties.refine(Collections.singletonList(new RunProperty.FontsRunProperty(runFonts)));
    }

    RunProperties preCombinedRunProperties(String paragraphStyle) {
        return this.styleDefinitions.combinedRunProperties(paragraphStyle, this.runStyle, new RunProperties.Default(this.startElementContext.getEventFactory(), this.startElementContext.getStartElement().getName().getPrefix(), this.startElementContext.getStartElement().getName().getNamespaceURI(), "rPr"));
    }

    void detectedRunFonts(RunFonts runFonts) {
        this.detectedRunFonts = runFonts;
    }

    RunFonts detectedRunFonts() {
        return this.detectedRunFonts;
    }

    List<Textual> getNestedTextualItems() {
        return this.nestedTextualItems;
    }

    void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    QName getTextName() {
        if (null == this.textName) {
            this.textName = XMLEventHelpers.createQName("t", this.startElementContext.getStartElement().getName());
        }
        return this.textName;
    }

    String getRunStyle() {
        return this.runStyle;
    }

    void setRunStyle(String runStyle) {
        this.runStyle = runStyle;
    }

    boolean containsNestedItems() {
        return this.containsNestedItems;
    }

    void setContainsNestedItems(boolean containsNestedItems) {
        this.containsNestedItems = containsNestedItems;
    }

    boolean containsComplexFields() {
        return this.containsComplexFields;
    }

    void setContainsComplexFields(boolean containsComplexFields) {
        this.containsComplexFields = containsComplexFields;
    }

    StyleDefinitions getStyleDefinitions() {
        return this.styleDefinitions;
    }

    boolean isTextPreservingWhitespace() {
        return this.isTextPreservingWhitespace;
    }

    void setTextPreservingWhitespace(boolean textPreservingWhitespace) {
        this.isTextPreservingWhitespace = textPreservingWhitespace;
    }

    boolean preservingWhitespace() {
        XMLEvent e = this.markupBuilder.peekCurrentMarkupComponentEvent();
        return e instanceof StartElement && XMLEventHelpers.hasPreserveWhitespace(e.asStartElement());
    }

    boolean nonWhitespaceTextPresent() {
        return this.nonWhitespaceTextPresent;
    }

    void nonWhitespaceTextPresent(boolean nonWhitespaceTextPresent) {
        this.nonWhitespaceTextPresent = nonWhitespaceTextPresent;
    }

    String firstRunText() {
        ListIterator<Chunk> iterator = this.chunkIteratorForFirstRunText();
        return null == iterator ? "" : ((Run.RunText)iterator.previous()).characters().getData();
    }

    private ListIterator<Chunk> chunkIteratorForFirstRunText() {
        ListIterator<Chunk> iterator = this.getRunBodyChunks().listIterator();
        while (iterator.hasNext()) {
            Chunk chunk = iterator.next();
            if (!(chunk instanceof Run.RunText)) continue;
            return iterator;
        }
        return null;
    }

    void addToFirstRunText(String text) {
        ListIterator<Chunk> iterator = this.chunkIteratorForFirstRunText();
        if (iterator == null) {
            throw new IllegalStateException(RUN_TEXT_IS_ABSENT);
        }
        Run.RunText runText = (Run.RunText)iterator.previous();
        iterator.set(new Run.RunText(runText.startElement(), this.startElementContext.getEventFactory().createCharacters(runText.characters().getData().concat(text)), runText.endElement()));
    }

    void addText(String text) {
        this.textContent.append(text);
    }

    void flushText() {
        if (0 < this.textContent.length()) {
            this.runBodyChunks.add(new Run.RunText(this.createRunTextStartElement(), this.startElementContext.getEventFactory().createCharacters(this.textContent.toString()), this.startElementContext.getEventFactory().createEndElement(this.getTextName(), null)));
            this.textContent.setLength(0);
        }
    }

    private StartElement createRunTextStartElement() {
        return this.startElementContext.getEventFactory().createStartElement(this.getTextName(), this.isTextPreservingWhitespace && !Namespaces.DrawingML.containsName(this.getTextName()) ? Collections.singleton(this.startElementContext.getEventFactory().createAttribute("xml", Namespaces.XML.getURI(), "space", "preserve")).iterator() : null, null);
    }

    void addToMarkup(XMLEvent event) {
        this.markupBuilder.add(event);
    }

    void addToMarkup(MarkupComponent markupComponent) {
        this.markupBuilder.add(markupComponent);
    }

    void flushMarkup() {
        Run.Markup markup = (Run.Markup)this.markupBuilder.build();
        if (!markup.components().isEmpty()) {
            this.runBodyChunks.add(markup);
            this.markupBuilder = new MarkupBuilder(new Run.Markup(new Markup.General(new ArrayList<MarkupComponent>())));
        }
    }

    boolean containsMergeableMarkup() {
        return this.runBodyChunks.stream().filter(c -> c instanceof Markup).map(m -> ((Markup)((Object)m)).components()).flatMap(mcl -> mcl.stream()).filter(mc -> mc instanceof ParagraphBlockProperties).anyMatch(p -> ((ParagraphBlockProperties)p).containsRunPropertyDeletedParagraphMark());
    }

    void addDeferredEvents(Queue<XMLEvent> events) {
        this.deferredEvents.addAll(events);
    }

    Queue<XMLEvent> deferredEvents() {
        return this.deferredEvents;
    }

    Chunk build() {
        return new Run(this.startElementContext.getStartElement(), this.endEvent, new RunPropertiesPairWithDetectedRunFonts(this.getRunProperties(), this.combinedRunProperties, this.detectedRunFonts), this.runBodyChunks, this.nestedTextualItems, this.isHidden);
    }

    public String toString() {
        return "RunBuilder for " + this.build().toString();
    }
}

