/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ConsequentialDetectedRunFonts;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.ReplaceableRunProperty;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.SkippableElement;

final class RunMerger {
    private static final String UNSUPPORTED_RUN_CHUNKS_PROVIDED = "Unsupported run chunks provided";
    private static final Set<QName> skippableNonComplexScriptProperties = Set.of(SkippableElement.RunProperty.RUN_PROPERTY_BOLD.toName(), SkippableElement.RunProperty.RUN_PROPERTY_ITALICS.toName(), SkippableElement.RunProperty.RUN_PROPERTY_FONT_SIZE.toName());
    private static final Set<QName> skippableComplexScriptProperties = Set.of(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_BOLD.toName(), SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_ITALICS.toName(), SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_FONT_SIZE.toName());
    private static final Set<QName> skippableProperties = new HashSet<QName>(skippableNonComplexScriptProperties);
    private final ConditionalParameters parameters;
    private String paragraphStyle;
    private RunBuilder runBuilder;
    private List<Chunk> completedRuns = new ArrayList<Chunk>();
    private ConsequentialDetectedRunFonts consequentialDetectedRunFonts;

    RunMerger(ConditionalParameters parameters) {
        this.parameters = parameters;
    }

    void setParagraphStyle(String paragraphStyle) {
        this.paragraphStyle = paragraphStyle;
    }

    boolean hasRunBuilder() {
        return this.runBuilder != null;
    }

    List<Chunk> getRuns() throws XMLStreamException {
        if (this.runBuilder != null) {
            this.completedRuns.add(this.runBuilder.build());
            this.runBuilder = null;
        }
        return this.completedRuns;
    }

    void add(RunBuilder otherRunBuilder) throws XMLStreamException {
        if (null == this.runBuilder) {
            this.runBuilder = otherRunBuilder;
            return;
        }
        if (this.canMergeWith(otherRunBuilder)) {
            this.mergeWith(otherRunBuilder);
        } else {
            this.completedRuns.add(this.runBuilder.build());
            this.runBuilder = otherRunBuilder;
        }
    }

    private boolean canMergeWith(RunBuilder otherRunBuilder) {
        if (this.runBuilder.isHidden() || otherRunBuilder.isHidden()) {
            return false;
        }
        if (Namespaces.Math.containsName(this.runBuilder.getStartElementContext().getStartElement().getName())) {
            return false;
        }
        if (this.runBuilder.containsNestedItems() || otherRunBuilder.containsNestedItems()) {
            return false;
        }
        if (this.runBuilder.containsComplexFields() || otherRunBuilder.containsComplexFields()) {
            return false;
        }
        this.consequentialDetectedRunFonts = new ConsequentialDetectedRunFonts(this.runBuilder.detectedRunFonts(), otherRunBuilder.detectedRunFonts());
        return this.canRunPropertiesBeMerged(this.runBuilder.combinedRunProperties(), otherRunBuilder.combinedRunProperties());
    }

    private boolean canRunPropertiesBeMerged(RunProperties runProperties, RunProperties otherRunProperties) {
        int numberOfRunProperties = runProperties.count();
        int numberOfOtherRunProperties = otherRunProperties.count();
        if (this.parameters.getCleanupAggressively() && this.consequentialDetectedRunFonts.mergeable()) {
            RunProperties rps = runProperties.filteredBy(p -> skippableProperties.contains(p.getName()));
            RunProperties orps = otherRunProperties.filteredBy(p -> skippableProperties.contains(p.getName()));
            for (QName name : skippableProperties) {
                RunProperty orp;
                RunProperty rp;
                if (!rps.contains(name) && !orps.contains(name) || !(rps.contains(name) && orps.contains(name) ? !(rp = (RunProperty)rps.filteredBy(p -> p.getName().equals(name)).properties().get(0)).equals(orp = (RunProperty)orps.filteredBy(p -> p.getName().equals(name)).properties().get(0)) : skippableNonComplexScriptProperties.contains(name) && (this.consequentialDetectedRunFonts.firstContentCategoriesIntersectedAtNonComplexScriptAndComplementedAtComplexScript() || this.consequentialDetectedRunFonts.lastContentCategoriesIntersectedAtNonComplexScriptAndComplementedAtComplexScript()) || skippableComplexScriptProperties.contains(name) && (this.consequentialDetectedRunFonts.firstContentCategoriesIntersectedAtComplexScriptAndComplementedAtNonComplexScript() || this.consequentialDetectedRunFonts.lastContentCategoriesIntersectedAtComplexScriptAndComplementedAtNonComplexScript()))) continue;
                return false;
            }
            numberOfRunProperties -= rps.count();
            numberOfOtherRunProperties -= orps.count();
        }
        if (numberOfRunProperties != numberOfOtherRunProperties) {
            return false;
        }
        int numberOfMatchedProperties = 0;
        block1: for (Property p2 : runProperties.properties()) {
            if (this.parameters.getCleanupAggressively() && this.consequentialDetectedRunFonts.mergeable() && skippableProperties.contains(p2.getName())) continue;
            for (Property op : otherRunProperties.properties()) {
                if (this.parameters.getCleanupAggressively() && this.consequentialDetectedRunFonts.mergeable() && skippableProperties.contains(op.getName()) || !p2.getName().equals(op.getName())) continue;
                if (p2 instanceof MergeableRunProperty && op instanceof MergeableRunProperty ? !((MergeableRunProperty)((Object)p2)).canBeMerged((MergeableRunProperty)((Object)op)) : p2 instanceof ReplaceableRunProperty && op instanceof ReplaceableRunProperty && !((ReplaceableRunProperty)((Object)p2)).canBeReplaced((ReplaceableRunProperty)((Object)op))) {
                    return false;
                }
                ++numberOfMatchedProperties;
                continue block1;
            }
        }
        return numberOfMatchedProperties >= numberOfRunProperties;
    }

    private void mergeWith(RunBuilder otherRunBuilder) {
        this.clarifyRunProperties(otherRunBuilder);
        this.runBuilder.setRunProperties(this.mergeRunProperties(this.runBuilder.getRunProperties(), otherRunBuilder.getRunProperties(), this.runBuilder.combinedRunProperties(), otherRunBuilder.combinedRunProperties()));
        this.runBuilder.detectedRunFonts(this.mergedDetectedRunFonts(this.runBuilder.detectedRunFonts(), otherRunBuilder.detectedRunFonts()));
        this.runBuilder.refineCombinedRunProperties(this.paragraphStyle, this.runBuilder.detectedRunFonts());
        this.runBuilder.setTextPreservingWhitespace(this.runBuilder.isTextPreservingWhitespace() || otherRunBuilder.isTextPreservingWhitespace());
        this.runBuilder.setRunBodyChunks(this.mergeRunBodyChunks(this.runBuilder.getRunBodyChunks(), otherRunBuilder.getRunBodyChunks()));
    }

    private void clarifyRunProperties(RunBuilder otherRunBuilder) {
        if (this.parameters.getCleanupAggressively() && this.consequentialDetectedRunFonts.mergeable()) {
            if (this.consequentialDetectedRunFonts.contentCategoriesComplemented()) {
                RunProperties rps = this.runBuilder.getRunProperties().filteredBy(p -> skippableProperties.contains(p.getName()));
                RunProperties orps = otherRunBuilder.getRunProperties().filteredBy(p -> skippableProperties.contains(p.getName()));
                for (QName name : skippableProperties) {
                    if (!rps.contains(name) && orps.contains(name)) {
                        RunProperty op = (RunProperty)orps.filteredBy(p -> p.getName().equals(name)).properties().get(0);
                        this.runBuilder.getRunProperties().properties().add(op);
                    }
                    if (!rps.contains(name) || orps.contains(name)) continue;
                    RunProperty tp = (RunProperty)rps.filteredBy(p -> p.getName().equals(name)).properties().get(0);
                    otherRunBuilder.getRunProperties().properties().add(tp);
                }
                this.runBuilder.refineCombinedRunProperties(this.paragraphStyle, this.runBuilder.detectedRunFonts());
                otherRunBuilder.refineCombinedRunProperties(this.paragraphStyle, otherRunBuilder.detectedRunFonts());
            } else if (this.consequentialDetectedRunFonts.firstContentCategoriesIntersectedAtNonComplexScriptAndComplementedAtComplexScript()) {
                this.clarifyFirst(otherRunBuilder, skippableComplexScriptProperties);
            } else if (this.consequentialDetectedRunFonts.lastContentCategoriesIntersectedAtNonComplexScriptAndComplementedAtComplexScript()) {
                this.clarifyLast(otherRunBuilder, skippableComplexScriptProperties);
            } else if (this.consequentialDetectedRunFonts.firstContentCategoriesIntersectedAtComplexScriptAndComplementedAtNonComplexScript()) {
                this.clarifyFirst(otherRunBuilder, skippableNonComplexScriptProperties);
            } else if (this.consequentialDetectedRunFonts.lastContentCategoriesIntersectedAtComplexScriptAndComplementedAtNonComplexScript()) {
                this.clarifyLast(otherRunBuilder, skippableNonComplexScriptProperties);
            }
        }
    }

    private void clarifyFirst(RunBuilder otherRunBuilder, Set<QName> skippableProperties) {
        RunProperties rps = this.runBuilder.getRunProperties().filteredBy(p -> skippableProperties.contains(p.getName()));
        RunProperties orps = otherRunBuilder.getRunProperties().filteredBy(p -> skippableProperties.contains(p.getName()));
        for (QName name : skippableProperties) {
            if (rps.contains(name) || !orps.contains(name)) continue;
            RunProperty op = (RunProperty)orps.filteredBy(p -> p.getName().equals(name)).properties().get(0);
            this.runBuilder.getRunProperties().properties().add(op);
        }
        this.runBuilder.refineCombinedRunProperties(this.paragraphStyle, this.runBuilder.detectedRunFonts());
    }

    private void clarifyLast(RunBuilder otherRunBuilder, Set<QName> skippableProperties) {
        RunProperties rps = this.runBuilder.getRunProperties().filteredBy(p -> skippableProperties.contains(p.getName()));
        RunProperties orps = otherRunBuilder.getRunProperties().filteredBy(p -> skippableProperties.contains(p.getName()));
        for (QName name : skippableProperties) {
            if (!rps.contains(name) || orps.contains(name)) continue;
            RunProperty tp = (RunProperty)rps.filteredBy(p -> p.getName().equals(name)).properties().get(0);
            otherRunBuilder.getRunProperties().properties().add(tp);
        }
        otherRunBuilder.refineCombinedRunProperties(this.paragraphStyle, otherRunBuilder.detectedRunFonts());
    }

    private RunProperties mergeRunProperties(RunProperties runProperties, RunProperties otherRunProperties, RunProperties combinedRunProperties, RunProperties otherCombinedRunProperties) {
        List<Property> mergeableRunProperties = runProperties.getMergeableRunProperties();
        List<Property> otherMergeableRunProperties = otherRunProperties.getMergeableRunProperties();
        if (mergeableRunProperties.isEmpty() && otherMergeableRunProperties.isEmpty()) {
            return runProperties.count() <= otherRunProperties.count() ? runProperties : otherRunProperties;
        }
        if (mergeableRunProperties.size() >= otherMergeableRunProperties.size()) {
            List<Property> remainedOtherMergeableRunProperties = this.mergeMergeableRunProperties(mergeableRunProperties, otherMergeableRunProperties);
            runProperties.refine(mergeableRunProperties);
            runProperties.properties().addAll(remainedOtherMergeableRunProperties);
            this.clarifyFontsRunProperties(runProperties, this.mergeCombinedRunProperties(combinedRunProperties, otherCombinedRunProperties));
            return runProperties;
        }
        List<Property> remainedMergeableRunProperties = this.mergeMergeableRunProperties(otherMergeableRunProperties, mergeableRunProperties);
        otherRunProperties.refine(otherMergeableRunProperties);
        otherRunProperties.properties().addAll(remainedMergeableRunProperties);
        this.clarifyFontsRunProperties(otherRunProperties, this.mergeCombinedRunProperties(combinedRunProperties, otherCombinedRunProperties));
        return otherRunProperties;
    }

    private RunProperties mergeCombinedRunProperties(RunProperties combinedRunProperties, RunProperties otherCombinedRunProperties) {
        List<Property> mergeableCombinedRunProperties = combinedRunProperties.getMergeableRunProperties();
        List<Property> otherMergeableCombinedRunProperties = otherCombinedRunProperties.getMergeableRunProperties();
        if (mergeableCombinedRunProperties.size() >= otherMergeableCombinedRunProperties.size()) {
            List<Property> remainedOtherMergeableCombinedRunProperties = this.mergeMergeableRunProperties(mergeableCombinedRunProperties, otherMergeableCombinedRunProperties);
            combinedRunProperties.refine(mergeableCombinedRunProperties);
            combinedRunProperties.properties().addAll(remainedOtherMergeableCombinedRunProperties);
            return combinedRunProperties;
        }
        List<Property> remainedMergeableCombinedRunProperties = this.mergeMergeableRunProperties(otherMergeableCombinedRunProperties, mergeableCombinedRunProperties);
        otherCombinedRunProperties.refine(otherMergeableCombinedRunProperties);
        otherCombinedRunProperties.properties().addAll(remainedMergeableCombinedRunProperties);
        return otherCombinedRunProperties;
    }

    private List<Property> mergeMergeableRunProperties(List<Property> mergeableRunProperties, List<Property> otherMergeableRunProperties) {
        ArrayList<Property> remainedOtherMergeableRunProperties = new ArrayList<Property>(otherMergeableRunProperties);
        ListIterator<Property> mergeableRunPropertiesIterator = mergeableRunProperties.listIterator();
        block0: while (mergeableRunPropertiesIterator.hasNext()) {
            Property runProperty = mergeableRunPropertiesIterator.next();
            QName currentPropertyStartElementName = runProperty.getName();
            Iterator remainedOtherMergeableRunPropertyIterator = remainedOtherMergeableRunProperties.iterator();
            while (remainedOtherMergeableRunPropertyIterator.hasNext()) {
                Property otherRunProperty = (Property)remainedOtherMergeableRunPropertyIterator.next();
                QName otherPropertyStartElementName = otherRunProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                mergeableRunPropertiesIterator.set((Property)((Object)((MergeableRunProperty)((Object)runProperty)).merge((MergeableRunProperty)((Object)otherRunProperty))));
                remainedOtherMergeableRunPropertyIterator.remove();
                continue block0;
            }
        }
        return remainedOtherMergeableRunProperties;
    }

    private void clarifyFontsRunProperties(RunProperties runProperties, RunProperties combinedRunProperties) {
        RunProperty.FontsRunProperty frp = combinedRunProperties.fontsRunProperty();
        if (frp.getRunFonts().contentCategoriesUndefined()) {
            runProperties.removeBy(frp.getName());
        } else {
            runProperties.refine(Collections.singletonList(frp));
        }
    }

    private RunFonts mergedDetectedRunFonts(RunFonts detectedRunFonts, RunFonts otherDetectedRunFonts) {
        return detectedRunFonts.merge(otherDetectedRunFonts);
    }

    private List<Chunk> mergeRunBodyChunks(List<Chunk> chunks, List<Chunk> otherChunks) {
        Chunk otherChunk;
        if (chunks.isEmpty()) {
            return otherChunks;
        }
        if (otherChunks.isEmpty()) {
            return chunks;
        }
        ArrayList<Chunk> mergedChunks = new ArrayList<Chunk>(chunks.size() + otherChunks.size());
        ListIterator<Chunk> chunksIterator = chunks.listIterator(chunks.size() - 1);
        ListIterator<Chunk> otherChunksIterator = otherChunks.listIterator(0);
        Chunk chunk = chunksIterator.next();
        if (!RunMerger.canRunBodyChunksBeMerged(chunk, otherChunk = otherChunksIterator.next())) {
            mergedChunks.addAll(chunks);
            mergedChunks.addAll(otherChunks);
            return mergedChunks;
        }
        if (-1 < chunksIterator.previousIndex()) {
            mergedChunks.addAll(chunks.subList(0, chunksIterator.previousIndex()));
        }
        mergedChunks.add(this.mergeRunBodyChunks(chunk, otherChunk));
        if (otherChunks.size() > otherChunksIterator.nextIndex()) {
            mergedChunks.addAll(otherChunks.subList(otherChunksIterator.nextIndex(), otherChunks.size()));
        }
        return mergedChunks;
    }

    private static boolean canRunBodyChunksBeMerged(Chunk chunk, Chunk otherChunk) {
        return chunk instanceof Run.Markup && otherChunk instanceof Run.Markup || chunk instanceof Run.RunText && otherChunk instanceof Run.RunText;
    }

    private Chunk mergeRunBodyChunks(Chunk chunk, Chunk otherChunk) {
        if (chunk instanceof Run.Markup && otherChunk instanceof Run.Markup) {
            return this.mergeRunMarkups((Run.Markup)chunk, (Run.Markup)otherChunk);
        }
        if (chunk instanceof Run.RunText && otherChunk instanceof Run.RunText) {
            return this.mergeRunTexts((Run.RunText)chunk, (Run.RunText)otherChunk);
        }
        throw new IllegalArgumentException(UNSUPPORTED_RUN_CHUNKS_PROVIDED);
    }

    private Run.Markup mergeRunMarkups(Run.Markup markup, Run.Markup otherMarkup) {
        Run.Markup runMarkup = new Run.Markup(new Markup.General(new ArrayList<MarkupComponent>(markup.components().size() + otherMarkup.components().size())));
        runMarkup.addComponents(markup.components());
        runMarkup.addComponents(otherMarkup.components());
        return runMarkup;
    }

    private Chunk mergeRunTexts(Run.RunText text, Run.RunText otherText) {
        return new Run.RunText(RunMerger.mergeStartElements(text.startElement(), otherText.startElement()), this.mergeCharacters(text.characters(), otherText.characters()), text.endElement());
    }

    private static StartElement mergeStartElements(StartElement startElement, StartElement otherStartElement) {
        return RunMerger.numberOfIterables(startElement.getAttributes()) >= RunMerger.numberOfIterables(otherStartElement.getAttributes()) ? startElement : otherStartElement;
    }

    private static int numberOfIterables(Iterator iterator) {
        int number = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++number;
        }
        return number;
    }

    private Characters mergeCharacters(Characters characters, Characters otherCharacters) {
        return this.runBuilder.getStartElementContext().getEventFactory().createCharacters(characters.getData().concat(otherCharacters.getData()));
    }

    void reset() {
        this.completedRuns.clear();
        this.runBuilder = null;
    }

    void addToRunTextInRunBuilder(String text) {
        this.runBuilder.addToFirstRunText(text);
    }

    static {
        skippableProperties.addAll(skippableComplexScriptProperties);
    }
}

