/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.XMLEventsReader;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.BlockTextUnitMapper;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConsumableXMLEventsReader;
import net.sf.okapi.filters.openxml.ContentCategoriesDetection;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.MarkupSkeleton;
import net.sf.okapi.filters.openxml.NumberingDefinitions;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitions;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.PrioritisedXMLEventReader;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.TableMarkup;
import net.sf.okapi.filters.openxml.TranslatablePart;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class StyledTextPart
extends TranslatablePart {
    protected final IdGenerator nestedBlockId;
    protected final IdGenerator textUnitIds;
    protected StyleDefinitions styleDefinitions;
    protected StyleOptimisation styleOptimisation;
    protected NumberingDefinitions numberingDefinitions;
    protected ContentCategoriesDetection contentCategoriesDetection;
    private StrippableAttributes drawingDirectionStrippableAttributes;
    private StrippableAttributes drawingBodyDirectionStrippableAttributes;
    private StrippableAttributes drawingRunPropertiesStrippableAttributes;
    private StrippableAttributes tableRowRevisions;
    private StrippableAttributes sectionPropertiesRevisions;
    private SkippableElements tablePropertiesChangeSkippableElements;
    private SkippableElements emptySkippableElements;
    private SkippableElements revisionPropertyChangeSkippableElements;
    private SkippableElements revisionPropertyTableRowInsertedSkippableElements;
    private SkippableElements revisionPropertyTableRowDeletedSkippableElements;
    private SkippableElements bookmarkSkippableElements;
    private SkippableElements moveToRangeSkippableElements;
    private SkippableElements moveFromRangeSkippableElements;
    private SkippableElements moveToRangeEndSkippableElements;
    private Collection<XMLEvent> prioritisedEvents;
    private XMLEventReader defaultEventReader;
    protected XMLEventReader eventReader;
    protected Iterator<Event> filterEventIterator;
    protected String documentId;
    protected String subDocumentId;
    protected LocaleId sourceLocale;
    protected Markup markup;

    StyledTextPart(Document.General generalDocument, ZipEntry entry, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, NumberingDefinitions numberingDefinitions, ContentCategoriesDetection contentCategoriesDetection) {
        super(generalDocument, entry);
        this.styleDefinitions = styleDefinitions;
        this.styleOptimisation = styleOptimisation;
        this.numberingDefinitions = numberingDefinitions;
        this.contentCategoriesDetection = contentCategoriesDetection;
        this.nestedBlockId = new IdGenerator(null);
        this.textUnitIds = new IdGenerator(entry.getName(), "tu");
        this.markup = new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>()));
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.documentId = this.generalDocument.documentId();
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.sourceLocale = this.generalDocument.sourceLocale();
        XMLEventReader defaultEventReader = this.generalDocument.inputFactory().createXMLEventReader(this.generalDocument.inputStreamFor(this.entry), this.generalDocument.encoding());
        return this.open(this.documentId, this.subDocumentId, defaultEventReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event open(String documentId, String subDocumentId, XMLEventReader defaultEventReader) throws IOException, XMLStreamException {
        this.prioritisedEvents = new LinkedList<XMLEvent>();
        this.defaultEventReader = defaultEventReader;
        this.eventReader = new PrioritisedXMLEventReader(new ConsumableXMLEventsReader(new XMLEventsReader(this.prioritisedEvents)), this.defaultEventReader);
        this.drawingDirectionStrippableAttributes = new StrippableAttributes.DrawingDirection(this.generalDocument.eventFactory());
        this.drawingBodyDirectionStrippableAttributes = new StrippableAttributes.DrawingBodyDirection(this.generalDocument.eventFactory());
        this.drawingRunPropertiesStrippableAttributes = new StrippableAttributes.DrawingRunProperties(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory());
        this.tableRowRevisions = new StrippableAttributes.WordTableRowRevisions(this.generalDocument.eventFactory());
        this.sectionPropertiesRevisions = new StrippableAttributes.WordSectionPropertiesRevisions(this.generalDocument.eventFactory());
        this.tablePropertiesChangeSkippableElements = new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RevisionProperty.TABLE_PROPERTIES_CHANGE), this.generalDocument.conditionalParameters());
        this.emptySkippableElements = new SkippableElements.Empty();
        this.revisionPropertyChangeSkippableElements = new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RevisionProperty.SECTION_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.TABLE_GRID_CHANGE, SkippableElement.RevisionProperty.TABLE_PROPERTIES_EXCEPTIONS_CHANGE, SkippableElement.RevisionProperty.TABLE_ROW_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.TABLE_CELL_PROPERTIES_CHANGE), this.generalDocument.conditionalParameters()), this.generalDocument.conditionalParameters());
        this.revisionPropertyTableRowInsertedSkippableElements = new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RevisionProperty.TABLE_ROW_INSERTED), this.generalDocument.conditionalParameters()), this.generalDocument.conditionalParameters());
        this.revisionPropertyTableRowDeletedSkippableElements = new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RevisionProperty.TABLE_ROW_DELETED), this.generalDocument.conditionalParameters()), this.generalDocument.conditionalParameters());
        this.bookmarkSkippableElements = new SkippableElements.BookmarkCrossStructure(new SkippableElements.CrossStructure(new SkippableElements.Default(SkippableElement.GeneralCrossStructure.BOOKMARK_START, SkippableElement.GeneralCrossStructure.BOOKMARK_END)), "_GoBack");
        this.moveToRangeSkippableElements = new SkippableElements.RevisionCrossStructure(new SkippableElements.CrossStructure(new SkippableElements.Default(SkippableElement.RevisionCrossStructure.MOVE_TO_RANGE_START, SkippableElement.RevisionCrossStructure.MOVE_TO_RANGE_END)));
        this.moveFromRangeSkippableElements = new SkippableElements.MoveFromRevisionCrossStructure(new SkippableElements.RevisionCrossStructure(new SkippableElements.CrossStructure(new SkippableElements.Default(SkippableElement.RevisionCrossStructure.MOVE_FROM_RANGE_START, SkippableElement.RevisionCrossStructure.MOVE_FROM_RANGE_END))), "", "tr", "tbl");
        this.moveToRangeEndSkippableElements = new SkippableElements.Default(SkippableElement.RevisionCrossStructure.MOVE_TO_RANGE_END);
        try {
            this.process();
        }
        finally {
            if (this.eventReader != null) {
                this.eventReader.close();
            }
        }
        return this.createStartSubDocumentEvent(documentId, subDocumentId);
    }

    protected boolean isStyledBlockStartEvent(XMLEvent e) {
        return XMLEventHelpers.isParagraphStartEvent(e);
    }

    protected void preProcess(XMLEvent e) throws IOException, XMLStreamException {
    }

    protected boolean isCurrentBlockTranslatable() {
        return true;
    }

    private void process() throws IOException, XMLStreamException {
        TableMarkup delayedTableMarkup = new TableMarkup(new Markup.General(new LinkedList<MarkupComponent>()));
        Block mergeableBlock = null;
        StartElement parentStartElement = null;
        while (this.eventReader.hasNext()) {
            Iterator<MarkupComponent> iterator;
            MarkupComponent mc;
            StartElementContext startElementContext;
            XMLEvent e = this.eventReader.nextEvent();
            this.preProcess(e);
            if (this.isStyledBlockStartEvent(e)) {
                startElementContext = new StartElementContext(e.asStartElement(), null, this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters(), this.sourceLocale);
                Block block = new BlockParser(startElementContext, this.nestedBlockId, this.styleDefinitions, this.styleOptimisation, this.numberingDefinitions, this.contentCategoriesDetection).parse();
                if (block.isSkipped()) {
                    if ("tbl".equals(block.skippedExtraStructure())) {
                        delayedTableMarkup.removeComponentsFromLastWith("tbl");
                        continue;
                    }
                    if (!"tr".equals(block.skippedExtraStructure())) continue;
                    delayedTableMarkup.removeComponentsFromLastWith("tr");
                    continue;
                }
                this.addMarkupToDocumentPart(delayedTableMarkup);
                delayedTableMarkup.removeComponents();
                this.flushDocumentPart();
                this.prioritiseXMLEvents(block.deferredEvents());
                if (null != mergeableBlock) {
                    block.mergeWith(mergeableBlock);
                    mergeableBlock = null;
                }
                if (block.isMergeable()) {
                    mergeableBlock = block;
                    continue;
                }
                block.optimiseStyles();
                if (block.isHidden()) {
                    this.documentPartEvents.addAll(block.getEvents());
                    continue;
                }
                block.clarifyNumberingDefinitionsWith(this.styleDefinitions);
                this.mapToEvents(block);
                continue;
            }
            if (XMLEventHelpers.isTableStartEvent(e)) {
                delayedTableMarkup.addComponent(MarkupComponentFactory.createStartMarkupComponent(this.generalDocument.eventFactory(), e.asStartElement()));
                continue;
            }
            if (XMLEventHelpers.isTablePropertiesStartEvent(e)) {
                delayedTableMarkup.addComponent(new MarkupComponentParser().parseBlockProperties(new StartElementContext(e.asStartElement(), this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters()), this.drawingDirectionStrippableAttributes, this.tablePropertiesChangeSkippableElements));
                continue;
            }
            if (XMLEventHelpers.isTableGridStartEvent(e)) {
                parentStartElement = e.asStartElement();
                delayedTableMarkup.addComponent(MarkupComponentFactory.createStartMarkupComponent(this.generalDocument.eventFactory(), e.asStartElement()));
                continue;
            }
            if (XMLEventHelpers.isTableGridEndEvent(e)) {
                parentStartElement = null;
                delayedTableMarkup.addComponent(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                continue;
            }
            if (XMLEventHelpers.isTableRowStartEvent(e)) {
                e = this.tableRowRevisions.strip(e.asStartElement());
                parentStartElement = e.asStartElement();
                delayedTableMarkup.addComponent(MarkupComponentFactory.createStartMarkupComponent(this.generalDocument.eventFactory(), e.asStartElement()));
                continue;
            }
            if (XMLEventHelpers.isTextBodyStartEvent(e)) {
                delayedTableMarkup.addComponent(MarkupComponentFactory.createStartMarkupComponent(this.generalDocument.eventFactory(), e.asStartElement()));
                continue;
            }
            if (XMLEventHelpers.isTextBodyPropertiesStartEvent(e)) {
                delayedTableMarkup.addComponent(new MarkupComponentParser().parseBlockProperties(new StartElementContext(this.drawingBodyDirectionStrippableAttributes.strip(e.asStartElement()), this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters()), this.drawingRunPropertiesStrippableAttributes, this.emptySkippableElements));
                continue;
            }
            if (XMLEventHelpers.isTextBodyEndEvent(e)) {
                mc = MarkupComponentFactory.createEndMarkupComponent(e.asEndElement());
                if (!delayedTableMarkup.empty()) {
                    delayedTableMarkup.addComponent(mc);
                    continue;
                }
                this.addMarkupComponentToDocumentPart(mc);
                continue;
            }
            if (XMLEventHelpers.isTableRowEndEvent(e)) {
                parentStartElement = null;
                mc = MarkupComponentFactory.createEndMarkupComponent(e.asEndElement());
                if (!delayedTableMarkup.empty()) {
                    delayedTableMarkup.addComponent(mc);
                    continue;
                }
                this.addMarkupComponentToDocumentPart(mc);
                continue;
            }
            if (XMLEventHelpers.isTableEndEvent(e)) {
                if (!delayedTableMarkup.empty()) {
                    iterator = delayedTableMarkup.componentsIteratorAtLastWith("tbl");
                    if (iterator.hasNext()) {
                        delayedTableMarkup.removeComponentsWith(iterator);
                        continue;
                    }
                    this.addMarkupToDocumentPart(delayedTableMarkup);
                    delayedTableMarkup.removeComponents();
                    this.addMarkupComponentToDocumentPart(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                    continue;
                }
                this.addMarkupComponentToDocumentPart(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                continue;
            }
            if (e.isStartElement() && PowerpointStyleDefinitions.NAMES.contains(e.asStartElement().getName().getLocalPart())) {
                PowerpointStyleDefinitionsReader reader = new PowerpointStyleDefinitionsReader(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.eventReader, e.asStartElement(), e.asStartElement().getName().getLocalPart());
                PowerpointStyleDefinitions powerpointStyleDefinitions = new PowerpointStyleDefinitions(this.generalDocument.eventFactory());
                powerpointStyleDefinitions.readWith(reader);
                if (!delayedTableMarkup.empty()) {
                    delayedTableMarkup.add(powerpointStyleDefinitions.asMarkup());
                    continue;
                }
                this.addMarkupToDocumentPart(powerpointStyleDefinitions.asMarkup());
                continue;
            }
            if (e.isStartElement() && this.revisionPropertyChangeSkippableElements.canBeSkipped(e.asStartElement(), parentStartElement)) {
                startElementContext = new StartElementContext(e.asStartElement(), parentStartElement, this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters());
                this.revisionPropertyChangeSkippableElements.skip(startElementContext);
                continue;
            }
            if (e.isStartElement() && this.revisionPropertyTableRowInsertedSkippableElements.canBeSkipped(e.asStartElement(), parentStartElement)) {
                startElementContext = new StartElementContext(e.asStartElement(), parentStartElement, this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters());
                this.revisionPropertyTableRowInsertedSkippableElements.skip(startElementContext);
                continue;
            }
            if (e.isStartElement() && this.revisionPropertyTableRowDeletedSkippableElements.canBeSkipped(e.asStartElement(), parentStartElement)) {
                iterator = delayedTableMarkup.componentsIteratorAtLastWith("tr");
                if (iterator.hasNext()) {
                    this.revisionPropertyTableRowDeletedSkippableElements.skip(new StartElementContext(iterator.next().getEvents().get(0).asStartElement(), parentStartElement, this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters()));
                    iterator.remove();
                    delayedTableMarkup.removeComponentsWith(iterator);
                }
                parentStartElement = null;
                continue;
            }
            if (e.isStartElement() && this.bookmarkSkippableElements.canBeSkipped(e.asStartElement(), null)) {
                startElementContext = new StartElementContext(e.asStartElement(), this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters());
                this.bookmarkSkippableElements.skip(startElementContext);
                continue;
            }
            if (e.isStartElement() && this.moveToRangeSkippableElements.canBeSkipped(e.asStartElement(), null)) {
                startElementContext = new StartElementContext(e.asStartElement(), this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters());
                this.moveToRangeSkippableElements.skip(startElementContext);
                continue;
            }
            if (e.isStartElement() && this.moveFromRangeSkippableElements.canBeSkipped(e.asStartElement(), null)) {
                startElementContext = new StartElementContext(e.asStartElement(), this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters());
                this.moveFromRangeSkippableElements.skip(startElementContext);
                continue;
            }
            if (e.isStartElement() && this.moveToRangeEndSkippableElements.canBeSkipped(e.asStartElement(), null)) {
                startElementContext = new StartElementContext(e.asStartElement(), this.eventReader, this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters());
                this.moveToRangeEndSkippableElements.skip(startElementContext);
                continue;
            }
            if (!delayedTableMarkup.empty()) {
                if (delayedTableMarkup.lastComponentGeneral()) {
                    delayedTableMarkup.addToLastComponent(e);
                    continue;
                }
                delayedTableMarkup.addComponent(new MarkupComponent.General(new ArrayList<XMLEvent>(Collections.singletonList(e))));
                continue;
            }
            if (XMLEventHelpers.isSectionPropertiesStartEvent(e)) {
                e = this.sectionPropertiesRevisions.strip(e.asStartElement());
            }
            this.addEventToDocumentPart(e);
        }
        if (null != mergeableBlock) {
            mergeableBlock.optimiseStyles();
            this.mapToEvents(mergeableBlock);
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private void mapToEvents(Block block) {
        List<ITextUnit> textUnits = new BlockTextUnitMapper(this.textUnitIds, this.generalDocument.eventFactory(), block).map();
        if (textUnits.isEmpty() || !this.isCurrentBlockTranslatable()) {
            this.addBlockChunksToDocumentPart(block.getChunks());
        } else {
            for (ITextUnit tu : textUnits) {
                this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
            }
        }
    }

    @Override
    protected void flushDocumentPart() {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList();
        }
        if (!this.markup.components().isEmpty()) {
            DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false);
            documentPart.setSkeleton(new MarkupSkeleton(this.markup));
            this.markup = new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>()));
            this.filterEvents.add(new Event(EventType.DOCUMENT_PART, documentPart));
        }
    }

    private void prioritiseXMLEvents(Collection<XMLEvent> deferredEvents) {
        if (!deferredEvents.isEmpty()) {
            this.prioritisedEvents.addAll(deferredEvents);
            this.eventReader = new PrioritisedXMLEventReader(new ConsumableXMLEventsReader(new XMLEventsReader(this.prioritisedEvents)), this.defaultEventReader);
        }
    }

    private void addMarkupToDocumentPart(Markup markup) {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList();
        }
        this.markup.add(markup);
    }

    private void addMarkupComponentToDocumentPart(MarkupComponent markupComponent) {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList();
        }
        this.markup.addComponent(markupComponent);
    }

    protected void addBlockChunksToDocumentPart(List<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            if (chunk instanceof Block.Markup) {
                for (MarkupComponent markupComponent : ((Block.Markup)chunk).components()) {
                    this.addMarkupComponentToDocumentPart(markupComponent);
                }
                continue;
            }
            this.documentPartEvents.addAll(chunk.getEvents());
        }
    }

    @Override
    public boolean hasNextEvent() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

