/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ColorScheme;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PresetColorValues;

interface Theme {
    public String rgbColorValueFor(int var1);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements Theme {
        private final PresetColorValues presetColorValues;
        private ColorScheme colorScheme;
        private MarkupBuilder markupBuilder;

        Default(PresetColorValues presetColorValues) {
            this.presetColorValues = presetColorValues;
        }

        @Override
        public String rgbColorValueFor(int index) {
            return this.colorScheme().colorValueFor(index);
        }

        private ColorScheme colorScheme() {
            if (null == this.colorScheme) {
                this.colorScheme = new ColorScheme.Empty();
            }
            return this.colorScheme;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.markupBuilder = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>()));
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isStartElement() && "clrScheme".equals(e.asStartElement().getName().getLocalPart())) {
                    this.colorScheme = new ColorScheme.Default(this.presetColorValues, e.asStartElement());
                    this.colorScheme.readWith(reader);
                    this.markupBuilder.add(this.colorScheme.asMarkup());
                    continue;
                }
                this.markupBuilder.add(e);
            }
        }

        @Override
        public Markup asMarkup() {
            Markup markup = null == this.markupBuilder ? new Markup.Empty() : this.markupBuilder.build();
            return markup;
        }
    }

    public static final class Empty
    implements Theme {
        private static final String EMPTY = "";

        @Override
        public String rgbColorValueFor(int index) {
            return EMPTY;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

