/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface WorkbookFragments {
    public static final String SHEET = "sheet";
    public static final QName SHEET_NAME = new QName("name");

    public List<XMLEvent> events();

    public boolean date1904();

    public List<String> worksheetPartNames();

    public String localisedWorksheetNameFor(String var1);

    public String localisedWorksheetNameFor(int var1);

    public boolean worksheetPartNameHiddenFor(String var1);

    public boolean localisedWorksheetNameHiddenFor(String var1);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public static final class Default
    implements WorkbookFragments {
        private static final String EMPTY = "";
        private static final String WORKSHEET_NAME_HAS_NOT_BEEN_FOUND = "The provided worksheet name has not been found: ";
        private static final String WORKBOOK = "workbook";
        private static final String WORKBOOK_PR = "workbookPr";
        private static final QName DATE_1904 = new QName("date1904");
        private static final QName SHEET_STATE = new QName("state");
        private static final String ID = "id";
        private static final String HIDDEN = "hidden";
        private final ConditionalParameters conditionalParameters;
        private final Relationships relationships;
        private final List<XMLEvent> events;
        private final List<String> worksheetNames;
        private final Map<String, String> localisedWorksheetNames;
        private final Set<String> hiddenWorksheets;
        private boolean date1904;
        private QName sheet;
        private QName id;

        Default(ConditionalParameters conditionalParameters, Relationships relationships) {
            this(conditionalParameters, relationships, new ArrayList<XMLEvent>(), new ArrayList<String>(), new HashMap<String, String>(), new HashSet<String>());
        }

        Default(ConditionalParameters conditionalParameters, Relationships relationships, List<XMLEvent> events, List<String> worksheetNames, Map<String, String> localisedWorksheetNames, Set<String> hiddenWorksheets) {
            this.conditionalParameters = conditionalParameters;
            this.relationships = relationships;
            this.events = events;
            this.worksheetNames = worksheetNames;
            this.localisedWorksheetNames = localisedWorksheetNames;
            this.hiddenWorksheets = hiddenWorksheets;
        }

        @Override
        public List<XMLEvent> events() {
            return this.events;
        }

        @Override
        public boolean date1904() {
            return this.date1904;
        }

        @Override
        public List<String> worksheetPartNames() {
            return this.worksheetNames;
        }

        @Override
        public String localisedWorksheetNameFor(String worksheetPartName) {
            if (!this.localisedWorksheetNames.containsKey(worksheetPartName)) {
                throw new IllegalStateException(WORKSHEET_NAME_HAS_NOT_BEEN_FOUND.concat(worksheetPartName));
            }
            return this.localisedWorksheetNames.get(worksheetPartName);
        }

        @Override
        public String localisedWorksheetNameFor(int worksheetNumber) {
            if (this.worksheetNames.size() < worksheetNumber) {
                return EMPTY;
            }
            String name = this.worksheetNames.get(worksheetNumber - 1);
            return null == name ? EMPTY : this.localisedWorksheetNames.get(name);
        }

        @Override
        public boolean worksheetPartNameHiddenFor(String worksheetPartName) {
            if (!this.worksheetNames.contains(worksheetPartName)) {
                return false;
            }
            return this.hiddenWorksheets.contains(worksheetPartName);
        }

        @Override
        public boolean localisedWorksheetNameHiddenFor(String localisedWorksheetName) {
            if (this.localisedWorksheetNames.entrySet().stream().noneMatch(e -> ((String)e.getValue()).equals(localisedWorksheetName))) {
                return false;
            }
            List worksheetNames = this.localisedWorksheetNames.entrySet().stream().filter(e -> ((String)e.getValue()).equals(localisedWorksheetName)).map(e -> (String)e.getKey()).collect(Collectors.toList());
            return this.hiddenWorksheets.contains(worksheetNames.get(0));
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                this.events.add(e);
                if (!e.isStartElement()) continue;
                StartElement el = e.asStartElement();
                if (WORKBOOK.equals(el.getName().getLocalPart())) {
                    this.qualifyNames(el);
                    continue;
                }
                if (WORKBOOK_PR.equals(el.getName().getLocalPart())) {
                    this.date1904 = XMLEventHelpers.getBooleanAttributeValue(el, DATE_1904, false);
                    continue;
                }
                if (!el.getName().equals(this.sheet)) continue;
                if (null == this.id) {
                    this.qualifyIdName(el);
                }
                String worksheetName = this.relationshipTargetFor(el.getAttributeByName(this.id).getValue());
                this.worksheetNames.add(worksheetName);
                this.localisedWorksheetNames.put(worksheetName, el.getAttributeByName(SHEET_NAME).getValue());
                String state = XMLEventHelpers.getAttributeValue(el, SHEET_STATE);
                if (this.conditionalParameters.getTranslateExcelHidden() || !HIDDEN.equals(state)) continue;
                this.hiddenWorksheets.add(worksheetName);
            }
        }

        private void qualifyNames(StartElement startElement) {
            this.sheet = new QName(startElement.getName().getNamespaceURI(), WorkbookFragments.SHEET, startElement.getName().getPrefix());
            this.qualifyIdName(startElement);
        }

        private void qualifyIdName(StartElement startElement) {
            String namespaceUri = startElement.getNamespaceURI("r");
            if (null == namespaceUri) {
                return;
            }
            this.id = new QName(namespaceUri, ID, "r");
        }

        private String relationshipTargetFor(String id) {
            Iterator<Relationship> ri = this.relationships.with(id).iterator();
            if (!ri.hasNext()) {
                throw new OkapiBadFilterInputException(String.format("%s: %s", "Unexpected number of relationships", id));
            }
            return ri.next().target();
        }
    }
}

