/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.XMLEventsReader;
import net.sf.okapi.filters.openxml.Cell;
import net.sf.okapi.filters.openxml.CellType;
import net.sf.okapi.filters.openxml.Cells;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.SharedStringsFragments;
import net.sf.okapi.filters.openxml.SourceAndTargetColumns;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.WorksheetFragments;

interface Worksheet {
    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements Worksheet {
        private static final String SHEET_VIEW = "sheetView";
        private static final String SHEET_DATA = "sheetData";
        private static final String ROW = "row";
        private static final String SHEET_CALC_PR = "sheetCalcPr";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final SharedStringsFragments sharedStringsFragments;
        private final boolean date1904;
        private final Cells cells;
        private final StyleDefinitions styleDefinitions;
        private final String name;
        private final WorksheetFragments fragments;
        private MarkupBuilder markupBuilder;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, SharedStringsFragments sharedStringsFragments, boolean date1904, Cells cells, StyleDefinitions styleDefinitions, String name, WorksheetFragments fragments) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.sharedStringsFragments = sharedStringsFragments;
            this.date1904 = date1904;
            this.cells = cells;
            this.styleDefinitions = styleDefinitions;
            this.name = name;
            this.fragments = fragments;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.fragments.readWith(reader);
            Set<Integer> initialExcludedRows = this.conditionalParameters.worksheetConfigurations().excludedRowsFor(this.name);
            Set<Integer> metadataRows = this.conditionalParameters.worksheetConfigurations().metadataRowsFor(this.name);
            HashSet<Integer> excludedRows = new HashSet<Integer>(initialExcludedRows.size() + metadataRows.size());
            excludedRows.addAll(initialExcludedRows);
            excludedRows.addAll(this.fragments.hiddenRows());
            excludedRows.addAll(metadataRows);
            SourceAndTargetColumns sourceAndTargetColumns = this.conditionalParameters.worksheetConfigurations().sourceAndTargetColumnsFor(this.name);
            Set<String> initialExcludedColumns = this.conditionalParameters.worksheetConfigurations().excludedColumnsFor(this.name);
            Set<String> metadataColumns = this.conditionalParameters.worksheetConfigurations().metadataColumnsFor(this.name);
            HashSet<String> excludedColumns = new HashSet<String>(sourceAndTargetColumns.source().size() + initialExcludedColumns.size() + this.fragments.hiddenColumns().size() + metadataColumns.size());
            excludedColumns.addAll(sourceAndTargetColumns.source());
            excludedColumns.addAll(initialExcludedColumns);
            excludedColumns.addAll(this.fragments.hiddenColumns());
            excludedColumns.addAll(metadataColumns);
            this.markupBuilder = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>()));
            XMLEventsReader eventsReader = new XMLEventsReader(this.fragments.events());
            boolean inSheetData = false;
            Cells.Sorted cellsInRow = new Cells.Sorted(this.conditionalParameters, sourceAndTargetColumns, excludedRows);
            boolean columnsWithStringFunctionValuesPresent = false;
            while (eventsReader.hasNext()) {
                XMLEvent e = eventsReader.nextEvent();
                if (e.isStartElement()) {
                    StartElement se = e.asStartElement();
                    if (SHEET_VIEW.equals(se.getName().getLocalPart())) {
                        this.markupBuilder.add(new MarkupComponent.Start(this.eventFactory, se));
                        continue;
                    }
                    if (SHEET_DATA.equals(se.getName().getLocalPart())) {
                        inSheetData = true;
                    } else {
                        if ("c".equals(se.getName().getLocalPart())) {
                            Cell.Default cell = new Cell.Default(this.conditionalParameters, this.eventFactory, this.sharedStringsFragments, this.date1904, this.styleDefinitions, excludedRows, excludedColumns, metadataRows, metadataColumns, this.fragments.cellReferencesRanges(), this.name, se);
                            cell.readWith(eventsReader);
                            cellsInRow.add(cell);
                            if (columnsWithStringFunctionValuesPresent || CellType.STRING != cell.type()) continue;
                            columnsWithStringFunctionValuesPresent = true;
                            continue;
                        }
                        if (SHEET_CALC_PR.equals(se.getName().getLocalPart())) {
                            continue;
                        }
                    }
                } else if (e.isEndElement()) {
                    EndElement ee = e.asEndElement();
                    if (SHEET_VIEW.equals(ee.getName().getLocalPart())) {
                        this.markupBuilder.add(new MarkupComponent.End(ee));
                        continue;
                    }
                    if (SHEET_DATA.equals(ee.getName().getLocalPart())) {
                        this.markupBuilder.add(ee);
                        if (columnsWithStringFunctionValuesPresent) {
                            this.markupBuilder.addAll(this.sheetCalcPrEventsAfter(ee));
                        }
                        inSheetData = false;
                        continue;
                    }
                    if (inSheetData && ROW.equals(ee.getName().getLocalPart())) {
                        this.cells.add(cellsInRow);
                        this.markupBuilder.add(cellsInRow.asMarkup());
                        cellsInRow.clear();
                    } else if (SHEET_CALC_PR.equals(ee.getName().getLocalPart())) {
                        continue;
                    }
                } else if (e.isCharacters() && inSheetData) continue;
                this.markupBuilder.add(e);
            }
        }

        private List<XMLEvent> sheetCalcPrEventsAfter(EndElement endElement) {
            List<Attribute> attributes = Collections.singletonList(this.eventFactory.createAttribute(new QName("fullCalcOnLoad"), "true"));
            return Arrays.asList(this.eventFactory.createStartElement(endElement.getName().getPrefix(), endElement.getName().getNamespaceURI(), SHEET_CALC_PR, attributes.iterator(), endElement.getNamespaces()), this.eventFactory.createEndElement(endElement.getName().getPrefix(), endElement.getName().getNamespaceURI(), SHEET_CALC_PR, endElement.getNamespaces()));
        }

        @Override
        public Markup asMarkup() {
            return this.markupBuilder.build();
        }
    }
}

