/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public interface WorksheetConfiguration {
    public boolean matches(String var1);

    public Set<String> sourceColumns();

    public Set<String> targetColumns();

    public Set<Integer> excludedRows();

    public Set<String> excludedColumns();

    public Set<Integer> metadataRows();

    public Set<String> metadataColumns();

    public <T> T writtenTo(Output<T> var1);

    public static interface Output<T> {
        public T writtenWith(Pattern var1, Set<String> var2, Set<String> var3, Set<Integer> var4, Set<String> var5, Set<Integer> var6, Set<String> var7);
    }

    public static final class Default
    implements WorksheetConfiguration {
        private final Pattern namePattern;
        private final Set<String> sourceColumns;
        private final Set<String> targetColumns;
        private final Set<Integer> excludedRows;
        private final Set<String> excludedColumns;
        private final Set<Integer> metadataRows;
        private final Set<String> metadataColumns;

        public Default(String nameString, List<String> sourceColumns, List<String> targetColumns, List<Integer> excludedRows, List<String> excludedColumns, List<Integer> metadataRows, List<String> metadataColumns) {
            this(nameString, new LinkedHashSet<String>(sourceColumns), new LinkedHashSet<String>(targetColumns), new LinkedHashSet<Integer>(excludedRows), new LinkedHashSet<String>(excludedColumns), new LinkedHashSet<Integer>(metadataRows), new LinkedHashSet<String>(metadataColumns));
        }

        Default(String nameString, Set<String> sourceColumns, Set<String> targetColumns, Set<Integer> excludedRows, Set<String> excludedColumns, Set<Integer> metadataRows, Set<String> metadataColumns) {
            this(Pattern.compile(nameString), sourceColumns, targetColumns, excludedRows, excludedColumns, metadataRows, metadataColumns);
        }

        Default(Pattern namePattern, Set<String> sourceColumns, Set<String> targetColumns, Set<Integer> excludedRows, Set<String> excludedColumns, Set<Integer> metadataRows, Set<String> metadataColumns) {
            this.namePattern = namePattern;
            this.sourceColumns = sourceColumns;
            this.targetColumns = targetColumns;
            this.excludedRows = excludedRows;
            this.excludedColumns = excludedColumns;
            this.metadataRows = metadataRows;
            this.metadataColumns = metadataColumns;
        }

        @Override
        public boolean matches(String worksheetName) {
            return this.namePattern.matcher(worksheetName).matches();
        }

        @Override
        public Set<String> sourceColumns() {
            return this.sourceColumns;
        }

        @Override
        public Set<String> targetColumns() {
            return this.targetColumns;
        }

        @Override
        public Set<Integer> excludedRows() {
            return this.excludedRows;
        }

        @Override
        public Set<String> excludedColumns() {
            return this.excludedColumns;
        }

        @Override
        public Set<Integer> metadataRows() {
            return this.metadataRows;
        }

        @Override
        public Set<String> metadataColumns() {
            return this.metadataColumns;
        }

        @Override
        public <T> T writtenTo(Output<T> output) {
            return output.writtenWith(this.namePattern, this.sourceColumns, this.targetColumns, this.excludedRows, this.excludedColumns, this.metadataRows, this.metadataColumns);
        }
    }
}

