/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.pensieve;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.DefaultParameters;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.pensieve.PensieveFilterWriter;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.TmSeekerFactory;

@UsingParameters
public class PensieveFilter
implements IFilter {
    private static final String MIMETYPE = "application/x-pensieve-tm";
    private Iterator<TranslationUnit> iterator;
    private int state;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private String docName;
    private EncoderManager encoderManager;
    private RawDocument input;
    private DefaultParameters params = new DefaultParameters();

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        this.state = 0;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new PensieveFilterWriter();
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "Pensieve TM", "Configuration for Pensieve translation memories.", null, ".pentm;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
        }
        return this.encoderManager;
    }

    @Override
    public String getDisplayName() {
        return "Pensieve TM Filter";
    }

    @Override
    public String getMimeType() {
        return MIMETYPE;
    }

    @Override
    public String getName() {
        return "okf_pensieve";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.state > 0;
    }

    @Override
    public Event next() {
        switch (this.state) {
            case 1: {
                StartDocument sd = new StartDocument("sdID");
                sd.setName(this.docName);
                sd.setEncoding("UTF-8", false);
                sd.setLocale(this.srcLoc);
                sd.setFilterId(this.getName());
                sd.setFilterParameters(this.getParameters());
                sd.setFilterWriter(this.createFilterWriter());
                sd.setType(MIMETYPE);
                sd.setMimeType(MIMETYPE);
                sd.setMultilingual(true);
                sd.setLineBreak("\n");
                this.state = 2;
                return new Event(EventType.START_DOCUMENT, sd);
            }
            case 2: {
                String data;
                if (!this.iterator.hasNext()) {
                    Ending ed = new Ending("edID");
                    this.state = 0;
                    return new Event(EventType.END_DOCUMENT, ed);
                }
                TranslationUnit item = this.iterator.next();
                TextUnit tu = new TextUnit((String)item.getMetadata().get((Object)MetadataType.ID));
                tu.setName(tu.getId());
                tu.setSourceContent(item.getSource().getContent());
                if (!item.isTargetEmpty()) {
                    TextContainer tc = tu.createTarget(this.trgLoc, false, 0);
                    tc.setContent(item.getTarget().getContent());
                }
                if (!Util.isEmpty(data = (String)item.getMetadata().get((Object)MetadataType.TYPE))) {
                    tu.setType(data);
                }
                if (!Util.isEmpty(data = (String)item.getMetadata().get((Object)MetadataType.GROUP_NAME))) {
                    tu.setProperty(new Property("Txt::GroupName", data, false, Property.FILTER_AND_DISPLAY));
                }
                if (!Util.isEmpty(data = (String)item.getMetadata().get((Object)MetadataType.FILE_NAME))) {
                    tu.setProperty(new Property("Txt::FileName", data, false, Property.FILTER_AND_DISPLAY));
                }
                return new Event(EventType.TEXT_UNIT, tu);
            }
        }
        return null;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        this.srcLoc = input.getSourceLocale();
        this.trgLoc = input.getTargetLocale();
        if (input.getInputURI() == null) {
            throw new OkapiBadFilterInputException("Only input URI is supported for this filter.");
        }
        this.docName = Util.getDirectoryName(input.getInputURI().getPath());
        ITmSeeker seeker = TmSeekerFactory.createFileBasedTmSeeker(this.docName);
        this.iterator = ((Iterable)((Object)seeker)).iterator();
        this.state = 1;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (DefaultParameters)params;
    }
}

