/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.subtitles;

import net.sf.okapi.common.IResource;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.filters.subtitles.CaptionAnnotation;
import net.sf.okapi.filters.subtitles.SubtitleFilter;

public class SubtitleEventBuilder
extends EventBuilder {
    private SubtitleFilter filter;

    public SubtitleEventBuilder(String rootId, IFilter filter) {
        super(rootId, filter);
        this.setMimeType(filter.getMimeType());
        this.filter = (SubtitleFilter)filter;
    }

    private void addMaxWidth(IResource resource) {
        if (this.filter.getMaxChar() * this.filter.getMaxLine() != 0) {
            CaptionAnnotation annotation = resource.getAnnotation(CaptionAnnotation.class);
            int numCaptions = 0;
            if (annotation != null) {
                numCaptions = annotation.getSize();
                annotation.setMaxChar(this.filter.getMaxChar());
                annotation.setMaxLine(this.filter.getMaxLine());
            }
            Property maxWidth = new Property("maxwidth", Integer.toString(this.filter.getMaxChar() * this.filter.getMaxLine() * numCaptions), Property.DISPLAY_ONLY);
            resource.setProperty(maxWidth);
            Property sizeUnit = new Property("size-unit", "char", Property.DISPLAY_ONLY);
            resource.setProperty(sizeUnit);
        }
    }

    @Override
    protected ITextUnit postProcessTextUnit(ITextUnit textUnit) {
        this.addMaxWidth(textUnit);
        return textUnit;
    }
}

