/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.vtt;

import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.subtitles.CaptionAnnotation;
import net.sf.okapi.filters.subtitles.SplitCaption;
import net.sf.okapi.filters.vtt.VTTFilter;
import net.sf.okapi.filters.vtt.VTTParameters;
import net.sf.okapi.filters.vtt.VTTSkeletonPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VTTSkeletonWriter
extends GenericSkeletonWriter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String newLineType;
    private DateTimeFormatter formatter;
    private VTTParameters params;

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, EncoderManager encoderManager, StartDocument resource) {
        this.newLineType = resource.getLineBreak();
        this.params = (VTTParameters)resource.getFilterParameters();
        this.formatter = VTTFilter.getDateTimeFormatter(this.params.getTimeFormat());
        return super.processStartDocument(outputLocale, outputEncoding, encoderManager, resource);
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        CaptionAnnotation annotation = resource.getAnnotation(CaptionAnnotation.class);
        SplitCaption captions = SplitCaption.splitCaption(super.getContent(resource, this.outputLoc, EncoderContext.TEXT), annotation.getSize(), annotation.getMaxLine(), annotation.getMaxChar(), false, false, !this.params.getSplitWords());
        Iterator<ArrayList<String>> captionIterator = captions.iterator();
        Iterator<String> headerIterator = this.normalizeCaptionTimes(annotation).iterator();
        StringBuilder tmp = new StringBuilder();
        for (GenericSkeletonPart part : ((GenericSkeleton)resource.getSkeleton()).getParts()) {
            VTTSkeletonPart vttPart = (VTTSkeletonPart)part;
            if (vttPart.isHeader()) {
                tmp.append(headerIterator.next());
                tmp.append(this.getCueSettings(vttPart));
                tmp.append(this.newLineType);
                tmp.append(this.mergeCaption(captionIterator.next()));
                continue;
            }
            if (!vttPart.isEmpty()) {
                tmp.append((CharSequence)vttPart.getData());
            }
            tmp.append(this.newLineType);
        }
        return tmp.toString();
    }

    private String mergeCaption(ArrayList<String> caption) {
        StringBuilder tmp = new StringBuilder();
        for (String line : caption) {
            tmp.append(line);
            tmp.append(this.newLineType);
        }
        return tmp.toString();
    }

    private String getCueSettings(VTTSkeletonPart part) {
        if (!this.params.getCueSettings().isEmpty()) {
            return " " + this.params.getCueSettings();
        }
        if (this.params.getDiscardCues()) {
            return "";
        }
        Matcher matcher = VTTFilter.HEADER_PATTERN.matcher(part.getData());
        if (!matcher.find() || matcher.group(4).isEmpty()) {
            return "";
        }
        return " " + matcher.group(4);
    }

    private ArrayList<String> normalizeCaptionTimes(CaptionAnnotation annotation) {
        ArrayList<String> normalizedCaptionTimes = new ArrayList<String>();
        LocalTime beginTime = annotation.getFirst().getBeginTime();
        LocalTime endTime = annotation.getLast().getEndTime();
        if (this.params.getKeepTimecodes() || beginTime == null || endTime == null) {
            for (CaptionAnnotation.CaptionTiming timing : annotation) {
                normalizedCaptionTimes.add(this.formatAsHeader(timing.getBeginTime(), timing.getEndTime()));
            }
            return normalizedCaptionTimes;
        }
        Duration duration = Duration.between(beginTime, endTime);
        duration = duration.dividedBy(annotation.getSize());
        LocalTime prevTime = beginTime;
        for (CaptionAnnotation.CaptionTiming timing : annotation) {
            LocalTime nextTime = prevTime.plus(duration);
            normalizedCaptionTimes.add(this.formatAsHeader(prevTime, nextTime));
            prevTime = nextTime;
        }
        return normalizedCaptionTimes;
    }

    private String formatAsHeader(LocalTime begin, LocalTime end) {
        return this.formatter.format(begin) + " --> " + this.formatter.format(end);
    }
}

