/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.wiki;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;
import net.sf.okapi.filters.wiki.WikiFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

public class Parameters
extends BaseParameters
implements ISimplifierRulesParameters {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static LoadSettings settings = LoadSettings.builder().setAllowDuplicateKeys(true).setLabel("Okapi Doxygen Filter").build();
    private static DumpSettings dumpSettings = DumpSettings.builder().build();
    public static final String WIKI_PARAMETERS = "wikiConfiguration.yml";
    private Map<String, Object> config;
    private IdentityHashMap<Pattern, Pattern> customCodes;
    private boolean preserveWhitespace = false;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.config = (Map)new Load(settings).loadFromInputStream(WikiFilter.class.getResourceAsStream(WIKI_PARAMETERS));
        this.initialize();
        this.setSimplifierRules(null);
    }

    private void initialize() {
        Object whitespace = this.config.get("preserve_whitespace");
        if (whitespace != null) {
            this.preserveWhitespace = (Boolean)whitespace;
        }
        this.customCodes = new IdentityHashMap();
        Object custom = this.config.get("custom_codes");
        if (custom != null) {
            for (HashMap c : (ArrayList)custom) {
                try {
                    Object phRegex = c.get("pattern");
                    if (phRegex != null) {
                        this.customCodes.put(Pattern.compile((String)phRegex), null);
                        continue;
                    }
                    Object startRegex = c.get("start_pattern");
                    Object endRegex = c.get("end_pattern");
                    if (startRegex == null || endRegex == null) continue;
                    this.customCodes.put(Pattern.compile((String)startRegex), Pattern.compile((String)endRegex));
                }
                catch (PatternSyntaxException ex) {
                    this.LOGGER.warn("Regex pattern was invalid: {}", (Object)ex.getPattern());
                }
                catch (NullPointerException ex) {
                    this.LOGGER.warn("User-supplied custom regex for the Wiki filter was null. Make sure to enclose it in double-quotes in the config file.");
                }
            }
        }
    }

    @Override
    public String toString() {
        Dump dump = new Dump(dumpSettings);
        return dump.dumpToString(this.config);
    }

    @Override
    public void fromString(String data) {
        this.config = (Map)new Load(settings).loadFromString(data);
        this.initialize();
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public IdentityHashMap<Pattern, Pattern> getCustomCodePatterns() {
        return this.customCodes;
    }

    @Override
    public boolean getBoolean(String name) {
        return false;
    }

    @Override
    public void setBoolean(String name, boolean value) {
    }

    @Override
    public String getString(String name) {
        return null;
    }

    @Override
    public void setString(String name, String value) {
    }

    @Override
    public int getInteger(String name) {
        return 0;
    }

    @Override
    public void setInteger(String name, int value) {
    }

    @Override
    public String getSimplifierRules() {
        String sr = (String)this.config.get("simplifierRules");
        return sr;
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.config.put("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

