/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini.rainbowkit;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.xini.InlineCodeTransformer;
import net.sf.okapi.filters.xini.jaxb.Element;
import net.sf.okapi.filters.xini.jaxb.Field;
import net.sf.okapi.filters.xini.jaxb.Page;
import net.sf.okapi.filters.xini.jaxb.Seg;
import net.sf.okapi.filters.xini.jaxb.Xini;
import net.sf.okapi.filters.xini.rainbowkit.XINIRainbowkitWriter;

public class XINIRainbowkitReader {
    private Xini xini;
    private InputStream xiniStream;
    private InlineCodeTransformer transformer = new InlineCodeTransformer();
    private LocaleId targetLocale;

    public void open(RawDocument input) {
        this.xiniStream = input.getStream();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)Xini.class.getPackage().getName());
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement jaxbXini = (JAXBElement)u.unmarshal(this.xiniStream);
            this.xini = (Xini)jaxbXini.getValue();
        }
        catch (JAXBException e) {
            throw new OkapiException(e);
        }
    }

    public void close() {
        try {
            if (this.xiniStream != null) {
                this.xiniStream.close();
                this.xiniStream = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public LinkedList<Event> getFilterEvents(String relDocName) {
        LinkedList<Event> events = new LinkedList<Event>();
        for (Page page : this.xini.getMain().getPage()) {
            if (!page.getPageName().equals(relDocName)) continue;
            events.addAll(this.processPage(page));
            break;
        }
        return events;
    }

    private LinkedList<Event> processPage(Page page) {
        LinkedList<Event> events = new LinkedList<Event>();
        String startDocId = "" + page.getPageID();
        StartDocument startDoc = new StartDocument(startDocId);
        startDoc.setName(page.getPageName());
        startDoc.setFilterWriter(new XINIRainbowkitWriter());
        startDoc.setType("text/x-xini");
        startDoc.setMimeType("text/x-xini");
        startDoc.setMultilingual(false);
        events.add(new Event(EventType.START_DOCUMENT, startDoc));
        for (Element element : page.getElements().getElement()) {
            events.addAll(this.processElement(element));
        }
        Ending ending = new Ending(page.getPageID() + "end");
        events.add(new Event(EventType.END_DOCUMENT, ending));
        return events;
    }

    private LinkedList<Event> processElement(Element element) {
        LinkedList<Event> events = new LinkedList<Event>();
        Element.ElementContent elContent = element.getElementContent();
        if (elContent.getFields() != null) {
            for (Field field : elContent.getFields().getField()) {
                events.addAll(this.processField(field));
            }
        } else if (elContent.getTable() != null || elContent.getINITable() != null) {
            // empty if block
        }
        return events;
    }

    private LinkedList<Event> processField(Field field) {
        LinkedList<Event> events = new LinkedList<Event>();
        TextUnit tu = new TextUnit(field.getExternalID());
        TextContainer tc = new TextContainer();
        String emptySegsFlags = field.getEmptySegmentsFlags();
        if (emptySegsFlags == null) {
            int segIndex = 0;
            for (Seg xiniSeg : field.getSeg()) {
                TextFragment tf = new TextFragment(this.processSegment(xiniSeg));
                boolean collapseIfPreviousEmpty = segIndex == 0;
                tc.getSegments().append(tf, collapseIfPreviousEmpty);
                ++segIndex;
            }
        } else {
            int nonEmptySegIndex = 0;
            for (int segIndex = 0; segIndex < emptySegsFlags.length(); ++segIndex) {
                char empty = emptySegsFlags.charAt(segIndex);
                if (empty == '0') {
                    Seg xiniSeg = field.getSeg().get(nonEmptySegIndex);
                    ++nonEmptySegIndex;
                    TextFragment tf = new TextFragment(this.processSegment(xiniSeg));
                    boolean collapseIfPreviousEmpty = segIndex == 0;
                    tc.getSegments().append(tf, collapseIfPreviousEmpty);
                    continue;
                }
                tc.getSegments().append(new Segment(""));
            }
        }
        tu.setSource(tc);
        tu.setTarget(this.targetLocale, tc);
        tu.setName(field.getLabel());
        events.add(new Event(EventType.TEXT_UNIT, tu));
        return events;
    }

    private TextFragment processSegment(Seg xiniSeg) {
        TextFragment fragment = new TextFragment(){

            @Override
            public boolean isEmpty() {
                return false;
            }
        };
        String leadingSpacer = xiniSeg.getLeadingSpacer();
        if (leadingSpacer != null) {
            fragment.append(leadingSpacer);
        }
        fragment.append(this.transformer.serializeTextPartsForTKit(xiniSeg.getContent()), true);
        if (xiniSeg.getTrailingSpacer() != null) {
            fragment.append(xiniSeg.getTrailingSpacer());
        }
        return fragment;
    }

    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }
}

