/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2.util;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.TargetState;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.slf4j.LoggerFactory;

public class PropertiesMapper {
    private static final Pattern EXTENDED_ATTRIBUTE_KEY_PATTERN = Pattern.compile("^" + Pattern.quote("extendedAttribute.") + "(.*)" + Pattern.quote("==") + "\\{(.*?)\\}(.*)$");

    public static void setStartXliffProperties(StartXliffData xliffStartXliff, StartDocument okapiStartDocument) {
        PropertiesMapper.setProperty("srcLang", xliffStartXliff.getSourceLanguage(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setProperty("trgLang", xliffStartXliff.getTargetLanguage(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setProperty("version", xliffStartXliff.getVersion(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartXliff, okapiStartDocument);
    }

    public static void setStartXliffProperties(StartDocument okapiStartDocument, StartXliffData xliffStartXliff) {
        PropertiesMapper.setExtendedAttributes(okapiStartDocument, (IWithExtAttributes)xliffStartXliff);
    }

    public static void setStartFileProperties(StartFileData xliffStartFileData, StartSubDocument okapiStartSubDoc) {
        PropertiesMapper.setProperty("srcDir", xliffStartFileData.getSourceDir(), (IWithProperties)okapiStartSubDoc);
        PropertiesMapper.setProperty("trgDir", xliffStartFileData.getTargetDir(), (IWithProperties)okapiStartSubDoc);
        PropertiesMapper.setProperty("canResegment", xliffStartFileData.getCanResegment(), (IWithProperties)okapiStartSubDoc);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartFileData, okapiStartSubDoc);
    }

    public static void setStartFileProperties(StartSubDocument okapiStartSubDoc, StartFileData xliffStartFileData) {
        xliffStartFileData.setSourceDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("srcDir", okapiStartSubDoc)));
        xliffStartFileData.setTargetDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("trgDir", okapiStartSubDoc)));
        xliffStartFileData.setCanResegment(PropertiesMapper.stringToBoolean(PropertiesMapper.getProperty("canResegment", okapiStartSubDoc)));
        PropertiesMapper.setExtendedAttributes(okapiStartSubDoc, (IWithExtAttributes)xliffStartFileData);
    }

    public static void setGroupProperties(StartGroupData xliffStartGroupData, StartGroup okapiStartGroup) {
        PropertiesMapper.setProperty("canResegment", xliffStartGroupData.getCanResegment(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setProperty("srcDir", xliffStartGroupData.getSourceDir(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setProperty("trgDir", xliffStartGroupData.getTargetDir(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartGroupData, okapiStartGroup);
    }

    public static void setGroupProperties(StartGroup okapiStartGroup, StartGroupData xliffStartGroupData) {
        String canResegment = PropertiesMapper.getProperty("canResegment", okapiStartGroup);
        if (canResegment != null) {
            xliffStartGroupData.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
        }
        xliffStartGroupData.setSourceDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("srcDir", okapiStartGroup)));
        xliffStartGroupData.setTargetDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("trgDir", okapiStartGroup)));
        xliffStartGroupData.setType(okapiStartGroup.getType());
        PropertiesMapper.setExtendedAttributes(okapiStartGroup, (IWithExtAttributes)xliffStartGroupData);
        xliffStartGroupData.setName(okapiStartGroup.getName());
    }

    public static void setTextUnitProperties(Unit unit, ITextUnit tu) {
        PropertiesMapper.setProperty("name", unit.getName(), (IWithProperties)tu);
        PropertiesMapper.setProperty("canResegment", unit.getCanResegment(), (IWithProperties)tu);
        PropertiesMapper.setProperty("type", unit.getType(), (IWithProperties)tu);
        PropertiesMapper.setProperty("srcDir", unit.getSourceDir(), (IWithProperties)tu);
        PropertiesMapper.setProperty("trgDir", unit.getTargetDir(), (IWithProperties)tu);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)unit, tu);
    }

    public static void setTextUnitProperties(ITextUnit okapiTextUnit, Unit xliffTextUnit) {
        String targetDirection;
        String sourceDirection;
        String canResegment = PropertiesMapper.getProperty("canResegment", okapiTextUnit);
        if (canResegment != null) {
            xliffTextUnit.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
        }
        if ((sourceDirection = PropertiesMapper.getProperty("srcDir", okapiTextUnit)) != null) {
            xliffTextUnit.setTargetDir(PropertiesMapper.stringToDirection(sourceDirection));
        }
        if ((targetDirection = PropertiesMapper.getProperty("trgDir", okapiTextUnit)) != null) {
            xliffTextUnit.setSourceDir(PropertiesMapper.stringToDirection(targetDirection));
        }
        PropertiesMapper.setExtendedAttributes(okapiTextUnit, (IWithExtAttributes)xliffTextUnit);
    }

    public static void setPartProperties(Part xliffPart, TextPart okapiPart) {
        if (xliffPart.isSegment()) {
            Segment xliffSegment = (Segment)xliffPart;
            PropertiesMapper.setProperty("canResegment", xliffSegment.getCanResegment(), (IWithProperties)okapiPart);
            PropertiesMapper.setProperty("state", xliffSegment.getState(), (IWithProperties)okapiPart);
            if (xliffSegment.getSubState() != null) {
                PropertiesMapper.setProperty("subState", xliffSegment.getSubState(), (IWithProperties)okapiPart);
            }
        }
    }

    public static void setPartProperties(TextPart okapiPart, Part xliffPart) {
        if (xliffPart.isSegment()) {
            String substate;
            String state;
            Segment xliffSegment = (Segment)xliffPart;
            net.sf.okapi.common.resource.Segment okapiSegment = (net.sf.okapi.common.resource.Segment)okapiPart;
            String canResegment = PropertiesMapper.getProperty("canResegment", okapiSegment);
            if (!Util.isEmpty(canResegment)) {
                xliffSegment.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
            }
            if (!Util.isEmpty(state = PropertiesMapper.getProperty("state", okapiSegment))) {
                xliffSegment.setState(PropertiesMapper.stringToTargetState(state));
            }
            if (!Util.isEmpty(substate = PropertiesMapper.getProperty("subState", okapiSegment))) {
                xliffSegment.setSubState(substate);
            }
        }
    }

    public static void setStateProperty(TextContainer okapiContainer, Part xliffPart) {
        if (xliffPart.isSegment()) {
            Segment xliffSegment = (Segment)xliffPart;
            String state = PropertiesMapper.getProperty("state", okapiContainer);
            if (!Util.isEmpty(state)) {
                xliffSegment.setState(PropertiesMapper.stringToTargetState(state));
            }
        }
    }

    public static void setCodeProperties(Code okapiCode, CTag xliff2Ctag) {
        String type;
        if (okapiCode.hasProperty("canCopy")) {
            xliff2Ctag.setCanCopy(PropertiesMapper.stringToBoolean(okapiCode.getProperty("canCopy").getValue()));
        }
        if (okapiCode.hasProperty("canDelete")) {
            xliff2Ctag.setCanDelete(PropertiesMapper.stringToBoolean(okapiCode.getProperty("canDelete").getValue()));
        }
        if (okapiCode.hasProperty("canReorder")) {
            xliff2Ctag.setCanReorder(PropertiesMapper.stringToCanReorder(okapiCode.getProperty("canReorder").getValue()));
        }
        if (okapiCode.hasProperty("canOverlap")) {
            xliff2Ctag.setCanOverlap(PropertiesMapper.stringToBoolean(okapiCode.getProperty("canOverlap").getValue()));
        }
        if (okapiCode.hasProperty("copyOf")) {
            xliff2Ctag.setCopyOf(okapiCode.getProperty("copyOf").getValue());
        }
        if (okapiCode.hasProperty("subFlows")) {
            xliff2Ctag.setSubFlows(okapiCode.getProperty("subFlows").getValue());
        }
        if (okapiCode.hasProperty("type") && (type = okapiCode.getProperty("type").getValue()) != null && !okapiCode.getType().equals("null")) {
            try {
                if (type.startsWith("x-")) {
                    type = type.substring(2);
                }
                xliff2Ctag.setType(type);
            }
            catch (InvalidParameterException e) {
                LoggerFactory.getLogger(PropertiesMapper.class).debug("Could net set MTag type of {}: {}", (Object)xliff2Ctag, (Object)e.getMessage());
            }
        }
        if (okapiCode.hasProperty("subType")) {
            xliff2Ctag.setSubType(okapiCode.getProperty("subType").getValue());
        }
        if (okapiCode.hasProperty("disp")) {
            xliff2Ctag.setDisp(okapiCode.getProperty("disp").getValue());
        }
        if (okapiCode.hasProperty("dir")) {
            xliff2Ctag.setDir(PropertiesMapper.stringToDirection(okapiCode.getProperty("dir").getValue()));
        }
        if (okapiCode.hasProperty("dataDir")) {
            xliff2Ctag.setDataDir(PropertiesMapper.stringToDirection(okapiCode.getProperty("dataDir").getValue()));
        }
        if (okapiCode.hasProperty("dataRef")) {
            xliff2Ctag.setDataRef(okapiCode.getProperty("dataRef").getValue());
        }
        if (okapiCode.hasProperty("equiv")) {
            xliff2Ctag.setEquiv(okapiCode.getProperty("equiv").getValue());
        }
        PropertiesMapper.setExtendedAttributes(okapiCode, (IWithExtAttributes)xliff2Ctag);
    }

    public static void setCodeProperties(Code okapiCode, MTag xliff2Mtag) {
        String type;
        if (okapiCode.hasProperty("translate")) {
            xliff2Mtag.setTranslate(PropertiesMapper.stringToBoolean(okapiCode.getProperty("translate").getValue()));
        }
        if (okapiCode.hasProperty("value")) {
            xliff2Mtag.setValue(okapiCode.getProperty("value").getValue());
        }
        if (okapiCode.hasProperty("ref")) {
            xliff2Mtag.setRef(okapiCode.getProperty("ref").getValue());
        }
        if (okapiCode.hasProperty("type") && (type = okapiCode.getProperty("type").getValue()) != null && !okapiCode.getType().equals("null")) {
            try {
                if (type.startsWith("x-")) {
                    type = type.substring(2);
                }
                xliff2Mtag.setType(type);
            }
            catch (InvalidParameterException e) {
                LoggerFactory.getLogger(PropertiesMapper.class).debug("Could net set MTag type of {}: {}", (Object)xliff2Mtag, (Object)e.getMessage());
            }
        }
        PropertiesMapper.setExtendedAttributes(okapiCode, (IWithExtAttributes)xliff2Mtag);
    }

    public static void setCodeProperties(CTag xliff2Ctag, Code okapiCode) {
        okapiCode.setProperty(new Property("canDelete", PropertiesMapper.booleanToString(xliff2Ctag.getCanDelete()), Property.FILTER_AND_DISPLAY));
        okapiCode.setProperty(new Property("canCopy", PropertiesMapper.booleanToString(xliff2Ctag.getCanCopy()), Property.FILTER_AND_DISPLAY));
        okapiCode.setProperty(new Property("canOverlap", PropertiesMapper.booleanToString(xliff2Ctag.getCanOverlap()), Property.FILTER_AND_DISPLAY));
        if (xliff2Ctag.getCanReorder() != null) {
            okapiCode.setProperty(new Property("canReorder", xliff2Ctag.getCanReorder().toString(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getCopyOf() != null) {
            okapiCode.setProperty(new Property("copyOf", xliff2Ctag.getCopyOf().toString(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getSubFlows() != null) {
            okapiCode.setProperty(new Property("subFlows", xliff2Ctag.getSubFlows(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getDisp() != null) {
            okapiCode.setProperty(new Property("disp", xliff2Ctag.getDisp(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getDir() != null) {
            okapiCode.setProperty(new Property("dir", PropertiesMapper.directionToString(xliff2Ctag.getDir()), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getDataDir() != null) {
            okapiCode.setProperty(new Property("dataDir", PropertiesMapper.directionToString(xliff2Ctag.getDataDir()), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getDataRef() != null) {
            okapiCode.setProperty(new Property("dataRef", xliff2Ctag.getDataRef(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getEquiv() != null) {
            okapiCode.setProperty(new Property("equiv", xliff2Ctag.getEquiv(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getType() != null) {
            okapiCode.setProperty(new Property("type", xliff2Ctag.getType(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Ctag.getSubType() != null) {
            okapiCode.setProperty(new Property("subType", xliff2Ctag.getSubType(), Property.FILTER_AND_DISPLAY));
        }
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliff2Ctag, okapiCode);
    }

    public static void setCodeProperties(MTag xliff2Mtag, Code okapiCode) {
        okapiCode.setProperty(new Property("mtag", xliff2Mtag.getType(), Property.FILTER_AND_DISPLAY));
        if (xliff2Mtag.getTranslate() != null) {
            okapiCode.setProperty(new Property("translate", PropertiesMapper.booleanToString(xliff2Mtag.getTranslate()), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Mtag.getValue() != null) {
            okapiCode.setProperty(new Property("value", xliff2Mtag.getValue(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Mtag.getRef() != null) {
            okapiCode.setProperty(new Property("ref", xliff2Mtag.getRef(), Property.FILTER_AND_DISPLAY));
        }
        if (xliff2Mtag.getType() != null) {
            okapiCode.setProperty(new Property("type", xliff2Mtag.getType(), Property.FILTER_AND_DISPLAY));
        }
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliff2Mtag, okapiCode);
    }

    private static void setExtendedAttributes(IWithExtAttributes xliffElement, Code code) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        Set<String> namespaces = extAttributes.getNamespaces();
        namespaces.forEach(namespaceURI -> {
            String propertyName = "extendedNamespace." + namespaceURI;
            String value = extAttributes.getNamespacePrefix((String)namespaceURI);
            code.setProperty(new Property(propertyName, value, Property.FILTER_AND_DISPLAY));
        });
        extAttributes.forEach(extAttribute -> {
            String propertyName = "extendedAttribute." + extAttribute.getPrefix() + "==" + extAttribute.getQName();
            String value = extAttribute.getValue();
            code.setProperty(new Property(propertyName, value, Property.FILTER_AND_DISPLAY));
        });
    }

    private static void setExtendedAttributes(Code code, IWithExtAttributes xliffElement) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        code.getPropertyNames().stream().filter(p -> p.startsWith("extendedNamespace.")).forEach(annotationName -> {
            String namespaceURI = annotationName.replace("extendedNamespace.", "");
            String prefix = code.getProperty((String)annotationName).getValue();
            extAttributes.setNamespace(prefix, namespaceURI);
        });
        code.getPropertyNames().stream().filter(p -> p.startsWith("extendedAttribute.")).forEach(annotationName -> {
            Matcher matcher = EXTENDED_ATTRIBUTE_KEY_PATTERN.matcher((CharSequence)annotationName);
            boolean found = matcher.find();
            if (found) {
                String namespaceURI = matcher.group(2);
                String localeName = matcher.group(3);
                String value = code.getProperty((String)annotationName).getValue();
                extAttributes.setAttribute(namespaceURI, localeName, value);
            } else {
                LoggerFactory.getLogger(PropertiesMapper.class).warn("Could not find extended attribute information from {}", annotationName);
            }
        });
    }

    private static void setExtendedAttributes(IWithExtAttributes xliffElement, IWithProperties okapiProperties) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        Set<String> namespaces = extAttributes.getNamespaces();
        namespaces.forEach(namespaceURI -> {
            String propertyName = "extendedNamespace." + namespaceURI;
            String value = extAttributes.getNamespacePrefix((String)namespaceURI);
            PropertiesMapper.setProperty(propertyName, value, okapiProperties);
        });
        extAttributes.forEach(extAttribute -> {
            String propertyName = "extendedAttribute." + extAttribute.getPrefix() + "==" + extAttribute.getQName();
            String value = extAttribute.getValue();
            PropertiesMapper.setProperty(propertyName, value, okapiProperties);
        });
    }

    private static void setExtendedAttributes(IWithProperties okapiProperties, IWithExtAttributes xliffElement) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        okapiProperties.getPropertyNames().stream().filter(p -> p.startsWith("extendedNamespace.")).forEach(propertyName -> {
            String namespaceURI = propertyName.replace("extendedNamespace.", "");
            String prefix = PropertiesMapper.getProperty(propertyName, okapiProperties);
            extAttributes.setNamespace(prefix, namespaceURI);
        });
        okapiProperties.getPropertyNames().stream().filter(p -> p.startsWith("extendedAttribute.")).forEach(propertyName -> {
            Matcher matcher = EXTENDED_ATTRIBUTE_KEY_PATTERN.matcher((CharSequence)propertyName);
            boolean found = matcher.find();
            if (found) {
                String namespaceURI = matcher.group(2);
                String localeName = matcher.group(3);
                String value = PropertiesMapper.getProperty(propertyName, okapiProperties);
                extAttributes.setAttribute(namespaceURI, localeName, value);
            } else {
                LoggerFactory.getLogger(PropertiesMapper.class).warn("Could not find extended attribute information from {}", propertyName);
            }
        });
    }

    private static String getProperty(String key, IWithProperties eventWithProperties) {
        Property property = eventWithProperties.getProperty(key);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    private static void setProperty(String key, String value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, value, true, Property.FILTER_AND_DISPLAY));
    }

    private static void setProperty(String key, boolean value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.booleanToString(value), true, Property.FILTER_AND_DISPLAY));
    }

    private static void setProperty(String key, Directionality value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.directionToString(value), true, Property.FILTER_AND_DISPLAY));
    }

    private static void setProperty(String key, TargetState value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.targetStateToString(value), true, Property.FILTER_AND_DISPLAY));
    }

    private static boolean stringToBoolean(String value) {
        return "yes".equals(value);
    }

    private static String booleanToString(boolean value) {
        return value ? "yes" : "no";
    }

    private static Directionality stringToDirection(String value) {
        if (value == null) {
            return Directionality.AUTO;
        }
        if ("NOT ALLOWED".equals(value)) {
            return Directionality.INHERITED;
        }
        return Directionality.valueOf(value.toUpperCase());
    }

    private static CanReorder stringToCanReorder(String value) {
        if (value == null) {
            return CanReorder.YES;
        }
        return CanReorder.valueOf(value.toUpperCase());
    }

    private static String directionToString(Directionality value) {
        return value.toString();
    }

    private static TargetState stringToTargetState(String value) {
        switch (XLIFFFilter.State.fromString(value)) {
            case TRANSLATED: {
                return TargetState.TRANSLATED;
            }
            case SIGNED_OFF: {
                return TargetState.REVIEWED;
            }
            case FINAL: {
                return TargetState.FINAL;
            }
        }
        return TargetState.INITIAL;
    }

    private static String targetStateToString(TargetState value) {
        switch (value) {
            case TRANSLATED: {
                return XLIFFFilter.State.TRANSLATED.toString();
            }
            case REVIEWED: {
                return XLIFFFilter.State.SIGNED_OFF.toString();
            }
            case FINAL: {
                return XLIFFFilter.State.FINAL.toString();
            }
        }
        return XLIFFFilter.State.DEFAULT.toString();
    }
}

