/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.merge;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.MimeTypeMapper;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeMatchStrategy;
import net.sf.okapi.common.resource.CodeMatches;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextPartComparator;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import org.incava.diff.LCS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class TextUnitMerger
implements ITextUnitMerger {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private LocaleId trgLoc;
    private Parameters params = new Parameters();
    private String translatedTuId;
    private CodeMatchStrategy strategy = CodeMatchStrategy.STRICT;

    @Override
    public ITextUnit mergeTargets(ITextUnit tuFromSkel, ITextUnit tuFromTran) {
        if (tuFromSkel == null || tuFromTran == null) {
            this.LOGGER.warn("Null TextUnit in TextUnitMerger.");
            return tuFromSkel;
        }
        this.translatedTuId = tuFromTran.getId();
        if (!tuFromSkel.getId().equals(tuFromTran.getId())) {
            String s = String.format("Text Unit id mismatch during merger: Original id=\"%s\" target id=\"%s\"", tuFromSkel.getId(), tuFromTran.getId());
            this.LOGGER.error(s);
            if (this.params.isThrowSegmentIdException()) {
                throw new OkapiMergeException(s);
            }
        }
        ITextUnit mergedTextUnit = tuFromSkel;
        ITextUnit tuFromSkelClone = tuFromSkel.clone();
        if (this.params.isCopySourceIfNonTextual() && !tuFromSkel.getSource().hasText(true) && (tuFromTran.getTarget(this.trgLoc) == null || tuFromTran.getTarget(this.trgLoc).isEmpty())) {
            mergedTextUnit.setTarget(this.trgLoc, tuFromSkel.getSource().clone());
            return mergedTextUnit;
        }
        if (!tuFromTran.hasTarget(this.trgLoc) || tuFromTran.getTarget(this.trgLoc) == null) {
            this.LOGGER.warn("No translation found for TU id='{}'.", (Object)tuFromTran.getId());
            return mergedTextUnit;
        }
        boolean isTransApproved = false;
        Property traProp = tuFromTran.getTarget(this.trgLoc).getProperty("approved");
        if (traProp != null) {
            isTransApproved = traProp.getValue().equals("yes");
        }
        if (this.params != null && this.params.isApprovedOnly() && !isTransApproved) {
            this.LOGGER.warn("Item id='{}': Target is not approved. Using empty translation.", (Object)tuFromSkel.getId());
            mergedTextUnit.setTarget(this.trgLoc, null);
            return mergedTextUnit;
        }
        mergedTextUnit.setSource(tuFromTran.getSource().clone());
        mergedTextUnit.setTarget(this.trgLoc, tuFromTran.getTarget(this.trgLoc).clone());
        IResource.copy(tuFromSkelClone.getSource(), mergedTextUnit.getSource());
        IResource.copy(tuFromSkelClone.getTarget(this.trgLoc), mergedTextUnit.getTarget(this.trgLoc));
        boolean segmentationSupported = MimeTypeMapper.isSegmentationSupported(tuFromSkelClone.getMimeType());
        boolean keepCodeIds = true;
        List<Range> srcRanges = null;
        List<Range> trgRanges = null;
        if (!mergedTextUnit.getSource().contentIsOneSegment()) {
            srcRanges = mergedTextUnit.getSource().getSegments().getRanges(true);
        }
        if (!mergedTextUnit.getTarget(this.trgLoc).contentIsOneSegment()) {
            trgRanges = mergedTextUnit.getTarget(this.trgLoc).getSegments().getRanges(true);
        }
        for (TextPart tp : mergedTextUnit.getSource().getSegments()) {
            if (!TextUnitUtil.hasMergedCode(tp.text)) continue;
            tp.text = TextUnitUtil.expandCodes(tp.text);
        }
        for (TextPart tp : mergedTextUnit.getTarget(this.trgLoc).getSegments()) {
            if (!TextUnitUtil.hasMergedCode(tp.text)) continue;
            tp.text = TextUnitUtil.expandCodes(tp.text);
        }
        if (!mergedTextUnit.getSource().contentIsOneSegment()) {
            mergedTextUnit.getSource().getSegments().joinAll(true);
        }
        if (!mergedTextUnit.getTarget(this.trgLoc).contentIsOneSegment()) {
            mergedTextUnit.getTarget(this.trgLoc).getSegments().joinAll(true);
        }
        this.removeOuterData(mergedTextUnit.getSource().getFirstContent().getCodes());
        this.removeOuterData(mergedTextUnit.getTarget(this.trgLoc).getFirstContent().getCodes());
        TextContainer skelSource = tuFromSkelClone.getSource();
        TextContainer skelTarget = tuFromSkelClone.getTarget(this.trgLoc);
        if (!skelSource.contentIsOneSegment()) {
            skelSource = tuFromSkelClone.getSource().clone();
            skelSource.getSegments().joinAll(true);
        }
        if (skelTarget != null && !skelTarget.contentIsOneSegment()) {
            skelTarget = tuFromSkelClone.getTarget(this.trgLoc).clone();
            skelTarget.getSegments().joinAll(true);
        }
        if (this.params.isCopyCodeMetadata()) {
            this.copyCodeMetadata(skelSource.getFirstContent(), mergedTextUnit.getSource().getFirstContent());
            this.copyCodeMetadata(mergedTextUnit.getSource().getFirstContent(), mergedTextUnit.getTarget(this.trgLoc).getFirstContent());
            if (!this.params.isSkipOriginalTargetCodeMetadata() && skelTarget != null && skelTarget.hasCode()) {
                this.copyCodeMetadata(skelTarget.getFirstContent(), mergedTextUnit.getTarget(this.trgLoc).getFirstContent());
            }
        } else {
            this.copyCodeMetadata(skelSource.getFirstContent(), mergedTextUnit.getSource().getFirstContent().clone());
            this.copyCodeMetadata(mergedTextUnit.getSource().getFirstContent(), mergedTextUnit.getTarget(this.trgLoc).getFirstContent().clone());
            if (skelTarget != null && skelTarget.hasCode()) {
                this.copyCodeMetadata(skelTarget.getFirstContent(), mergedTextUnit.getTarget(this.trgLoc).getFirstContent().clone());
            }
        }
        if (srcRanges != null && segmentationSupported) {
            mergedTextUnit.getSource().getSegments().create(srcRanges, true, ISegments.MetaCopyStrategy.IDENTITY);
        }
        if (trgRanges != null && segmentationSupported) {
            mergedTextUnit.getTarget(this.trgLoc).getSegments().create(trgRanges, true, ISegments.MetaCopyStrategy.IDENTITY);
        }
        if (mergedTextUnit.getSource().getSegments().count() != mergedTextUnit.getTarget(this.trgLoc).getSegments().count()) {
            this.LOGGER.warn("Item id='{}': Different number of source and target segments.", (Object)tuFromTran.getId());
        }
        this.copyTextPartMetadata(tuFromSkelClone.getSource().getParts(), mergedTextUnit.getSource().getParts(), mergedTextUnit.getId());
        if (tuFromSkelClone.hasTarget(this.trgLoc)) {
            this.copyTextPartMetadata(tuFromSkelClone.getTarget(this.trgLoc).getParts(), mergedTextUnit.getTarget(this.trgLoc).getParts(), mergedTextUnit.getId());
        }
        mergedTextUnit.getSource().setHasBeenSegmentedFlag(tuFromTran.getSource().hasBeenSegmented());
        mergedTextUnit.getTarget(this.trgLoc).setHasBeenSegmentedFlag(tuFromTran.getTarget(this.trgLoc).hasBeenSegmented());
        return mergedTextUnit;
    }

    @Override
    public void copyTextPartMetadata(List<TextPart> from, List<TextPart> to, String id) {
        if (Util.isEmpty(from) || Util.isEmpty(to)) {
            return;
        }
        TextPartComparator cmp = new TextPartComparator();
        boolean[] matched = new boolean[to.size()];
        Arrays.fill(matched, false);
        LCS diff = new LCS(from, to, (Comparator)cmp);
        List matches = diff.getMatches();
        int n = -1;
        for (Integer m : matches) {
            TextPart toPart;
            TextPart origPart = from.get(++n);
            if (m == null) {
                toPart = Util.findMatch(origPart, to, matched, cmp);
                if (toPart == null) {
                    if (this.hasMeta(origPart)) {
                        this.LOGGER.error("TextUnit id='{}' TextPart id='{}': Can't find matching TextPart in merged text unit. Cannot copy TextPart properties/annotations. Merged file may differ from original", (Object)id, (Object)origPart.id);
                        continue;
                    }
                    this.LOGGER.warn("TextUnit id='{}' TextPart id='{}': Can't find matching TextPart in merged text unit. Possible segmentation changes in the translated file", (Object)id, (Object)origPart.id);
                    continue;
                }
            } else {
                toPart = to.get(m);
                matched[m.intValue()] = true;
            }
            toPart.id = origPart.id;
            toPart.originalId = origPart.originalId;
            toPart.whitespaceStrategy = origPart.whitespaceStrategy;
            IResource.copy(origPart, toPart);
        }
    }

    public <T extends TextPart> boolean hasMeta(T p) {
        boolean hasProps = !p.getPropertyNames().isEmpty();
        boolean hasAnnotations = p.getAnnotations().iterator().hasNext();
        return hasProps || hasAnnotations || p.id != null;
    }

    @Override
    public void copyCodeMetadata(TextFragment from, TextFragment to) {
        CodeMatches m = TextFragmentUtil.alignAndCopyCodeMetadata(from, to, this.params.isAddMissing(), false, this.strategy);
        if (m.hasFromMismatch(false) || m.hasToMismatch(false)) {
            TextFragmentUtil.logCodeMismatchErrors(m, from, to, this.translatedTuId);
            if (this.params.isThrowCodeException()) {
                throw new OkapiMergeException("TextUnit Merge Error for TU: " + this.translatedTuId);
            }
        }
    }

    private void removeOuterData(List<Code> codes) {
        for (Code c : codes) {
            c.setOuterData(null);
        }
    }

    @Override
    public void setTargetLocale(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(Parameters params) {
        this.params = params;
    }

    @Override
    public void setCodeMatchStrategy(CodeMatchStrategy strategy) {
        this.strategy = strategy;
    }
}

