/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.okapi.lib.search.lucene.scorer.TmFuzzyScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class TmFuzzyQuery
extends Query {
    float threshold;
    List<Term> terms;
    String termCountField;

    public TmFuzzyQuery(float threshold, String termCountField) {
        this.threshold = threshold;
        this.terms = new ArrayList<Term>();
        this.termCountField = termCountField;
    }

    public void add(Term term) {
        this.terms.add(term);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new TmFuzzyWeight(this);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void visit(QueryVisitor visitor) {
        visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TmFuzzyQuery)) {
            return false;
        }
        TmFuzzyQuery that = (TmFuzzyQuery)((Object)o);
        if (Float.compare(that.threshold, this.threshold) != 0) {
            return false;
        }
        if (!this.terms.equals(that.terms)) {
            return false;
        }
        return this.termCountField.equals(that.termCountField);
    }

    public int hashCode() {
        int result = this.threshold != 0.0f ? Float.floatToIntBits(this.threshold) : 0;
        result = 31 * result + this.terms.hashCode();
        result = 31 * result + this.termCountField.hashCode();
        return result;
    }

    public String toString(String field) {
        return this.terms.toString();
    }

    protected class TmFuzzyWeight
    extends Weight {
        public TmFuzzyWeight(Query query) throws IOException {
            super(query);
        }

        @Deprecated
        public void extractTerms(Set<Term> set) {
            this.getQuery().visit(QueryVisitor.termCollector(set));
        }

        public Explanation explain(LeafReaderContext leafReaderContext, int i) throws IOException {
            return Explanation.match((Number)Float.valueOf(1.0f), (String)"Sorry, TmFuzzyWeight.explain(...) not fully implemented", (Explanation[])new Explanation[0]);
        }

        public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
            if (TmFuzzyQuery.this.terms.isEmpty()) {
                return null;
            }
            return new TmFuzzyScorer(TmFuzzyQuery.this.threshold, this, TmFuzzyQuery.this.terms, (IndexReader)leafReaderContext.reader(), TmFuzzyQuery.this.termCountField);
        }

        public boolean isCacheable(LeafReaderContext leafReaderContext) {
            return false;
        }
    }
}

