/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.scorer;

import java.io.IOException;
import java.util.HashSet;
import net.sf.okapi.common.exceptions.OkapiException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class Util {
    public static float calculateDiceCoefficient(int intersection, int size1, int size2) {
        return 2.0f * (float)intersection / (float)(size1 + size2) * 100.0f;
    }

    public static float calculateNgramDiceCoefficient(String originalSource, String newSource, Analyzer triGramAnalyzer) {
        CharTermAttribute termAtt;
        TokenStream stream;
        HashSet<String> originalSourceTokens = new HashSet<String>();
        HashSet<String> newSourceTokens = new HashSet<String>();
        try {
            stream = triGramAnalyzer.tokenStream("", originalSource);
            try {
                termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                stream.reset();
                while (stream.incrementToken()) {
                    originalSourceTokens.add(termAtt.toString());
                }
                stream.end();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new OkapiException("Error tokenizing source TextUnits", e);
        }
        try {
            stream = triGramAnalyzer.tokenStream("", newSource);
            try {
                termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                stream.reset();
                while (stream.incrementToken()) {
                    newSourceTokens.add(termAtt.toString());
                }
                stream.end();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new OkapiException("Error tokenizing source TextUnits", e);
        }
        int originalSize = originalSourceTokens.size();
        int newSize = newSourceTokens.size();
        originalSourceTokens.retainAll(newSourceTokens);
        int intersection = originalSourceTokens.size();
        return 2.0f * (float)intersection / (float)(originalSize + newSize) * 100.0f;
    }
}

