/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.segmentation.CompiledRule;
import net.sf.okapi.lib.segmentation.SegmentationRuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRXSegmenter
implements ISegmenter {
    private static final String ISOLATED_CODE_REPLACEMENT_TEXT = " ";
    private static final int CODE_MARKER_LENGTH = 2;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private boolean segmentSubFlows;
    private boolean cascade;
    private boolean includeStartCodes;
    private boolean includeEndCodes;
    private boolean includeIsolatedCodes;
    private LocaleId currentLanguageCode;
    private boolean oneSegmentIncludesAll;
    private boolean trimLeadingWS;
    private boolean trimTrailingWS;
    private boolean useJavaRegex;
    private boolean useIcu4JBreakRules = false;
    private boolean trimCodes;
    private boolean treatIsolatedCodesAsWhitespace;
    private ArrayList<CompiledRule> rules;
    private Pattern maskRule;
    private TreeMap<Integer, Boolean> splits;
    private List<Integer> finalSplits;
    private ArrayList<Integer> starts;
    private ArrayList<Integer> ends;
    private BreakIterator icu4jBreakIterator;

    public SRXSegmenter() {
        this.reset();
    }

    @Override
    public void reset() {
        this.currentLanguageCode = null;
        this.rules = new ArrayList();
        this.maskRule = null;
        this.splits = null;
        this.segmentSubFlows = true;
        this.cascade = false;
        this.includeStartCodes = false;
        this.includeEndCodes = true;
        this.includeIsolatedCodes = false;
        this.oneSegmentIncludesAll = false;
        this.trimLeadingWS = false;
        this.trimTrailingWS = false;
        this.useJavaRegex = true;
        this.trimCodes = false;
        this.treatIsolatedCodesAsWhitespace = false;
        this.useIcu4JBreakRules = false;
    }

    public void setOptions(boolean segmentSubFlows, boolean includeStartCodes, boolean includeEndCodes, boolean includeIsolatedCodes, boolean oneSegmentIncludesAll, boolean trimLeadingWS, boolean trimTrailingWS, boolean useJavaRegex, boolean useIcu4JBreakRules, boolean treatIsolatedCodesAsWhitespace) {
        this.segmentSubFlows = segmentSubFlows;
        this.includeStartCodes = includeStartCodes;
        this.includeEndCodes = includeEndCodes;
        this.includeIsolatedCodes = includeIsolatedCodes;
        this.oneSegmentIncludesAll = oneSegmentIncludesAll;
        this.trimLeadingWS = trimLeadingWS;
        this.trimTrailingWS = trimTrailingWS;
        this.useJavaRegex = useJavaRegex;
        this.useIcu4JBreakRules = useIcu4JBreakRules;
        this.treatIsolatedCodesAsWhitespace = treatIsolatedCodesAsWhitespace;
        if (!useJavaRegex) {
            this.LOGGER.error("Use of ICU regex has been removed.");
        }
    }

    @Override
    public void setOptions(boolean segmentSubFlows, boolean includeStartCodes, boolean includeEndCodes, boolean includeIsolatedCodes, boolean oneSegmentIncludesAll, boolean trimLeadingWS, boolean trimTrailingWS) {
        this.segmentSubFlows = segmentSubFlows;
        this.includeStartCodes = includeStartCodes;
        this.includeEndCodes = includeEndCodes;
        this.includeIsolatedCodes = includeIsolatedCodes;
        this.oneSegmentIncludesAll = oneSegmentIncludesAll;
        this.trimLeadingWS = trimLeadingWS;
        this.trimTrailingWS = trimTrailingWS;
    }

    @Override
    public boolean oneSegmentIncludesAll() {
        return this.oneSegmentIncludesAll;
    }

    @Override
    public boolean segmentSubFlows() {
        return this.segmentSubFlows;
    }

    public boolean cascade() {
        return this.cascade;
    }

    @Override
    public boolean trimLeadingWhitespaces() {
        return this.trimLeadingWS;
    }

    @Override
    public boolean trimTrailingWhitespaces() {
        return this.trimTrailingWS;
    }

    public boolean useJavaRegex() {
        return this.useJavaRegex;
    }

    @Override
    public boolean treatIsolatedCodesAsWhitespace() {
        return this.treatIsolatedCodesAsWhitespace;
    }

    public void setUseJavaRegex(boolean useJavaRegex) {
        this.useJavaRegex = useJavaRegex;
        if (!useJavaRegex) {
            this.LOGGER.warn("Use of ICU regex is deprecated and may be removed in the future.");
        }
    }

    @Override
    public boolean includeStartCodes() {
        return this.includeStartCodes;
    }

    @Override
    public boolean includeEndCodes() {
        return this.includeEndCodes;
    }

    @Override
    public boolean includeIsolatedCodes() {
        return this.includeIsolatedCodes;
    }

    @Override
    public int computeSegments(String text) {
        TextContainer tmp = new TextContainer(text);
        return this.computeSegments(tmp);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int computeSegments(TextContainer container) {
        int n;
        Matcher m;
        CompiledRule r;
        if (this.currentLanguageCode == null) {
            throw new SegmentationRuleException("No language defined for the segmenter.");
        }
        boolean hasCode = container.hasCode();
        boolean isSCWS = this.trimCodes && !this.includeStartCodes;
        boolean isECWS = this.trimCodes && !this.includeEndCodes;
        boolean isICWS = this.trimCodes && !this.includeIsolatedCodes;
        String codedText = container.getCodedText(true);
        List<Integer> origCodePositions = this.storeOriginalCodePositions(codedText);
        List<Integer> codePositions = this.storeCodePositions(codedText);
        codedText = this.treatIsolatedCodesAsWhitespace ? TextUnitUtil.removeAndReplaceCodes(codedText, ISOLATED_CODE_REPLACEMENT_TEXT) : TextUnitUtil.removeCodes(codedText);
        ArrayList<CompiledRule> combinedRules = new ArrayList<CompiledRule>(this.rules);
        if (this.useIcu4JBreakRules && (r = this.getIcu4jBreakRules(codedText)) != null) {
            combinedRules.add(r);
        }
        this.splits = new TreeMap();
        for (CompiledRule compiledRule : combinedRules) {
            int n2;
            if (!Util.isEmpty(compiledRule.breakPositions)) {
                for (Integer b : compiledRule.breakPositions) {
                    if (b > codedText.length() || this.splits.containsKey(b)) continue;
                    this.splits.put(b, compiledRule.isBreak);
                }
                continue;
            }
            m = compiledRule.pattern.matcher(codedText);
            m.useTransparentBounds(true);
            boolean bl = false;
            int prevStart = -1;
            while (n2 != prevStart && m.find(n2)) {
                int n3 = m.start() + m.group(1).length();
                prevStart = n2;
                n2 = n3;
                if (n3 > codedText.length() || this.splits.containsKey(n3)) continue;
                this.splits.put(n3, compiledRule.isBreak);
            }
        }
        codedText = container.getCodedText(true);
        TreeMap<Integer, Boolean> oldSplits = this.splits;
        this.splits = new TreeMap();
        for (Integer n4 : oldSplits.keySet()) {
            int newPos = this.recalcPos(codedText, n4, codePositions, origCodePositions);
            this.splits.put(newPos, oldSplits.get(n4));
        }
        if (this.maskRule != null) {
            m = this.maskRule.matcher(codedText);
            while (m.find()) {
                void var12_15;
                int n5 = m.start();
                while (var12_15 < m.end()) {
                    this.splits.remove((int)var12_15);
                    ++var12_15;
                }
                if (m.start() > 0) {
                    this.splits.put(m.start(), true);
                }
                this.splits.put(m.end(), true);
            }
        }
        this.finalSplits = new ArrayList<Integer>();
        if (hasCode) {
            EnumSet<TextFragment.Marker> enumSet = EnumSet.noneOf(TextFragment.Marker.class);
            if (this.includeStartCodes) {
                enumSet.add(TextFragment.Marker.OPENING);
            }
            if (this.includeEndCodes) {
                enumSet.add(TextFragment.Marker.CLOSING);
            }
            if (this.includeIsolatedCodes) {
                enumSet.add(TextFragment.Marker.ISOLATED);
            }
            for (int pos2 : this.splits.keySet()) {
                if (!this.splits.get(pos2).booleanValue() || pos2 >= codedText.length()) continue;
                TextFragment.Marker codeMarkerType = TextFragment.Marker.asEnum(codedText.charAt(pos2));
                switch (codeMarkerType) {
                    case OPENING: 
                    case CLOSING: 
                    case ISOLATED: {
                        if (!enumSet.contains((Object)codeMarkerType)) break;
                        while ((pos2 += 2) < codedText.length() - 1 && enumSet.contains((Object)TextFragment.Marker.asEnum(codedText.charAt(pos2)))) {
                        }
                        break;
                    }
                }
                this.finalSplits.add(pos2);
            }
        } else {
            for (int n6 : this.splits.keySet()) {
                if (!this.splits.get(n6).booleanValue()) continue;
                this.finalSplits.add(n6);
            }
        }
        this.starts = new ArrayList();
        this.ends = new ArrayList();
        boolean bl = false;
        for (int pos : this.finalSplits) {
            void var12_21;
            int trimmedTextStart;
            if (pos >= codedText.length() || (trimmedTextStart = TextFragment.indexOfFirstNonWhitespace(codedText, n, pos - 1, isSCWS, isECWS, isICWS, this.trimLeadingWS)) == -1) continue;
            if (this.trimLeadingWS || this.trimCodes) {
                n = trimmedTextStart;
            }
            if (this.trimTrailingWS || this.trimCodes) {
                int n7 = TextFragment.indexOfLastNonWhitespace(codedText, pos - 1, 0, isSCWS, isECWS, isICWS, this.trimTrailingWS);
            } else {
                int n8 = pos - 1;
            }
            if (var12_21 >= n) {
                void var12_22;
                if (var12_21 < pos) {
                    ++var12_22;
                }
                this.starts.add(n);
                this.ends.add((int)var12_22);
            }
            n = pos;
        }
        int lastPos = codedText.length();
        if (n < lastPos) {
            int n9;
            int trimmedTextStart = TextFragment.indexOfFirstNonWhitespace(codedText, n, lastPos - 1, isSCWS, isECWS, isICWS, this.trimLeadingWS);
            if ((this.trimLeadingWS || this.trimCodes) && trimmedTextStart != -1) {
                n9 = trimmedTextStart;
            }
            if (trimmedTextStart != -1 && trimmedTextStart < lastPos) {
                void var12_25;
                if (this.trimTrailingWS || this.trimCodes) {
                    int n10 = TextFragment.indexOfLastNonWhitespace(codedText, lastPos - 1, n9, isSCWS, isECWS, isICWS, this.trimTrailingWS);
                } else {
                    int n11 = lastPos - 1;
                }
                if (var12_25 >= n9) {
                    void var12_26;
                    if (var12_25 < lastPos) {
                        ++var12_26;
                    }
                    this.starts.add(n9);
                    this.ends.add((int)var12_26);
                }
            }
        }
        if (this.starts.size() == 1 && this.oneSegmentIncludesAll) {
            this.starts.set(0, 0);
            this.ends.clear();
        }
        this.ends.add(lastPos);
        return this.starts.size();
    }

    private CompiledRule getIcu4jBreakRules(String text) {
        CompiledRule rule = null;
        this.icu4jBreakIterator.setText(text);
        ArrayList<Integer> breakPositions = new ArrayList<Integer>();
        int boundary = this.icu4jBreakIterator.next();
        while (boundary != -1) {
            if (boundary != text.length()) {
                while (boundary - 1 > 0 && Character.isWhitespace(text.codePointAt(boundary - 1))) {
                    --boundary;
                }
                if (boundary < text.length() && !breakPositions.contains(boundary)) {
                    breakPositions.add(boundary);
                }
            }
            boundary = this.icu4jBreakIterator.next();
        }
        if (!breakPositions.isEmpty()) {
            rule = new CompiledRule(breakPositions);
        }
        return rule;
    }

    private int calculatePosition(int position, int numberOfNonIsolatedCodes, int numberOfIsolatedCodes, boolean increase) {
        int nonIsolatedCodesLength = numberOfNonIsolatedCodes * 2;
        int isolatedCodesLength = numberOfIsolatedCodes * (this.treatIsolatedCodesAsWhitespace() ? ISOLATED_CODE_REPLACEMENT_TEXT.length() : 2);
        return increase ? position + nonIsolatedCodesLength + isolatedCodesLength : position - nonIsolatedCodesLength - isolatedCodesLength;
    }

    private int calculateIncreasedPosition(int position, int numberOfNonIsolatedCodes, int numberOfIsolatedCodes) {
        return this.calculatePosition(position, numberOfNonIsolatedCodes, numberOfIsolatedCodes, true);
    }

    private int calculateDecreasedPosition(int position, int numberOfNonIsolatedCodes, int numberOfIsolatedCodes) {
        return this.calculatePosition(position, numberOfNonIsolatedCodes, numberOfIsolatedCodes, false);
    }

    int recalcPos(String codedText, int pos, List<Integer> codePositions, List<Integer> origCodePositions) {
        int numberOfNonIsolatedCodes = 0;
        int numberOfIsolatedCodes = 0;
        block4: for (int codeIndex = 0; codeIndex < codePositions.size(); ++codeIndex) {
            if (codePositions.get(codeIndex) >= pos) {
                return this.calculateIncreasedPosition(pos, numberOfNonIsolatedCodes, numberOfIsolatedCodes);
            }
            switch (TextFragment.Marker.asEnum(codedText.charAt(origCodePositions.get(codeIndex)))) {
                case OPENING: 
                case CLOSING: {
                    ++numberOfNonIsolatedCodes;
                    continue block4;
                }
                case ISOLATED: {
                    ++numberOfIsolatedCodes;
                    continue block4;
                }
            }
        }
        return this.calculateIncreasedPosition(pos, numberOfNonIsolatedCodes, numberOfIsolatedCodes);
    }

    List<Integer> storeCodePositions(String text) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int numberOfNonIsolatedCodes = 0;
        int numberOfIsolatedCodes = 0;
        block4: for (int i = 0; i < text.length(); ++i) {
            switch (TextFragment.Marker.asEnum(text.charAt(i))) {
                case OPENING: 
                case CLOSING: {
                    res.add(this.calculateDecreasedPosition(i, numberOfNonIsolatedCodes, numberOfIsolatedCodes));
                    ++numberOfNonIsolatedCodes;
                    ++i;
                    continue block4;
                }
                case ISOLATED: {
                    res.add(this.calculateDecreasedPosition(i, numberOfNonIsolatedCodes, numberOfIsolatedCodes));
                    ++numberOfIsolatedCodes;
                    ++i;
                    continue block4;
                }
            }
        }
        return res;
    }

    List<Integer> storeOriginalCodePositions(String text) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    res.add(i++);
                    continue block3;
                }
            }
        }
        return res;
    }

    @Override
    public Range getNextSegmentRange(TextContainer container) {
        return null;
    }

    @Override
    public List<Integer> getSplitPositions() {
        if (this.finalSplits == null) {
            this.finalSplits = new ArrayList<Integer>();
        }
        return Collections.unmodifiableList(this.finalSplits);
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> list = new ArrayList<Range>();
        if (this.starts == null) {
            return null;
        }
        for (int i = 0; i < this.starts.size(); ++i) {
            list.add(new Range(this.starts.get(i), this.ends.get(i)));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public LocaleId getLanguage() {
        return this.currentLanguageCode;
    }

    @Override
    public void setLanguage(LocaleId languageCode) {
        if (languageCode != null) {
            this.icu4jBreakIterator = RuleBasedBreakIterator.getSentenceInstance((ULocale)ULocale.createCanonical((String)languageCode.toBCP47()));
        }
        this.currentLanguageCode = languageCode;
    }

    protected void setCascade(boolean value) {
        this.cascade = value;
    }

    protected void addRule(CompiledRule compiledRule) {
        this.rules.add(compiledRule);
    }

    protected void setMaskRule(String pattern) {
        this.maskRule = pattern != null && pattern.length() > 0 ? Pattern.compile(pattern, 256) : null;
    }

    @Override
    public void setSegmentSubFlows(boolean segmentSubFlows) {
        this.segmentSubFlows = segmentSubFlows;
    }

    @Override
    public void setIncludeStartCodes(boolean includeStartCodes) {
        this.includeStartCodes = includeStartCodes;
    }

    @Override
    public void setIncludeEndCodes(boolean includeEndCodes) {
        this.includeEndCodes = includeEndCodes;
    }

    @Override
    public void setIncludeIsolatedCodes(boolean includeIsolatedCodes) {
        this.includeIsolatedCodes = includeIsolatedCodes;
    }

    @Override
    public void setOneSegmentIncludesAll(boolean oneSegmentIncludesAll) {
        this.oneSegmentIncludesAll = oneSegmentIncludesAll;
    }

    @Override
    public void setTrimLeadingWS(boolean trimLeadingWS) {
        this.trimLeadingWS = trimLeadingWS;
    }

    @Override
    public void setTrimTrailingWS(boolean trimTrailingWS) {
        this.trimTrailingWS = trimTrailingWS;
    }

    @Override
    public void setTrimCodes(boolean trimCodes) {
        this.trimCodes = trimCodes;
    }

    @Override
    public void setTreatIsolatedCodesAsWhitespace(boolean treatIsolatedCodesAsWhitespace) {
        this.treatIsolatedCodesAsWhitespace = treatIsolatedCodesAsWhitespace;
    }
}

